/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.mergeentries.newmergedialog.toolbar;

import com.airhacks.afterburner.views.ViewLoader;
import com.google.common.base.Enums;
import com.tobiasdiez.easybind.EasyBind;
import com.tobiasdiez.easybind.EasyBinding;
import jakarta.inject.Inject;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.RadioButton;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.AnchorPane;
import javafx.util.StringConverter;
import org.jabref.gui.mergeentries.newmergedialog.DiffMethod;
import org.jabref.gui.mergeentries.newmergedialog.diffhighlighter.DiffHighlighter;
import org.jabref.logic.l10n.Localization;
import org.jabref.preferences.MergeDialogPreferences;
import org.jabref.preferences.PreferencesService;

public class ThreeWayMergeToolbar
extends AnchorPane {
    @FXML
    private RadioButton highlightCharactersRadioButtons;
    @FXML
    private RadioButton highlightWordsRadioButton;
    @FXML
    private ToggleGroup diffHighlightingMethodToggleGroup;
    @FXML
    private ComboBox<DiffView> diffViewComboBox;
    @FXML
    private ComboBox<PlainTextOrDiff> plainTextOrDiffComboBox;
    @FXML
    private Button selectLeftEntryValuesButton;
    @FXML
    private Button selectRightEntryValuesButton;
    @FXML
    private CheckBox onlyShowChangedFieldsCheck;
    @FXML
    private CheckBox applyToAllEntriesCheck;
    @Inject
    private PreferencesService preferencesService;
    private final ObjectProperty<DiffMethod> diffHighlightingMethod = new SimpleObjectProperty();
    private final BooleanProperty onlyShowChangedFields = new SimpleBooleanProperty();
    private final BooleanProperty applyToAllEntries = new SimpleBooleanProperty();
    private EasyBinding<Boolean> showDiff;

    public ThreeWayMergeToolbar() {
        ViewLoader.view((Object)((Object)this)).root((Object)this).load();
    }

    @FXML
    public void initialize() {
        this.showDiff = EasyBind.map((ObservableValue)this.plainTextOrDiffComboBox.valueProperty(), plainTextOrDiff -> plainTextOrDiff == PlainTextOrDiff.Diff);
        this.plainTextOrDiffComboBox.getItems().addAll((Object[])PlainTextOrDiff.values());
        this.plainTextOrDiffComboBox.setConverter((StringConverter)new StringConverter<PlainTextOrDiff>(this){

            public String toString(PlainTextOrDiff plainTextOrDiff) {
                return plainTextOrDiff.getValue();
            }

            public PlainTextOrDiff fromString(String string) {
                return PlainTextOrDiff.fromString(string);
            }
        });
        this.diffViewComboBox.disableProperty().bind(this.notShowDiffProperty());
        this.diffViewComboBox.getItems().addAll((Object[])DiffView.values());
        this.diffViewComboBox.setConverter((StringConverter)new StringConverter<DiffView>(this){

            public String toString(DiffView diffView) {
                return diffView.getValue();
            }

            public DiffView fromString(String string) {
                return DiffView.fromString(string);
            }
        });
        this.highlightWordsRadioButton.disableProperty().bind(this.notShowDiffProperty());
        this.highlightCharactersRadioButtons.disableProperty().bind(this.notShowDiffProperty());
        this.diffHighlightingMethodToggleGroup.selectedToggleProperty().addListener(observable -> {
            if (this.diffHighlightingMethodToggleGroup.getSelectedToggle().equals((Object)this.highlightCharactersRadioButtons)) {
                this.diffHighlightingMethod.set((Object)DiffHighlighter.BasicDiffMethod.CHARS);
            } else {
                this.diffHighlightingMethod.set((Object)DiffHighlighter.BasicDiffMethod.WORDS);
            }
        });
        this.onlyShowChangedFieldsCheck.selectedProperty().bindBidirectional((Property)this.preferencesService.getMergeDialogPreferences().mergeShowChangedFieldOnlyProperty());
        this.onlyShowChangedFields.bind((ObservableValue)this.onlyShowChangedFieldsCheck.selectedProperty());
        this.applyToAllEntriesCheck.selectedProperty().bindBidirectional((Property)this.preferencesService.getMergeDialogPreferences().mergeApplyToAllEntriesProperty());
        this.applyToAllEntries.bind((ObservableValue)this.applyToAllEntriesCheck.selectedProperty());
        this.loadSavedConfiguration();
    }

    private void loadSavedConfiguration() {
        MergeDialogPreferences mergeDialogPreferences = this.preferencesService.getMergeDialogPreferences();
        PlainTextOrDiff plainTextOrDiffPreference = mergeDialogPreferences.getMergeShouldShowDiff() ? PlainTextOrDiff.Diff : PlainTextOrDiff.PLAIN_TEXT;
        this.plainTextOrDiffComboBox.getSelectionModel().select((Object)plainTextOrDiffPreference);
        DiffView diffViewPreference = mergeDialogPreferences.getMergeShouldShowUnifiedDiff() ? DiffView.UNIFIED : DiffView.SPLIT;
        this.diffViewComboBox.getSelectionModel().select((Object)diffViewPreference);
        this.diffHighlightingMethodToggleGroup.selectToggle((Toggle)(mergeDialogPreferences.getMergeHighlightWords() ? this.highlightWordsRadioButton : this.highlightCharactersRadioButtons));
    }

    public void saveToolbarConfiguration() {
        this.preferencesService.getMergeDialogPreferences().setMergeShouldShowDiff(this.plainTextOrDiffComboBox.getValue() == PlainTextOrDiff.Diff);
        this.preferencesService.getMergeDialogPreferences().setMergeShouldShowUnifiedDiff(this.diffViewComboBox.getValue() == DiffView.UNIFIED);
        boolean highlightWordsRadioButtonValue = this.diffHighlightingMethodToggleGroup.getSelectedToggle().equals((Object)this.highlightWordsRadioButton);
        this.preferencesService.getMergeDialogPreferences().setMergeHighlightWords(highlightWordsRadioButtonValue);
    }

    public ObjectProperty<DiffView> diffViewProperty() {
        return this.diffViewComboBox.valueProperty();
    }

    public DiffView getDiffView() {
        return (DiffView)((Object)this.diffViewProperty().get());
    }

    public void setDiffView(DiffView diffView) {
        this.diffViewProperty().set((Object)diffView);
    }

    public EasyBinding<Boolean> showDiffProperty() {
        return this.showDiff;
    }

    public void setShowDiff(boolean showDiff) {
        this.plainTextOrDiffComboBox.valueProperty().set((Object)(showDiff ? PlainTextOrDiff.Diff : PlainTextOrDiff.PLAIN_TEXT));
    }

    public BooleanProperty hideEqualFieldsProperty() {
        return this.onlyShowChangedFields;
    }

    public boolean shouldHideEqualFields() {
        return this.onlyShowChangedFields.get();
    }

    public EasyBinding<Boolean> notShowDiffProperty() {
        return this.showDiffProperty().map(showDiff -> showDiff == false);
    }

    public Boolean shouldShowDiffs() {
        return (Boolean)this.showDiffProperty().get();
    }

    public ObjectProperty<DiffMethod> diffHighlightingMethodProperty() {
        return this.diffHighlightingMethod;
    }

    public DiffMethod getDiffHighlightingMethod() {
        return (DiffMethod)this.diffHighlightingMethodProperty().get();
    }

    public void setDiffHighlightingMethod(DiffMethod diffHighlightingMethod) {
        this.diffHighlightingMethodProperty().set((Object)diffHighlightingMethod);
    }

    public void setOnSelectLeftEntryValuesButtonClicked(Runnable onClick) {
        this.selectLeftEntryValuesButton.setOnMouseClicked(e -> onClick.run());
    }

    public void setOnSelectRightEntryValuesButtonClicked(Runnable onClick) {
        this.selectRightEntryValuesButton.setOnMouseClicked(e -> onClick.run());
    }

    public static enum PlainTextOrDiff {
        PLAIN_TEXT(Localization.lang("Plain Text", new Object[0])),
        Diff(Localization.lang("Show Diff", new Object[0]));

        private final String value;

        private PlainTextOrDiff(String value) {
            this.value = value;
        }

        public static PlainTextOrDiff parse(String name) {
            return (PlainTextOrDiff)((Object)Enums.getIfPresent(PlainTextOrDiff.class, (String)name).or((Object)Diff));
        }

        public String getValue() {
            return this.value;
        }

        public static PlainTextOrDiff fromString(String str) {
            return Enum.valueOf(PlainTextOrDiff.class, str);
        }
    }

    public static enum DiffView {
        UNIFIED(Localization.lang("Unified View", new Object[0])),
        SPLIT(Localization.lang("Split View", new Object[0]));

        private final String value;

        private DiffView(String value) {
            this.value = value;
        }

        public static DiffView parse(String name) {
            return (DiffView)((Object)Enums.getIfPresent(DiffView.class, (String)name).or((Object)UNIFIED));
        }

        public String getValue() {
            return this.value;
        }

        public static DiffView fromString(String str) {
            return Enum.valueOf(DiffView.class, str);
        }
    }
}

