/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.mergeentries.newmergedialog.diffhighlighter;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.fxmisc.richtext.StyleClassedTextArea;
import org.jabref.gui.mergeentries.newmergedialog.DiffMethod;
import org.jabref.gui.mergeentries.newmergedialog.diffhighlighter.SplitDiffHighlighter;
import org.jabref.gui.mergeentries.newmergedialog.diffhighlighter.UnifiedDiffHighlighter;

public abstract sealed class DiffHighlighter
permits SplitDiffHighlighter, UnifiedDiffHighlighter {
    protected final StyleClassedTextArea sourceTextview;
    protected final StyleClassedTextArea targetTextview;
    protected DiffMethod diffMethod;

    public DiffHighlighter(StyleClassedTextArea sourceTextview, StyleClassedTextArea targetTextview, DiffMethod diffMethod) {
        Objects.requireNonNull(sourceTextview, "source text view MUST NOT be null.");
        Objects.requireNonNull(targetTextview, "target text view MUST NOT be null.");
        this.sourceTextview = sourceTextview;
        this.targetTextview = targetTextview;
        this.diffMethod = diffMethod;
    }

    abstract void highlight();

    protected List<String> splitString(String str) {
        return Arrays.asList(str.split(this.diffMethod.separator()));
    }

    private void setDiffMethod(DiffMethod diffMethod) {
        this.diffMethod = diffMethod;
    }

    public DiffMethod getDiffMethod() {
        return this.diffMethod;
    }

    public String getSeparator() {
        return this.diffMethod.separator();
    }

    protected String join(List<String> stringList) {
        return String.join((CharSequence)this.getSeparator(), stringList);
    }

    record Change(int position, int spanSize, ChangeType type) {
    }

    static enum ChangeType {
        ADDITION,
        DELETION,
        CHANGE_DELETION;

    }

    public static enum BasicDiffMethod implements DiffMethod
    {
        WORDS(" "),
        CHARS(""),
        COMMA(",");

        private final String separator;

        private BasicDiffMethod(String separator) {
            this.separator = separator;
        }

        @Override
        public String separator() {
            return this.separator;
        }
    }
}

