/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.mergeentries.newmergedialog.cell;

import java.io.IOException;
import java.net.URI;
import org.jabref.gui.actions.SimpleCommand;
import org.jabref.gui.desktop.JabRefDesktop;
import org.jabref.model.entry.identifier.DOI;
import org.jabref.preferences.FilePreferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenExternalLinkAction
extends SimpleCommand {
    private final Logger LOGGER = LoggerFactory.getLogger(OpenExternalLinkAction.class);
    private final FilePreferences filePreferences;
    private final String urlOrDoi;

    public OpenExternalLinkAction(String urlOrDoi, FilePreferences filePreferences) {
        this.filePreferences = filePreferences;
        this.urlOrDoi = urlOrDoi;
    }

    public void execute() {
        try {
            if (DOI.isValid(this.urlOrDoi)) {
                JabRefDesktop.openBrowser(DOI.parse(this.urlOrDoi).flatMap(DOI::getExternalURI).map(URI::toString).orElse(""), this.filePreferences);
            } else {
                JabRefDesktop.openBrowser(this.urlOrDoi, this.filePreferences);
            }
        }
        catch (IOException e) {
            this.LOGGER.warn("Cannot open the given external link '{}'", (Object)this.urlOrDoi, (Object)e);
        }
    }
}

