/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.mergeentries.newmergedialog;

import com.tobiasdiez.easybind.EasyBind;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.CompoundEdit;
import org.jabref.gui.mergeentries.newmergedialog.fieldsmerger.FieldMerger;
import org.jabref.gui.mergeentries.newmergedialog.fieldsmerger.FieldMergerFactory;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.field.Field;
import org.jabref.model.entry.field.InternalField;
import org.jabref.model.entry.types.EntryTypeFactory;
import org.jabref.model.strings.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FieldRowViewModel {
    private final Logger LOGGER = LoggerFactory.getLogger(FieldRowViewModel.class);
    private final BooleanProperty isFieldsMerged = new SimpleBooleanProperty(Boolean.FALSE.booleanValue());
    private final ObjectProperty<Selection> selection = new SimpleObjectProperty();
    private final StringProperty leftFieldValue = new SimpleStringProperty("");
    private final StringProperty rightFieldValue = new SimpleStringProperty("");
    private final StringProperty mergedFieldValue = new SimpleStringProperty("");
    private final Field field;
    private final BibEntry leftEntry;
    private final BibEntry rightEntry;
    private final BibEntry mergedEntry;
    private final BooleanBinding hasEqualLeftAndRight;
    private final FieldMergerFactory fieldMergerFactory;
    private final CompoundEdit fieldsMergedEdit = new CompoundEdit();

    public FieldRowViewModel(Field field, BibEntry leftEntry, BibEntry rightEntry, BibEntry mergedEntry, FieldMergerFactory fieldMergerFactory) {
        this.field = field;
        this.leftEntry = leftEntry;
        this.rightEntry = rightEntry;
        this.mergedEntry = mergedEntry;
        this.fieldMergerFactory = fieldMergerFactory;
        if (field.equals(InternalField.TYPE_HEADER)) {
            this.setLeftFieldValue(leftEntry.getType().getDisplayName());
            this.setRightFieldValue(rightEntry.getType().getDisplayName());
        } else {
            this.setLeftFieldValue(leftEntry.getField(field).orElse(""));
            this.setRightFieldValue(rightEntry.getField(field).orElse(""));
        }
        EasyBind.listen((ObservableValue)this.leftFieldValueProperty(), (obs, old, leftValue) -> leftEntry.setField(field, (String)leftValue));
        EasyBind.listen((ObservableValue)this.rightFieldValueProperty(), (obs, old, rightValue) -> rightEntry.setField(field, (String)rightValue));
        EasyBind.listen((ObservableValue)this.mergedFieldValueProperty(), (obs, old, mergedFieldValue) -> {
            if (field.equals(InternalField.TYPE_HEADER)) {
                this.getMergedEntry().setType(EntryTypeFactory.parse(mergedFieldValue));
            } else {
                this.getMergedEntry().setField(field, (String)mergedFieldValue);
            }
        });
        this.hasEqualLeftAndRight = Bindings.createBooleanBinding(this::hasEqualLeftAndRightValues, (Observable[])new Observable[]{this.leftFieldValueProperty(), this.rightFieldValueProperty()});
        this.selectNonEmptyValue();
        EasyBind.listen((ObservableValue)this.isFieldsMergedProperty(), (obs, old, areFieldsMerged) -> {
            this.LOGGER.debug("Field are merged: {}", areFieldsMerged);
            if (areFieldsMerged.booleanValue()) {
                this.selectLeftValue();
            } else {
                this.selectNonEmptyValue();
            }
        });
        EasyBind.subscribe(this.selectionProperty(), selection -> {
            this.LOGGER.debug("Selecting {}' value for field {}", (Object)selection, (Object)field.getDisplayName());
            switch (selection.ordinal()) {
                case 0: {
                    EasyBind.subscribe((ObservableValue)this.leftFieldValueProperty(), this::setMergedFieldValue);
                    break;
                }
                case 1: {
                    EasyBind.subscribe((ObservableValue)this.rightFieldValueProperty(), this::setMergedFieldValue);
                }
            }
        });
        EasyBind.subscribe((ObservableValue)this.mergedFieldValueProperty(), mergedValue -> {
            this.LOGGER.debug("Merged value is {} for field {}", mergedValue, (Object)field.getDisplayName());
            if (mergedValue.equals(this.getLeftFieldValue())) {
                this.selectLeftValue();
            } else if (this.getMergedFieldValue().equals(this.getRightFieldValue())) {
                this.selectRightValue();
            } else {
                this.selectNone();
            }
        });
        EasyBind.subscribe((ObservableValue)this.hasEqualLeftAndRightBinding(), this::setIsFieldsMerged);
    }

    public void selectNonEmptyValue() {
        if (StringUtil.isNullOrEmpty((String)this.leftFieldValue.get())) {
            this.selectRightValue();
        } else {
            this.selectLeftValue();
        }
    }

    public boolean hasEqualLeftAndRightValues() {
        return ((String)this.leftFieldValue.get()).equals(this.rightFieldValue.get());
    }

    public void selectLeftValue() {
        this.setSelection(Selection.LEFT);
    }

    public void selectRightValue() {
        if (this.isFieldsMerged()) {
            this.selectLeftValue();
        } else {
            this.setSelection(Selection.RIGHT);
        }
    }

    public void selectNone() {
        this.setSelection(Selection.NONE);
    }

    public void setMergedFieldValue(String mergedFieldValue) {
        this.mergedFieldValueProperty().set((Object)mergedFieldValue);
    }

    public StringProperty mergedFieldValueProperty() {
        return this.mergedFieldValue;
    }

    public String getMergedFieldValue() {
        return (String)this.mergedFieldValue.get();
    }

    public void mergeFields() {
        assert (!this.hasEqualLeftAndRightValues());
        if (!FieldMergerFactory.canMerge(this.field)) {
            throw new UnsupportedOperationException();
        }
        String oldLeftFieldValue = this.getLeftFieldValue();
        String oldRightFieldValue = this.getRightFieldValue();
        FieldMerger fieldMerger = this.fieldMergerFactory.create(this.field);
        String mergedFields = fieldMerger.merge(this.getLeftFieldValue(), this.getRightFieldValue());
        this.setLeftFieldValue(mergedFields);
        this.setRightFieldValue(mergedFields);
        if (this.fieldsMergedEdit.canRedo()) {
            this.fieldsMergedEdit.redo();
        } else {
            this.fieldsMergedEdit.addEdit(new MergeFieldsUndo(oldLeftFieldValue, oldRightFieldValue, mergedFields));
            this.fieldsMergedEdit.end();
        }
    }

    public void unmergeFields() {
        if (this.fieldsMergedEdit.canUndo()) {
            this.fieldsMergedEdit.undo();
        }
    }

    public BooleanBinding hasEqualLeftAndRightBinding() {
        return this.hasEqualLeftAndRight;
    }

    public ObjectProperty<Selection> selectionProperty() {
        return this.selection;
    }

    public void setSelection(Selection select) {
        this.selectionProperty().set((Object)select);
    }

    public Selection getSelection() {
        return (Selection)((Object)this.selectionProperty().get());
    }

    public boolean isFieldsMerged() {
        return this.isFieldsMerged.get();
    }

    public BooleanProperty isFieldsMergedProperty() {
        return this.isFieldsMerged;
    }

    public void setIsFieldsMerged(boolean isFieldsMerged) {
        this.isFieldsMerged.set(isFieldsMerged);
    }

    public String getLeftFieldValue() {
        return (String)this.leftFieldValue.get();
    }

    public StringProperty leftFieldValueProperty() {
        return this.leftFieldValue;
    }

    public void setLeftFieldValue(String leftFieldValue) {
        this.leftFieldValue.set((Object)leftFieldValue);
    }

    public String getRightFieldValue() {
        return (String)this.rightFieldValue.get();
    }

    public StringProperty rightFieldValueProperty() {
        return this.rightFieldValue;
    }

    public void setRightFieldValue(String rightFieldValue) {
        this.rightFieldValue.set((Object)rightFieldValue);
    }

    public Field getField() {
        return this.field;
    }

    public BibEntry getLeftEntry() {
        return this.leftEntry;
    }

    public BibEntry getRightEntry() {
        return this.rightEntry;
    }

    public BibEntry getMergedEntry() {
        return this.mergedEntry;
    }

    public static enum Selection {
        LEFT,
        RIGHT,
        NONE;

    }

    class MergeFieldsUndo
    extends AbstractUndoableEdit {
        private final String oldLeft;
        private final String oldRight;
        private final String mergedFields;

        MergeFieldsUndo(String oldLeft, String oldRight, String mergedFields) {
            this.oldLeft = oldLeft;
            this.oldRight = oldRight;
            this.mergedFields = mergedFields;
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            FieldRowViewModel.this.setLeftFieldValue(this.oldLeft);
            FieldRowViewModel.this.setRightFieldValue(this.oldRight);
        }

        @Override
        public void redo() throws CannotRedoException {
            super.redo();
            FieldRowViewModel.this.setLeftFieldValue(this.mergedFields);
            FieldRowViewModel.this.setRightFieldValue(this.mergedFields);
        }
    }
}

