/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.mergeentries;

import com.airhacks.afterburner.views.ViewLoader;
import com.tobiasdiez.easybind.EasyBind;
import com.tobiasdiez.easybind.EasyObservableValue;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.Supplier;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.control.TextInputControl;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.ToggleGroup;
import javafx.scene.control.Tooltip;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.RowConstraints;
import javafx.scene.layout.VBox;
import javafx.scene.text.TextAlignment;
import org.jabref.gui.icon.IconTheme;
import org.jabref.gui.mergeentries.DiffHighlightingEllipsingTextFlow;
import org.jabref.gui.mergeentries.DiffMode;
import org.jabref.gui.mergeentries.MultiMergeEntriesViewModel;
import org.jabref.gui.util.BaseDialog;
import org.jabref.gui.util.BindingsHelper;
import org.jabref.gui.util.TaskExecutor;
import org.jabref.gui.util.UiTaskExecutor;
import org.jabref.gui.util.ViewModelListCellFactory;
import org.jabref.logic.importer.FetcherException;
import org.jabref.logic.importer.fetcher.DoiFetcher;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.field.Field;
import org.jabref.model.entry.field.FieldFactory;
import org.jabref.model.entry.field.StandardField;
import org.jabref.preferences.PreferencesService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiMergeEntriesView
extends BaseDialog<BibEntry> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MultiMergeEntriesView.class);
    @FXML
    private ScrollPane leftScrollPane;
    @FXML
    private VBox fieldHeader;
    @FXML
    private ScrollPane topScrollPane;
    @FXML
    private HBox supplierHeader;
    @FXML
    private ScrollPane centerScrollPane;
    @FXML
    private GridPane optionsGrid;
    @FXML
    private ScrollPane rightScrollPane;
    @FXML
    private VBox fieldEditor;
    @FXML
    private Label failedSuppliers;
    @FXML
    private ComboBox<DiffMode> diffMode;
    private final ToggleGroup headerToggleGroup = new ToggleGroup();
    private final HashMap<Field, FieldRow> fieldRows = new HashMap();
    private final MultiMergeEntriesViewModel viewModel;
    private final TaskExecutor taskExecutor;
    private final PreferencesService preferences;

    public MultiMergeEntriesView(PreferencesService preferences, TaskExecutor taskExecutor) {
        this.preferences = preferences;
        this.taskExecutor = taskExecutor;
        this.viewModel = new MultiMergeEntriesViewModel();
        ViewLoader.view((Object)((Object)this)).load().setAsDialogPane((Dialog)this);
        ButtonType mergeEntries = new ButtonType(Localization.lang("Merge entries", new Object[0]), ButtonBar.ButtonData.OK_DONE);
        this.getDialogPane().getButtonTypes().setAll((Object[])new ButtonType[]{ButtonType.CANCEL, mergeEntries});
        this.setResultConverter(this.viewModel::resultConverter);
        this.viewModel.entriesProperty().addListener(c -> {
            while (c.next()) {
                if (!c.wasAdded()) continue;
                for (MultiMergeEntriesViewModel.EntrySource entrySourceColumn : c.getAddedSubList()) {
                    this.addColumn(entrySourceColumn);
                }
            }
        });
        ((BibEntry)this.viewModel.mergedEntryProperty().get()).getFieldsObservable().addListener(change -> {
            if (change.wasAdded() && !this.fieldRows.containsKey(change.getKey())) {
                FieldRow fieldRow = new FieldRow((Field)change.getKey(), ((BibEntry)this.viewModel.mergedEntryProperty().get()).getFields().size() - 1);
                this.fieldRows.put((Field)change.getKey(), fieldRow);
            }
        });
    }

    @FXML
    public void initialize() {
        this.topScrollPane.hvalueProperty().bindBidirectional((Property)this.centerScrollPane.hvalueProperty());
        this.leftScrollPane.vvalueProperty().bindBidirectional((Property)this.centerScrollPane.vvalueProperty());
        this.rightScrollPane.vvalueProperty().bindBidirectional((Property)this.centerScrollPane.vvalueProperty());
        this.viewModel.failedSuppliersProperty().addListener((obs, oldValue, newValue) -> this.failedSuppliers.setText(((ObservableList)this.viewModel.failedSuppliersProperty().get()).isEmpty() ? "" : Localization.lang("Could not extract Metadata from: %0", String.join((CharSequence)", ", this.viewModel.failedSuppliersProperty()))));
        this.fillDiffModes();
    }

    private void fillDiffModes() {
        this.diffMode.setItems(FXCollections.observableList(List.of(DiffMode.PLAIN, DiffMode.WORD, DiffMode.CHARACTER)));
        new ViewModelListCellFactory().withText(DiffMode::getDisplayText).install(this.diffMode);
        this.diffMode.setValue((Object)this.preferences.getMergeDialogPreferences().getMergeDiffMode());
        EasyBind.subscribe((ObservableValue)this.diffMode.valueProperty(), mode -> this.preferences.getMergeDialogPreferences().setMergeDiffMode((DiffMode)((Object)mode)));
    }

    private void addColumn(MultiMergeEntriesViewModel.EntrySource entrySourceColumn) {
        int columnIndex = this.supplierHeader.getChildren().size();
        ToggleButton header = this.generateEntryHeader(entrySourceColumn, columnIndex);
        header.getStyleClass().add((Object)"toggle-button");
        HBox.setHgrow((Node)header, (Priority)Priority.ALWAYS);
        this.supplierHeader.getChildren().add((Object)header);
        header.setMinWidth(250.0);
        ColumnConstraints constraint = new ColumnConstraints();
        constraint.setMinWidth(Double.NEGATIVE_INFINITY);
        constraint.setMaxWidth(Double.NEGATIVE_INFINITY);
        constraint.prefWidthProperty().bind((ObservableValue)header.widthProperty());
        this.optionsGrid.getColumnConstraints().add((Object)constraint);
        if (!entrySourceColumn.isLoadingProperty().getValue().booleanValue()) {
            this.writeBibEntryToColumn(entrySourceColumn, columnIndex);
        } else {
            header.setDisable(true);
            entrySourceColumn.isLoadingProperty().addListener((observable, oldValue, newValue) -> {
                if (!newValue.booleanValue() && entrySourceColumn.entryProperty().get() != null) {
                    this.writeBibEntryToColumn(entrySourceColumn, columnIndex);
                    header.setDisable(false);
                }
            });
        }
    }

    private ToggleButton generateEntryHeader(MultiMergeEntriesViewModel.EntrySource column, int columnIndex) {
        ToggleButton header = new ToggleButton();
        header.setToggleGroup(this.headerToggleGroup);
        header.textProperty().bind((ObservableValue)column.titleProperty());
        this.setupSourceButtonAction(header, columnIndex);
        if (column.isLoadingProperty().getValue().booleanValue()) {
            ProgressIndicator progressIndicator = new ProgressIndicator(-1.0);
            progressIndicator.setPrefHeight(20.0);
            progressIndicator.setMinHeight(Double.NEGATIVE_INFINITY);
            progressIndicator.setMaxHeight(Double.NEGATIVE_INFINITY);
            header.setGraphic((Node)progressIndicator);
            progressIndicator.visibleProperty().bind((ObservableValue)column.isLoadingProperty());
        }
        column.isLoadingProperty().addListener((obs, oldValue, newValue) -> {
            if (!newValue.booleanValue()) {
                header.setGraphic(null);
                if (column.entryProperty().get() == null) {
                    header.setMinWidth(0.0);
                    header.setMaxWidth(0.0);
                    header.setVisible(false);
                }
            }
        });
        return header;
    }

    private void writeBibEntryToColumn(MultiMergeEntriesViewModel.EntrySource entrySourceColumn, int columnIndex) {
        for (Map.Entry entry : ((BibEntry)entrySourceColumn.entryProperty().get()).getFieldsObservable().entrySet()) {
            Field key = (Field)entry.getKey();
            String value = (String)entry.getValue();
            Cell cell = new Cell(value, key, columnIndex);
            this.optionsGrid.add((Node)cell, columnIndex, this.fieldRows.get((Object)key).rowIndex);
        }
    }

    private void setupSourceButtonAction(ToggleButton sourceButton, int column) {
        sourceButton.selectedProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue.booleanValue()) {
                this.optionsGrid.getChildrenUnmodifiable().stream().filter(node -> GridPane.getColumnIndex((Node)node) == column).filter(HBox.class::isInstance).forEach(hbox -> ((HBox)hbox).getChildrenUnmodifiable().stream().filter(ToggleButton.class::isInstance).forEach(toggleButton -> ((ToggleButton)toggleButton).setSelected(true)));
                sourceButton.setSelected(true);
            }
        });
    }

    private boolean isMultilineField(Field field) {
        if (field.equals(StandardField.DOI)) {
            return false;
        }
        return FieldFactory.isMultiLineField(field, this.preferences.getFieldPreferences().getNonWrappableFields());
    }

    public void addSource(String title, BibEntry entry) {
        this.viewModel.addSource(new MultiMergeEntriesViewModel.EntrySource(title, entry));
    }

    public void addSource(String title, Supplier<BibEntry> supplier) {
        this.viewModel.addSource(new MultiMergeEntriesViewModel.EntrySource(title, supplier, this.taskExecutor));
    }

    private class Cell
    extends HBox {
        private final String content;

        public Cell(String content, Field field, int columnIndex) {
            this.content = content;
            UiTaskExecutor.runInJavaFXThread(() -> {
                FieldRow row = MultiMergeEntriesView.this.fieldRows.get(field);
                this.prefWidthProperty().bind((ObservableValue)((Region)MultiMergeEntriesView.this.supplierHeader.getChildren().get(columnIndex)).widthProperty());
                this.setMinWidth(Double.NEGATIVE_INFINITY);
                this.setMaxWidth(Double.NEGATIVE_INFINITY);
                this.prefHeightProperty().bind((ObservableValue)((Region)MultiMergeEntriesView.this.fieldEditor.getChildren().get(row.rowIndex)).heightProperty());
                this.setMinHeight(Double.NEGATIVE_INFINITY);
                this.setMaxHeight(Double.NEGATIVE_INFINITY);
                ToggleButton cellButton = new ToggleButton();
                cellButton.prefHeightProperty().bind((ObservableValue)this.heightProperty());
                cellButton.setMinHeight(Double.NEGATIVE_INFINITY);
                cellButton.setMaxHeight(Double.NEGATIVE_INFINITY);
                cellButton.setGraphicTextGap(0.0);
                this.getChildren().add((Object)cellButton);
                cellButton.maxWidthProperty().bind((ObservableValue)this.widthProperty());
                HBox.setHgrow((Node)cellButton, (Priority)Priority.ALWAYS);
                DiffHighlightingEllipsingTextFlow buttonText = new DiffHighlightingEllipsingTextFlow(content, (EasyObservableValue<String>)((BibEntry)MultiMergeEntriesView.this.viewModel.mergedEntryProperty().get()).getFieldBinding(field).asOrdinary(), (ObjectProperty<DiffMode>)MultiMergeEntriesView.this.diffMode.valueProperty());
                buttonText.maxWidthProperty().bind((ObservableValue)this.widthProperty().add(-10));
                buttonText.maxHeightProperty().bind((ObservableValue)this.heightProperty());
                cellButton.setGraphic((Node)buttonText);
                cellButton.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
                cellButton.setContentDisplay(ContentDisplay.CENTER);
                Tooltip buttonTooltip = new Tooltip(content);
                buttonTooltip.setWrapText(true);
                buttonTooltip.prefWidthProperty().bind((ObservableValue)this.widthProperty());
                buttonTooltip.setTextAlignment(TextAlignment.LEFT);
                cellButton.setTooltip(buttonTooltip);
                cellButton.setToggleGroup(row.toggleGroup);
                if (row.toggleGroup.getSelectedToggle() == null) {
                    cellButton.setSelected(true);
                }
                if (field.equals(StandardField.DOI)) {
                    Button doiButton = IconTheme.JabRefIcons.LOOKUP_IDENTIFIER.asButton();
                    HBox.setHgrow((Node)doiButton, (Priority)Priority.NEVER);
                    doiButton.prefHeightProperty().bind((ObservableValue)cellButton.heightProperty());
                    doiButton.setMinHeight(Double.NEGATIVE_INFINITY);
                    doiButton.setMaxHeight(Double.NEGATIVE_INFINITY);
                    this.getChildren().add((Object)doiButton);
                    doiButton.setOnAction(event -> {
                        DoiFetcher doiFetcher = new DoiFetcher(MultiMergeEntriesView.this.preferences.getImportFormatPreferences());
                        doiButton.setDisable(true);
                        MultiMergeEntriesView.this.addSource(Localization.lang("From DOI", new Object[0]), () -> {
                            try {
                                return doiFetcher.performSearchById(content).get();
                            }
                            catch (NoSuchElementException | FetcherException e) {
                                LOGGER.warn("Failed to fetch BibEntry for DOI {}", (Object)content, (Object)e);
                                return null;
                            }
                        });
                    });
                }
            });
        }

        public String getContent() {
            return this.content;
        }
    }

    private class FieldRow {
        public final ToggleGroup toggleGroup = new ToggleGroup();
        private final TextInputControl fieldEditorCell;
        private final int rowIndex;
        private EasyObservableValue<String> fieldBinding;

        public FieldRow(Field field, int rowIndex) {
            this.rowIndex = rowIndex;
            boolean isMultiLine = MultiMergeEntriesView.this.isMultilineField(field);
            if (isMultiLine) {
                this.fieldEditorCell = new TextArea();
                ((TextArea)this.fieldEditorCell).setWrapText(true);
            } else {
                this.fieldEditorCell = new TextField();
            }
            this.addRow(field);
            this.fieldEditorCell.addEventFilter(KeyEvent.KEY_PRESSED, event -> this.toggleGroup.selectToggle(null));
            this.toggleGroup.selectedToggleProperty().addListener((obs, oldValue, newValue) -> {
                if (newValue == null) {
                    ((BibEntry)MultiMergeEntriesView.this.viewModel.mergedEntryProperty().get()).setField(field, "");
                } else {
                    ((BibEntry)MultiMergeEntriesView.this.viewModel.mergedEntryProperty().get()).setField(field, ((DiffHighlightingEllipsingTextFlow)((ToggleButton)newValue).getGraphic()).getFullText());
                    MultiMergeEntriesView.this.headerToggleGroup.selectToggle(null);
                }
            });
        }

        private void addRow(Field field) {
            VBox.setVgrow((Node)this.fieldEditorCell, (Priority)Priority.ALWAYS);
            this.fieldBinding = ((BibEntry)MultiMergeEntriesView.this.viewModel.mergedEntryProperty().get()).getFieldBinding(field).asOrdinary();
            BindingsHelper.bindBidirectional(this.fieldEditorCell.textProperty(), this.fieldBinding, text -> {
                if (text != null) {
                    this.fieldEditorCell.setText(text);
                }
            }, binding -> {
                if (binding != null) {
                    ((BibEntry)MultiMergeEntriesView.this.viewModel.mergedEntryProperty().get()).setField(field, (String)binding);
                }
            });
            this.fieldEditorCell.setMaxHeight(Double.MAX_VALUE);
            VBox.setVgrow((Node)this.fieldEditorCell, (Priority)Priority.ALWAYS);
            MultiMergeEntriesView.this.fieldEditor.getChildren().add((Object)this.fieldEditorCell);
            Label fieldHeaderLabel = new Label(field.getDisplayName());
            fieldHeaderLabel.prefHeightProperty().bind((ObservableValue)this.fieldEditorCell.heightProperty());
            fieldHeaderLabel.setMaxWidth(Double.NEGATIVE_INFINITY);
            fieldHeaderLabel.setMinWidth(Double.NEGATIVE_INFINITY);
            MultiMergeEntriesView.this.fieldHeader.getChildren().add((Object)fieldHeaderLabel);
            RowConstraints constraint = new RowConstraints();
            constraint.setMinHeight(Double.NEGATIVE_INFINITY);
            constraint.setMaxHeight(Double.NEGATIVE_INFINITY);
            constraint.prefHeightProperty().bind((ObservableValue)this.fieldEditorCell.heightProperty());
            MultiMergeEntriesView.this.optionsGrid.getRowConstraints().add((Object)constraint);
        }
    }
}

