/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.mergeentries;

import org.jabref.logic.l10n.Localization;

public enum DiffMode {
    PLAIN(Localization.lang("None", new Object[0])),
    WORD(Localization.lang("Word by word", new Object[0])),
    CHARACTER(Localization.lang("Character by character", new Object[0])),
    WORD_SYMMETRIC(Localization.lang("Symmetric word by word", new Object[0])),
    CHARACTER_SYMMETRIC(Localization.lang("Symmetric character by character", new Object[0]));

    private final String text;

    private DiffMode(String text) {
        this.text = text;
    }

    public static DiffMode parse(String name) {
        try {
            return DiffMode.valueOf(name);
        }
        catch (IllegalArgumentException e) {
            return WORD;
        }
    }

    public String getDisplayText() {
        return this.text;
    }
}

