/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.mergeentries;

import com.tobiasdiez.easybind.EasyObservableValue;
import java.util.Collection;
import java.util.List;
import javafx.beans.DefaultProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.text.Text;
import javafx.scene.text.TextFlow;
import org.jabref.gui.mergeentries.DiffHighlighting;
import org.jabref.gui.mergeentries.DiffMode;

@DefaultProperty(value="children")
public class DiffHighlightingEllipsingTextFlow
extends TextFlow {
    private static final String DEFAULT_ELLIPSIS_STRING = "...";
    private StringProperty ellipsisString;
    private final ObservableList<Node> allChildren = FXCollections.observableArrayList();
    private final ChangeListener<Number> sizeChangeListener = (observableValue, number, t1) -> this.adjustText();
    private final ListChangeListener<Node> listChangeListener = this::adjustChildren;
    private final String fullText;
    private final EasyObservableValue<String> comparisonString;
    private final ObjectProperty<DiffMode> diffMode;

    public DiffHighlightingEllipsingTextFlow(String fullText, EasyObservableValue<String> comparisonString, ObjectProperty<DiffMode> diffMode) {
        this.fullText = fullText;
        this.allChildren.addListener(this.listChangeListener);
        this.widthProperty().addListener(this.sizeChangeListener);
        this.heightProperty().addListener(this.sizeChangeListener);
        this.comparisonString = comparisonString;
        this.diffMode = diffMode;
        comparisonString.addListener((obs, oldValue, newValue) -> this.highlightDiff());
        diffMode.addListener((obs, oldValue, newValue) -> this.highlightDiff());
        this.highlightDiff();
    }

    public ObservableList<Node> getChildren() {
        return this.allChildren;
    }

    private void adjustChildren(ListChangeListener.Change<? extends Node> change) {
        super.getChildren().clear();
        super.getChildren().addAll(this.allChildren);
        super.autosize();
        this.adjustText();
    }

    private void adjustText() {
        if (this.allChildren.isEmpty()) {
            return;
        }
        this.widthProperty().removeListener(this.sizeChangeListener);
        this.heightProperty().removeListener(this.sizeChangeListener);
        if (this.removeUntilTextFits() && this.fillUntilOverflowing()) {
            this.ellipseUntilTextFits();
        }
        this.widthProperty().addListener(this.sizeChangeListener);
        this.heightProperty().addListener(this.sizeChangeListener);
    }

    private boolean removeUntilTextFits() {
        while (this.getHeight() > this.getMaxHeight() || this.getWidth() > this.getMaxWidth()) {
            if (super.getChildren().isEmpty()) {
                return false;
            }
            super.getChildren().remove(super.getChildren().size() - 1);
            super.autosize();
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean fillUntilOverflowing() {
        while (this.getHeight() <= this.getMaxHeight() && this.getWidth() <= this.getMaxWidth()) {
            if (super.getChildren().size() == this.allChildren.size()) {
                if (!this.allChildren.isEmpty()) {
                    Text text;
                    Node lastChildAsShown = (Node)super.getChildren().get(super.getChildren().size() - 1);
                    Node lastChild = (Node)this.allChildren.getLast();
                    if (!(lastChildAsShown instanceof Text) || (text = (Text)lastChildAsShown).getText().length() >= ((Text)lastChild).getText().length()) return false;
                    text.setText(((Text)lastChild).getText());
                }
            } else {
                super.getChildren().add((Object)((Node)this.allChildren.get(super.getChildren().size())));
            }
            super.autosize();
        }
        return true;
    }

    private boolean ellipseUntilTextFits() {
        while (this.getHeight() > this.getMaxHeight() || this.getWidth() > this.getMaxWidth()) {
            Text lastChildAsShown = (Text)super.getChildren().remove(super.getChildren().size() - 1);
            while (this.getEllipsisString().equals(lastChildAsShown.getText()) || "".equals(lastChildAsShown.getText())) {
                if (super.getChildren().isEmpty()) {
                    return false;
                }
                lastChildAsShown = (Text)super.getChildren().remove(super.getChildren().size() - 1);
            }
            Text shortenedChild = new Text(this.ellipseString(lastChildAsShown.getText()));
            shortenedChild.getStyleClass().addAll((Collection)lastChildAsShown.getStyleClass());
            super.getChildren().add((Object)shortenedChild);
            super.autosize();
        }
        return true;
    }

    public void highlightDiff() {
        this.allChildren.clear();
        if (this.comparisonString.get() != null && !((String)this.comparisonString.get()).equals(this.fullText)) {
            List<Text> highlightedText = switch ((DiffMode)((Object)this.diffMode.getValue())) {
                case DiffMode.PLAIN -> {
                    Text text = new Text(this.fullText);
                    text.getStyleClass().add((Object)"text-unchanged");
                    yield List.of(text);
                }
                case DiffMode.WORD -> DiffHighlighting.generateDiffHighlighting((String)this.comparisonString.get(), this.fullText, " ");
                case DiffMode.CHARACTER -> DiffHighlighting.generateDiffHighlighting((String)this.comparisonString.get(), this.fullText, "");
                default -> throw new UnsupportedOperationException("Not implemented " + String.valueOf(this.diffMode.getValue()));
            };
            this.allChildren.addAll(highlightedText);
        } else {
            Text text = new Text(this.fullText);
            text.getStyleClass().add((Object)"text-unchanged");
            this.allChildren.add((Object)text);
        }
        super.autosize();
        this.adjustText();
    }

    private String ellipseString(String s) {
        int spacePos = s.lastIndexOf(32);
        if (spacePos <= 0) {
            return "";
        }
        return s.substring(0, spacePos) + this.getEllipsisString();
    }

    public final void setEllipsisString(String value) {
        this.ellipsisString.set((Object)(value == null ? "" : value));
    }

    public String getEllipsisString() {
        return this.ellipsisString == null ? DEFAULT_ELLIPSIS_STRING : (String)this.ellipsisString.get();
    }

    public final StringProperty ellipsisStringProperty() {
        return this.ellipsisString;
    }

    public String getFullText() {
        return this.fullText;
    }
}

