/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.maintable;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import javafx.collections.ObservableList;
import javafx.scene.control.ResizeFeaturesBase;
import javafx.scene.control.TableColumnBase;
import javafx.scene.control.TableView;
import javafx.util.Callback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmartConstrainedResizePolicy
implements Callback<TableView.ResizeFeatures, Boolean> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SmartConstrainedResizePolicy.class);

    public Boolean call(TableView.ResizeFeatures prop) {
        if (prop.getColumn() == null) {
            return this.initColumnSize(prop.getTable());
        }
        return this.constrainedResize(prop);
    }

    private Boolean initColumnSize(TableView<?> table) {
        double tableWidth = this.getContentWidth(table);
        ObservableList visibleLeafColumns = table.getVisibleLeafColumns();
        double totalWidth = visibleLeafColumns.stream().mapToDouble(TableColumnBase::getWidth).sum();
        if (Math.abs(totalWidth - tableWidth) > 1.0) {
            double totalPrefWidth = visibleLeafColumns.stream().mapToDouble(TableColumnBase::getPrefWidth).sum();
            double currPrefWidth = 0.0;
            if (totalPrefWidth > 0.0) {
                for (TableColumnBase col : visibleLeafColumns) {
                    double share = col.getPrefWidth() / totalPrefWidth;
                    double newSize = tableWidth * share;
                    if ((currPrefWidth += newSize) > tableWidth) {
                        newSize -= currPrefWidth - tableWidth;
                        currPrefWidth -= tableWidth;
                    }
                    this.resize(col, newSize - col.getWidth());
                }
            }
        }
        return false;
    }

    private void resize(TableColumnBase column, double delta) {
        try {
            Class<?> clazz = Class.forName("javafx.scene.control.TableUtil");
            Method constrainedResize = clazz.getDeclaredMethod("resize", TableColumnBase.class, Double.TYPE);
            constrainedResize.setAccessible(true);
            constrainedResize.invoke(null, column, delta);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            LOGGER.error("Could not invoke resize in TableUtil", (Throwable)e);
        }
    }

    private Boolean constrainedResize(TableView.ResizeFeatures<?> prop) {
        TableView table = prop.getTable();
        ObservableList visibleLeafColumns = table.getVisibleLeafColumns();
        return this.constrainedResize((TableView.ResizeFeatures)prop, false, this.getContentWidth(table) - 2.0, (List<? extends TableColumnBase<?, ?>>)visibleLeafColumns);
    }

    private Boolean constrainedResize(TableView.ResizeFeatures prop, Boolean isFirstRun, Double contentWidth, List<? extends TableColumnBase<?, ?>> visibleLeafColumns) {
        try {
            Class<?> clazz = Class.forName("javafx.scene.control.TableUtil");
            Method constrainedResize = clazz.getDeclaredMethod("constrainedResize", ResizeFeaturesBase.class, Boolean.TYPE, Double.TYPE, List.class);
            constrainedResize.setAccessible(true);
            Object returnValue = constrainedResize.invoke(null, prop, isFirstRun, contentWidth, visibleLeafColumns);
            return (Boolean)returnValue;
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            LOGGER.error("Could not invoke constrainedResize in TableUtil", (Throwable)e);
            return false;
        }
    }

    private Double getContentWidth(TableView<?> table) {
        try {
            Field privateStringField = TableView.class.getDeclaredField("contentWidth");
            privateStringField.setAccessible(true);
            return (Double)privateStringField.get(table);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            return 0.0;
        }
    }
}

