/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.maintable;

import java.io.IOException;
import javafx.beans.binding.BooleanExpression;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import org.jabref.gui.DialogService;
import org.jabref.gui.StateManager;
import org.jabref.gui.actions.ActionHelper;
import org.jabref.gui.actions.SimpleCommand;
import org.jabref.gui.desktop.JabRefDesktop;
import org.jabref.logic.l10n.Localization;
import org.jabref.logic.util.ExternalLinkCreator;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.field.StandardField;
import org.jabref.preferences.PreferencesService;

public class SearchShortScienceAction
extends SimpleCommand {
    private final DialogService dialogService;
    private final StateManager stateManager;
    private final PreferencesService preferencesService;

    public SearchShortScienceAction(DialogService dialogService, StateManager stateManager, PreferencesService preferencesService) {
        this.dialogService = dialogService;
        this.stateManager = stateManager;
        this.preferencesService = preferencesService;
        BooleanExpression fieldIsSet = ActionHelper.isFieldSetForSelectedEntry(StandardField.TITLE, stateManager);
        this.executable.bind((ObservableValue)ActionHelper.needsEntriesSelected(1, stateManager).and((ObservableBooleanValue)fieldIsSet));
    }

    public void execute() {
        this.stateManager.getActiveDatabase().ifPresent(databaseContext -> {
            ObservableList<BibEntry> bibEntries = this.stateManager.getSelectedEntries();
            if (bibEntries.size() != 1) {
                this.dialogService.notify(Localization.lang("This operation requires exactly one item to be selected.", new Object[0]));
                return;
            }
            ExternalLinkCreator.getShortScienceSearchURL((BibEntry)bibEntries.getFirst()).ifPresent(url -> {
                try {
                    JabRefDesktop.openExternalViewer(databaseContext, this.preferencesService, url, StandardField.URL, this.dialogService, (BibEntry)bibEntries.getFirst());
                }
                catch (IOException ex) {
                    this.dialogService.showErrorDialogAndWait(Localization.lang("Unable to open ShortScience.", new Object[0]), ex);
                }
            });
        });
    }
}

