/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.maintable;

import com.tobiasdiez.easybind.EasyBind;
import de.saxsys.mvvmfx.utils.commands.Command;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javax.swing.undo.UndoManager;
import org.jabref.gui.ClipBoardManager;
import org.jabref.gui.DialogService;
import org.jabref.gui.LibraryTab;
import org.jabref.gui.StateManager;
import org.jabref.gui.actions.ActionFactory;
import org.jabref.gui.actions.StandardActions;
import org.jabref.gui.edit.CopyMoreAction;
import org.jabref.gui.edit.EditAction;
import org.jabref.gui.exporter.ExportToClipboardAction;
import org.jabref.gui.frame.SendAsKindleEmailAction;
import org.jabref.gui.frame.SendAsStandardEmailAction;
import org.jabref.gui.keyboard.KeyBindingRepository;
import org.jabref.gui.linkedfile.AttachFileAction;
import org.jabref.gui.linkedfile.AttachFileFromURLAction;
import org.jabref.gui.maintable.BibEntryTableViewModel;
import org.jabref.gui.maintable.ExtractReferencesAction;
import org.jabref.gui.maintable.OpenExternalFileAction;
import org.jabref.gui.maintable.OpenFolderAction;
import org.jabref.gui.maintable.OpenUrlAction;
import org.jabref.gui.maintable.SearchShortScienceAction;
import org.jabref.gui.menus.ChangeEntryTypeMenu;
import org.jabref.gui.mergeentries.MergeEntriesAction;
import org.jabref.gui.mergeentries.MergeWithFetchedEntryAction;
import org.jabref.gui.preview.CopyCitationAction;
import org.jabref.gui.specialfields.SpecialFieldMenuItemFactory;
import org.jabref.gui.util.TaskExecutor;
import org.jabref.logic.citationstyle.CitationStyleOutputFormat;
import org.jabref.logic.citationstyle.CitationStylePreviewLayout;
import org.jabref.logic.journals.JournalAbbreviationRepository;
import org.jabref.model.entry.BibEntryTypesManager;
import org.jabref.model.entry.field.SpecialField;
import org.jabref.preferences.PreferencesService;
import org.jabref.preferences.PreviewPreferences;

public class RightClickMenu {
    public static ContextMenu create(BibEntryTableViewModel entry, KeyBindingRepository keyBindingRepository, LibraryTab libraryTab, DialogService dialogService, StateManager stateManager, PreferencesService preferencesService, UndoManager undoManager, ClipBoardManager clipBoardManager, TaskExecutor taskExecutor, JournalAbbreviationRepository abbreviationRepository, BibEntryTypesManager entryTypesManager) {
        ActionFactory factory = new ActionFactory();
        ContextMenu contextMenu = new ContextMenu();
        MenuItem extractFileReferencesOnline = factory.createMenuItem(StandardActions.EXTRACT_FILE_REFERENCES_ONLINE, (Command)new ExtractReferencesAction(true, dialogService, stateManager, preferencesService, taskExecutor));
        MenuItem extractFileReferencesOffline = factory.createMenuItem(StandardActions.EXTRACT_FILE_REFERENCES_OFFLINE, (Command)new ExtractReferencesAction(false, dialogService, stateManager, preferencesService, taskExecutor));
        contextMenu.getItems().addAll((Object[])new MenuItem[]{factory.createMenuItem(StandardActions.COPY, (Command)new EditAction(StandardActions.COPY, () -> libraryTab, stateManager, undoManager)), RightClickMenu.createCopySubMenu(factory, dialogService, stateManager, preferencesService, clipBoardManager, abbreviationRepository, taskExecutor), factory.createMenuItem(StandardActions.PASTE, (Command)new EditAction(StandardActions.PASTE, () -> libraryTab, stateManager, undoManager)), factory.createMenuItem(StandardActions.CUT, (Command)new EditAction(StandardActions.CUT, () -> libraryTab, stateManager, undoManager)), factory.createMenuItem(StandardActions.MERGE_ENTRIES, (Command)new MergeEntriesAction(dialogService, stateManager, undoManager, preferencesService)), factory.createMenuItem(StandardActions.DELETE_ENTRY, (Command)new EditAction(StandardActions.DELETE_ENTRY, () -> libraryTab, stateManager, undoManager)), new SeparatorMenuItem(), RightClickMenu.createSendSubMenu(factory, dialogService, stateManager, preferencesService, entryTypesManager, taskExecutor), SpecialFieldMenuItemFactory.createSpecialFieldMenu(SpecialField.RANKING, factory, () -> libraryTab, dialogService, preferencesService, undoManager, stateManager), SpecialFieldMenuItemFactory.getSpecialFieldSingleItem(SpecialField.RELEVANCE, factory, () -> libraryTab, dialogService, preferencesService, undoManager, stateManager), SpecialFieldMenuItemFactory.getSpecialFieldSingleItem(SpecialField.QUALITY, factory, () -> libraryTab, dialogService, preferencesService, undoManager, stateManager), SpecialFieldMenuItemFactory.getSpecialFieldSingleItem(SpecialField.PRINTED, factory, () -> libraryTab, dialogService, preferencesService, undoManager, stateManager), SpecialFieldMenuItemFactory.createSpecialFieldMenu(SpecialField.PRIORITY, factory, () -> libraryTab, dialogService, preferencesService, undoManager, stateManager), SpecialFieldMenuItemFactory.createSpecialFieldMenu(SpecialField.READ_STATUS, factory, () -> libraryTab, dialogService, preferencesService, undoManager, stateManager), new SeparatorMenuItem(), factory.createMenuItem(StandardActions.ATTACH_FILE, (Command)new AttachFileAction(libraryTab, dialogService, stateManager, preferencesService.getFilePreferences())), factory.createMenuItem(StandardActions.ATTACH_FILE_FROM_URL, (Command)new AttachFileFromURLAction(dialogService, stateManager, taskExecutor, preferencesService)), factory.createMenuItem(StandardActions.OPEN_FOLDER, (Command)new OpenFolderAction(dialogService, stateManager, preferencesService, taskExecutor)), factory.createMenuItem(StandardActions.OPEN_EXTERNAL_FILE, (Command)new OpenExternalFileAction(dialogService, stateManager, preferencesService, taskExecutor)), extractFileReferencesOnline, extractFileReferencesOffline, factory.createMenuItem(StandardActions.OPEN_URL, (Command)new OpenUrlAction(dialogService, stateManager, preferencesService)), factory.createMenuItem(StandardActions.SEARCH_SHORTSCIENCE, (Command)new SearchShortScienceAction(dialogService, stateManager, preferencesService)), new SeparatorMenuItem(), new ChangeEntryTypeMenu(libraryTab.getSelectedEntries(), libraryTab.getBibDatabaseContext(), undoManager, entryTypesManager).asSubMenu(), factory.createMenuItem(StandardActions.MERGE_WITH_FETCHED_ENTRY, (Command)new MergeWithFetchedEntryAction(dialogService, stateManager, taskExecutor, preferencesService, undoManager))});
        EasyBind.subscribe((ObservableValue)preferencesService.getGrobidPreferences().grobidEnabledProperty(), enabled -> {
            extractFileReferencesOnline.setVisible(enabled.booleanValue());
            extractFileReferencesOffline.setVisible(enabled == false);
        });
        return contextMenu;
    }

    private static Menu createCopySubMenu(ActionFactory factory, DialogService dialogService, StateManager stateManager, PreferencesService preferencesService, ClipBoardManager clipBoardManager, JournalAbbreviationRepository abbreviationRepository, TaskExecutor taskExecutor) {
        Menu copySpecialMenu = factory.createMenu(StandardActions.COPY_MORE);
        copySpecialMenu.getItems().addAll((Object[])new MenuItem[]{factory.createMenuItem(StandardActions.COPY_TITLE, (Command)new CopyMoreAction(StandardActions.COPY_TITLE, dialogService, stateManager, clipBoardManager, preferencesService, abbreviationRepository)), factory.createMenuItem(StandardActions.COPY_KEY, (Command)new CopyMoreAction(StandardActions.COPY_KEY, dialogService, stateManager, clipBoardManager, preferencesService, abbreviationRepository)), factory.createMenuItem(StandardActions.COPY_CITE_KEY, (Command)new CopyMoreAction(StandardActions.COPY_CITE_KEY, dialogService, stateManager, clipBoardManager, preferencesService, abbreviationRepository)), factory.createMenuItem(StandardActions.COPY_KEY_AND_TITLE, (Command)new CopyMoreAction(StandardActions.COPY_KEY_AND_TITLE, dialogService, stateManager, clipBoardManager, preferencesService, abbreviationRepository)), factory.createMenuItem(StandardActions.COPY_KEY_AND_LINK, (Command)new CopyMoreAction(StandardActions.COPY_KEY_AND_LINK, dialogService, stateManager, clipBoardManager, preferencesService, abbreviationRepository)), factory.createMenuItem(StandardActions.COPY_DOI, (Command)new CopyMoreAction(StandardActions.COPY_DOI, dialogService, stateManager, clipBoardManager, preferencesService, abbreviationRepository)), factory.createMenuItem(StandardActions.COPY_DOI_URL, (Command)new CopyMoreAction(StandardActions.COPY_DOI_URL, dialogService, stateManager, clipBoardManager, preferencesService, abbreviationRepository)), new SeparatorMenuItem()});
        PreviewPreferences previewPreferences = preferencesService.getPreviewPreferences();
        if (previewPreferences.getSelectedPreviewLayout() instanceof CitationStylePreviewLayout) {
            copySpecialMenu.getItems().addAll((Object[])new MenuItem[]{factory.createMenuItem(StandardActions.COPY_CITATION_HTML, (Command)new CopyCitationAction(CitationStyleOutputFormat.HTML, dialogService, stateManager, clipBoardManager, taskExecutor, preferencesService, abbreviationRepository)), factory.createMenuItem(StandardActions.COPY_CITATION_TEXT, (Command)new CopyCitationAction(CitationStyleOutputFormat.TEXT, dialogService, stateManager, clipBoardManager, taskExecutor, preferencesService, abbreviationRepository))});
        } else {
            copySpecialMenu.getItems().add((Object)factory.createMenuItem(StandardActions.COPY_CITATION_PREVIEW, (Command)new CopyCitationAction(CitationStyleOutputFormat.HTML, dialogService, stateManager, clipBoardManager, taskExecutor, preferencesService, abbreviationRepository)));
        }
        copySpecialMenu.getItems().addAll((Object[])new MenuItem[]{new SeparatorMenuItem(), factory.createMenuItem(StandardActions.EXPORT_TO_CLIPBOARD, (Command)new ExportToClipboardAction(dialogService, stateManager, clipBoardManager, taskExecutor, preferencesService))});
        return copySpecialMenu;
    }

    private static Menu createSendSubMenu(ActionFactory factory, DialogService dialogService, StateManager stateManager, PreferencesService preferencesService, BibEntryTypesManager entryTypesManager, TaskExecutor taskExecutor) {
        Menu sendMenu = factory.createMenu(StandardActions.SEND);
        sendMenu.getItems().addAll((Object[])new MenuItem[]{factory.createMenuItem(StandardActions.SEND_AS_EMAIL, (Command)new SendAsStandardEmailAction(dialogService, preferencesService, stateManager, entryTypesManager, taskExecutor)), factory.createMenuItem(StandardActions.SEND_TO_KINDLE, (Command)new SendAsKindleEmailAction(dialogService, preferencesService, stateManager, taskExecutor)), new SeparatorMenuItem()});
        return sendMenu;
    }
}

