/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.maintable;

import de.saxsys.mvvmfx.utils.commands.Command;
import java.util.ArrayList;
import java.util.List;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.RadioMenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.TableColumn;
import javafx.scene.layout.StackPane;
import org.jabref.gui.DialogService;
import org.jabref.gui.LibraryTabContainer;
import org.jabref.gui.actions.ActionFactory;
import org.jabref.gui.actions.StandardActions;
import org.jabref.gui.maintable.BibEntryTableViewModel;
import org.jabref.gui.maintable.MainTable;
import org.jabref.gui.maintable.MainTableColumnFactory;
import org.jabref.gui.maintable.MainTableColumnModel;
import org.jabref.gui.maintable.columns.MainTableColumn;
import org.jabref.gui.preferences.ShowPreferencesAction;
import org.jabref.gui.preferences.table.TableTab;
import org.jabref.logic.l10n.Localization;

public class MainTableHeaderContextMenu
extends ContextMenu {
    private static final int OUT_OF_BOUNDS = -1;
    MainTable mainTable;
    MainTableColumnFactory factory;
    private final LibraryTabContainer tabContainer;
    private final DialogService dialogService;

    public MainTableHeaderContextMenu(MainTable mainTable, MainTableColumnFactory factory, LibraryTabContainer tabContainer, DialogService dialogService) {
        this.tabContainer = tabContainer;
        this.mainTable = mainTable;
        this.factory = factory;
        this.dialogService = dialogService;
        this.constructItems();
    }

    public void show(boolean show) {
        this.mainTable.setOnContextMenuRequested(event -> {
            if (!(event.getTarget() instanceof StackPane) && show) {
                this.show((Node)this.mainTable, event.getScreenX(), event.getScreenY());
            } else if (this.isShowing()) {
                this.hide();
            }
            event.consume();
        });
    }

    private void constructItems() {
        RightClickMenuItem itemToAdd;
        this.getItems().clear();
        List<TableColumn<BibEntryTableViewModel, ?>> commonColumns = this.commonColumns();
        for (TableColumn column : this.mainTable.getColumns()) {
            itemToAdd = this.createMenuItem(column, true);
            this.getItems().add((Object)itemToAdd);
            MainTableColumn searchCol = (MainTableColumn)column;
            if (!this.isACommonColumn(searchCol)) continue;
            commonColumns.removeIf(tableCol -> ((MainTableColumn)((Object)tableCol)).getModel().equals(searchCol.getModel()));
        }
        if (!commonColumns.isEmpty()) {
            this.getItems().add((Object)new SeparatorMenuItem());
            for (TableColumn<BibEntryTableViewModel, ?> tableColumn : commonColumns) {
                itemToAdd = this.createMenuItem(tableColumn, false);
                this.getItems().add((Object)itemToAdd);
            }
        }
        this.getItems().add((Object)new SeparatorMenuItem());
        ActionFactory actionfactory = new ActionFactory();
        MenuItem showMoreItem = actionfactory.createMenuItem(StandardActions.SHOW_PREFS.withText(Localization.lang("More options...", new Object[0])), (Command)new ShowPreferencesAction(this.tabContainer, TableTab.class, this.dialogService));
        this.getItems().add((Object)showMoreItem);
    }

    private RightClickMenuItem createMenuItem(TableColumn<BibEntryTableViewModel, ?> column, boolean isDisplaying) {
        MainTableColumn tableColumn = (MainTableColumn)column;
        String displayName = tableColumn.getDisplayName();
        return new RightClickMenuItem(displayName, tableColumn, isDisplaying);
    }

    private int obtainIndexOfColumn(MainTableColumn<?> searchColumn) {
        ObservableList columns = this.mainTable.getColumns();
        for (int i = 0; i < columns.size(); ++i) {
            TableColumn column = (TableColumn)columns.get(i);
            MainTableColumnModel model = ((MainTableColumn)column).getModel();
            if (!model.equals(searchColumn.getModel())) continue;
            return i;
        }
        return -1;
    }

    private void addColumn(MainTableColumn<?> tableColumn, int index) {
        if (index <= -1 || index >= this.mainTable.getColumns().size()) {
            this.mainTable.getColumns().add(tableColumn);
        } else {
            this.mainTable.getColumns().add(index, tableColumn);
        }
    }

    private void removeColumn(MainTableColumn<?> tableColumn) {
        this.mainTable.getColumns().removeIf(tableCol -> ((MainTableColumn)((Object)tableCol)).getModel().equals(tableColumn.getModel()));
    }

    private boolean isACommonColumn(MainTableColumn<?> tableColumn) {
        return this.isColumnInList(tableColumn, this.commonColumns());
    }

    private boolean isColumnInList(MainTableColumn<?> searchColumn, List<TableColumn<BibEntryTableViewModel, ?>> tableColumns) {
        for (TableColumn<BibEntryTableViewModel, ?> column : tableColumns) {
            MainTableColumnModel model = ((MainTableColumn)column).getModel();
            if (!model.equals(searchColumn.getModel())) continue;
            return true;
        }
        return false;
    }

    private List<TableColumn<BibEntryTableViewModel, ?>> commonColumns() {
        String entryTypeQualifier = "entrytype";
        String authorEditQualifier = "author/editor";
        String titleQualifier = "title";
        String yearQualifier = "year";
        String journalBookQualifier = "journal/booktitle";
        String rankQualifier = "ranking";
        String readStatusQualifier = "readstatus";
        String priorityQualifier = "priority";
        ArrayList<MainTableColumnModel> commonColumns = new ArrayList<MainTableColumnModel>();
        commonColumns.add(new MainTableColumnModel(MainTableColumnModel.Type.GROUPS));
        commonColumns.add(new MainTableColumnModel(MainTableColumnModel.Type.GROUP_ICONS));
        commonColumns.add(new MainTableColumnModel(MainTableColumnModel.Type.FILES));
        commonColumns.add(new MainTableColumnModel(MainTableColumnModel.Type.LINKED_IDENTIFIER));
        commonColumns.add(new MainTableColumnModel(MainTableColumnModel.Type.NORMALFIELD, entryTypeQualifier));
        commonColumns.add(new MainTableColumnModel(MainTableColumnModel.Type.NORMALFIELD, authorEditQualifier));
        commonColumns.add(new MainTableColumnModel(MainTableColumnModel.Type.NORMALFIELD, titleQualifier));
        commonColumns.add(new MainTableColumnModel(MainTableColumnModel.Type.NORMALFIELD, yearQualifier));
        commonColumns.add(new MainTableColumnModel(MainTableColumnModel.Type.NORMALFIELD, journalBookQualifier));
        commonColumns.add(new MainTableColumnModel(MainTableColumnModel.Type.SPECIALFIELD, rankQualifier));
        commonColumns.add(new MainTableColumnModel(MainTableColumnModel.Type.SPECIALFIELD, readStatusQualifier));
        commonColumns.add(new MainTableColumnModel(MainTableColumnModel.Type.SPECIALFIELD, priorityQualifier));
        ArrayList commonTableColumns = new ArrayList();
        for (MainTableColumnModel columnModel : commonColumns) {
            TableColumn<BibEntryTableViewModel, ?> tableColumn = this.factory.createColumn(columnModel);
            commonTableColumns.add(tableColumn);
        }
        return commonTableColumns;
    }

    private class RightClickMenuItem
    extends RadioMenuItem {
        private int index;
        private boolean visibleInTable;

        RightClickMenuItem(String displayName, MainTableColumn<?> column, boolean isVisible) {
            super(displayName);
            this.setVisibleInTable(isVisible);
            this.setSelected(isVisible);
            this.setIndex(-1);
            this.setOnAction(event -> {
                if (this.isVisibleInTable()) {
                    this.setIndex(MainTableHeaderContextMenu.this.obtainIndexOfColumn(column));
                    MainTableHeaderContextMenu.this.removeColumn(column);
                } else {
                    MainTableHeaderContextMenu.this.addColumn(column, this.index);
                    this.setIndex(MainTableHeaderContextMenu.this.obtainIndexOfColumn(column));
                }
                this.setVisibleInTable(!this.visibleInTable);
            });
        }

        public void setIndex(int index) {
            this.index = index;
        }

        public void setVisibleInTable(boolean visibleInTable) {
            this.visibleInTable = visibleInTable;
        }

        public boolean isVisibleInTable() {
            return this.visibleInTable;
        }
    }
}

