/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.maintable;

import com.tobiasdiez.easybind.EasyBind;
import com.tobiasdiez.easybind.EasyBinding;
import com.tobiasdiez.easybind.optional.OptionalBinding;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javafx.beans.Observable;
import javafx.beans.binding.Binding;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.StringBinding;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import org.jabref.gui.maintable.MainTableFieldValueFormatter;
import org.jabref.gui.specialfields.SpecialFieldValueViewModel;
import org.jabref.gui.util.uithreadaware.UiThreadBinding;
import org.jabref.logic.importer.util.FileFieldParser;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.LinkedFile;
import org.jabref.model.entry.field.Field;
import org.jabref.model.entry.field.OrFields;
import org.jabref.model.entry.field.SpecialField;
import org.jabref.model.entry.field.StandardField;
import org.jabref.model.groups.AbstractGroup;
import org.jabref.model.groups.GroupTreeNode;

public class BibEntryTableViewModel {
    private final BibEntry entry;
    private final ObservableValue<MainTableFieldValueFormatter> fieldValueFormatter;
    private final Map<OrFields, ObservableValue<String>> fieldValues = new HashMap<OrFields, ObservableValue<String>>();
    private final Map<SpecialField, OptionalBinding<SpecialFieldValueViewModel>> specialFieldValues = new HashMap<SpecialField, OptionalBinding<SpecialFieldValueViewModel>>();
    private final EasyBinding<List<LinkedFile>> linkedFiles;
    private final EasyBinding<Map<Field, String>> linkedIdentifiers;
    private final Binding<List<AbstractGroup>> matchedGroups;
    private final BibDatabaseContext bibDatabaseContext;

    public BibEntryTableViewModel(BibEntry entry, BibDatabaseContext bibDatabaseContext, ObservableValue<MainTableFieldValueFormatter> fieldValueFormatter) {
        this.entry = entry;
        this.fieldValueFormatter = fieldValueFormatter;
        this.linkedFiles = this.getField(StandardField.FILE).mapOpt(FileFieldParser::parse).orElseOpt(Collections.emptyList());
        this.linkedIdentifiers = BibEntryTableViewModel.createLinkedIdentifiersBinding(entry);
        this.matchedGroups = BibEntryTableViewModel.createMatchedGroupsBinding(bibDatabaseContext, entry);
        this.bibDatabaseContext = bibDatabaseContext;
    }

    private static EasyBinding<Map<Field, String>> createLinkedIdentifiersBinding(BibEntry entry) {
        return EasyBind.combine(entry.getFieldBinding(StandardField.URL), entry.getFieldBinding(StandardField.DOI), entry.getFieldBinding(StandardField.URI), entry.getFieldBinding(StandardField.EPRINT), entry.getFieldBinding(StandardField.ISBN), (url, doi, uri, eprint, isbn) -> {
            HashMap identifiers = new HashMap();
            url.ifPresent(value -> identifiers.put(StandardField.URL, value));
            doi.ifPresent(value -> identifiers.put(StandardField.DOI, value));
            uri.ifPresent(value -> identifiers.put(StandardField.URI, value));
            eprint.ifPresent(value -> identifiers.put(StandardField.EPRINT, value));
            isbn.ifPresent(value -> identifiers.put(StandardField.ISBN, value));
            return identifiers;
        });
    }

    public BibEntry getEntry() {
        return this.entry;
    }

    private static Binding<List<AbstractGroup>> createMatchedGroupsBinding(BibDatabaseContext database, BibEntry entry) {
        return new UiThreadBinding<List<AbstractGroup>>((Binding<List<AbstractGroup>>)EasyBind.combine(entry.getFieldBinding(StandardField.GROUPS), database.getMetaData().groupsBinding(), (a, b) -> database.getMetaData().getGroups().map(groupTreeNode -> groupTreeNode.getMatchingGroups(entry).stream().map(GroupTreeNode::getGroup).filter(Predicate.not(Predicate.isEqual(groupTreeNode.getGroup()))).collect(Collectors.toList())).orElse(Collections.emptyList())));
    }

    public OptionalBinding<String> getField(Field field) {
        return this.entry.getFieldBinding(field);
    }

    public ObservableValue<List<LinkedFile>> getLinkedFiles() {
        return this.linkedFiles;
    }

    public ObservableValue<Map<Field, String>> getLinkedIdentifiers() {
        return this.linkedIdentifiers;
    }

    public ObservableValue<List<AbstractGroup>> getMatchedGroups() {
        return this.matchedGroups;
    }

    public ObservableValue<Optional<SpecialFieldValueViewModel>> getSpecialField(SpecialField field) {
        OptionalBinding value = this.specialFieldValues.get(field);
        Optional<String> currentValue = this.entry.getField(field);
        if (value != null) {
            if (currentValue.isEmpty() && ((Optional)value.getValue()).isEmpty()) {
                OptionalBinding zeroValue = this.getField(field).flatMapOpt(fieldValue -> field.parseValue("CLEAR_RANK").map(SpecialFieldValueViewModel::new));
                this.specialFieldValues.put(field, (OptionalBinding<SpecialFieldValueViewModel>)zeroValue);
                return zeroValue;
            }
            if (((Optional)value.getValue()).isEmpty() || !((SpecialFieldValueViewModel)((Optional)value.getValue()).get()).getValue().getFieldValue().equals(currentValue)) {
                value = this.getField(field).flatMapOpt(fieldValue -> field.parseValue((String)fieldValue).map(SpecialFieldValueViewModel::new));
                this.specialFieldValues.put(field, (OptionalBinding<SpecialFieldValueViewModel>)value);
                return value;
            }
        } else {
            value = this.getField(field).flatMapOpt(fieldValue -> field.parseValue((String)fieldValue).map(SpecialFieldValueViewModel::new));
            this.specialFieldValues.put(field, (OptionalBinding<SpecialFieldValueViewModel>)value);
        }
        return value;
    }

    public ObservableValue<String> getFields(OrFields fields) {
        StringBinding value = this.fieldValues.get(fields);
        if (value != null) {
            return value;
        }
        ArrayList<Observable> observables = new ArrayList<Observable>(List.of(this.entry.getObservables()));
        observables.add((Observable)this.fieldValueFormatter);
        value = Bindings.createStringBinding(() -> ((MainTableFieldValueFormatter)this.fieldValueFormatter.getValue()).formatFieldsValues(fields, this.entry), (Observable[])((Observable[])observables.toArray(Observable[]::new)));
        this.fieldValues.put(fields, (ObservableValue<String>)value);
        return value;
    }

    public StringProperty bibDatabasePathProperty() {
        return new ReadOnlyStringWrapper(this.bibDatabaseContext.getDatabasePath().map(Path::toString).orElse(""));
    }

    public BibDatabaseContext getBibDatabaseContext() {
        return this.bibDatabaseContext;
    }
}

