/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.linkedfile;

import com.tobiasdiez.easybind.EasyBind;
import com.tobiasdiez.easybind.optional.ObservableOptionalValue;
import java.lang.invoke.LambdaMetafactory;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Pattern;
import javafx.beans.property.ListProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleListProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.FXCollections;
import org.jabref.gui.AbstractViewModel;
import org.jabref.gui.DialogService;
import org.jabref.gui.externalfiletype.ExternalFileType;
import org.jabref.gui.externalfiletype.ExternalFileTypes;
import org.jabref.gui.externalfiletype.UnknownExternalFileType;
import org.jabref.gui.util.FileDialogConfiguration;
import org.jabref.logic.util.io.FileUtil;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.entry.LinkedFile;
import org.jabref.preferences.FilePreferences;

public class LinkedFilesEditDialogViewModel
extends AbstractViewModel {
    private static final Pattern REMOTE_LINK_PATTERN = Pattern.compile("[a-z]+://.*");
    private final StringProperty link = new SimpleStringProperty("");
    private final StringProperty description = new SimpleStringProperty("");
    private final StringProperty sourceUrl = new SimpleStringProperty("");
    private final ListProperty<ExternalFileType> allExternalFileTypes = new SimpleListProperty(FXCollections.emptyObservableList());
    private final ObjectProperty<ExternalFileType> selectedExternalFileType = new SimpleObjectProperty();
    private final ObservableOptionalValue<ExternalFileType> monadicSelectedExternalFileType;
    private final BibDatabaseContext database;
    private final DialogService dialogService;
    private final FilePreferences filePreferences;

    public LinkedFilesEditDialogViewModel(LinkedFile linkedFile, BibDatabaseContext database, DialogService dialogService, FilePreferences filePreferences) {
        this.database = database;
        this.dialogService = dialogService;
        this.filePreferences = filePreferences;
        this.allExternalFileTypes.set((Object)FXCollections.observableArrayList(filePreferences.getExternalFileTypes()));
        this.monadicSelectedExternalFileType = EasyBind.wrapNullable(this.selectedExternalFileType);
        this.setValues(linkedFile);
    }

    private void setExternalFileTypeByExtension(String link) {
        if (!link.isEmpty()) {
            if (REMOTE_LINK_PATTERN.matcher(link).matches()) {
                ExternalFileTypes.getExternalFileTypeByExt("html", this.filePreferences).ifPresent(arg_0 -> this.selectedExternalFileType.setValue(arg_0));
            }
            String theLink = link.trim();
            ExternalFileTypes.getExternalFileTypeForName(theLink, this.filePreferences).ifPresent(arg_0 -> this.selectedExternalFileType.setValue(arg_0));
        }
    }

    public void openBrowseDialog() {
        String fileText = (String)this.link.get();
        Optional<Path> file = FileUtil.find(this.database, fileText, this.filePreferences);
        Path workingDir = file.orElse(this.filePreferences.getWorkingDirectory());
        String fileName = Path.of(fileText, new String[0]).getFileName().toString();
        FileDialogConfiguration fileDialogConfiguration = new FileDialogConfiguration.Builder().withInitialDirectory(workingDir).withInitialFileName(fileName).build();
        this.dialogService.showFileOpenDialog(fileDialogConfiguration).ifPresent(path -> {
            this.filePreferences.setWorkingDirectory((Path)path);
            this.link.set((Object)this.relativize((Path)path));
            this.setExternalFileTypeByExtension(this.link.getValueSafe());
        });
    }

    public void setValues(LinkedFile linkedFile) {
        this.description.set((Object)linkedFile.getDescription());
        this.sourceUrl.set((Object)linkedFile.getSourceUrl());
        if (linkedFile.isOnlineLink()) {
            this.link.setValue(linkedFile.getLink());
        } else {
            this.link.setValue(this.relativize(Path.of(linkedFile.getLink(), new String[0])));
        }
        this.selectedExternalFileType.setValue(null);
        Optional<ExternalFileType> fileType = ExternalFileTypes.getExternalFileTypeByLinkedFile(linkedFile, false, this.filePreferences);
        if (fileType.isPresent() && !(fileType.get() instanceof UnknownExternalFileType)) {
            this.selectedExternalFileType.setValue((Object)fileType.get());
        } else if (linkedFile.getLink() != null && !linkedFile.getLink().isEmpty()) {
            this.setExternalFileTypeByExtension(linkedFile.getLink());
        }
    }

    public StringProperty linkProperty() {
        return this.link;
    }

    public StringProperty descriptionProperty() {
        return this.description;
    }

    public StringProperty sourceUrlProperty() {
        return this.sourceUrl;
    }

    public ListProperty<ExternalFileType> externalFileTypeProperty() {
        return this.allExternalFileTypes;
    }

    public ObjectProperty<ExternalFileType> selectedExternalFileTypeProperty() {
        return this.selectedExternalFileType;
    }

    public LinkedFile getNewLinkedFile() {
        String fileType = ((Optional)this.monadicSelectedExternalFileType.getValue()).map((Function<ExternalFileType, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, toString(), (Lorg/jabref/gui/externalfiletype/ExternalFileType;)Ljava/lang/String;)()).orElse("");
        if (LinkedFile.isOnlineLink(this.link.getValue())) {
            try {
                return new LinkedFile(this.description.getValue(), new URL(this.link.getValue()), fileType, this.sourceUrl.getValue());
            }
            catch (MalformedURLException e) {
                return new LinkedFile(this.description.getValue(), this.link.getValue(), fileType, this.sourceUrl.getValue());
            }
        }
        return new LinkedFile(this.description.getValue(), Path.of(this.link.getValue(), new String[0]), fileType, this.sourceUrl.getValue());
    }

    private String relativize(Path filePath) {
        return FileUtil.relativize(filePath, this.database, this.filePreferences).toString();
    }
}

