/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.libraryproperties.keypattern;

import javafx.beans.property.ListProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleListProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import org.jabref.gui.commonfxcontrols.CitationKeyPatternsPanelItemModel;
import org.jabref.gui.commonfxcontrols.CitationKeyPatternsPanelViewModel;
import org.jabref.gui.libraryproperties.PropertiesTabViewModel;
import org.jabref.logic.citationkeypattern.DatabaseCitationKeyPatterns;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.preferences.PreferencesService;

public class KeyPatternPropertiesViewModel
implements PropertiesTabViewModel {
    private final ListProperty<CitationKeyPatternsPanelItemModel> patternListProperty = new SimpleListProperty(FXCollections.observableArrayList());
    private final ObjectProperty<CitationKeyPatternsPanelItemModel> defaultKeyPatternProperty = new SimpleObjectProperty((Object)new CitationKeyPatternsPanelItemModel(new CitationKeyPatternsPanelViewModel.DefaultEntryType(), ""));
    private final PreferencesService preferencesService;
    private final BibDatabaseContext databaseContext;

    public KeyPatternPropertiesViewModel(BibDatabaseContext databaseContext, PreferencesService preferencesService) {
        this.databaseContext = databaseContext;
        this.preferencesService = preferencesService;
    }

    @Override
    public void setValues() {
    }

    @Override
    public void storeSettings() {
        DatabaseCitationKeyPatterns newKeyPattern = new DatabaseCitationKeyPatterns(this.preferencesService.getCitationKeyPatternPreferences().getKeyPatterns());
        this.patternListProperty.forEach(item -> {
            String patternString = item.getPattern();
            if (!"default".equals(item.getEntryType().getName()) && !patternString.trim().isEmpty()) {
                newKeyPattern.addCitationKeyPattern(item.getEntryType(), patternString);
            }
        });
        if (!((CitationKeyPatternsPanelItemModel)this.defaultKeyPatternProperty.getValue()).getPattern().trim().isEmpty()) {
            newKeyPattern.setDefaultValue(((CitationKeyPatternsPanelItemModel)this.defaultKeyPatternProperty.getValue()).getPattern());
        }
        this.databaseContext.getMetaData().setCiteKeyPattern(newKeyPattern);
    }

    public ListProperty<CitationKeyPatternsPanelItemModel> patternListProperty() {
        return this.patternListProperty;
    }

    public ObjectProperty<CitationKeyPatternsPanelItemModel> defaultKeyPatternProperty() {
        return this.defaultKeyPatternProperty;
    }
}

