/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.libraryproperties;

import java.util.List;
import org.jabref.gui.libraryproperties.PropertiesTab;
import org.jabref.gui.libraryproperties.constants.ConstantsPropertiesView;
import org.jabref.gui.libraryproperties.contentselectors.ContentSelectorView;
import org.jabref.gui.libraryproperties.general.GeneralPropertiesView;
import org.jabref.gui.libraryproperties.keypattern.KeyPatternPropertiesView;
import org.jabref.gui.libraryproperties.preamble.PreamblePropertiesView;
import org.jabref.gui.libraryproperties.saving.SavingPropertiesView;
import org.jabref.model.database.BibDatabaseContext;

public class LibraryPropertiesViewModel {
    private final List<PropertiesTab> propertiesTabs;

    public LibraryPropertiesViewModel(BibDatabaseContext databaseContext) {
        this.propertiesTabs = List.of(new GeneralPropertiesView(databaseContext), new SavingPropertiesView(databaseContext), new KeyPatternPropertiesView(databaseContext), new ConstantsPropertiesView(databaseContext), new ContentSelectorView(databaseContext), new PreamblePropertiesView(databaseContext));
    }

    public void setValues() {
        for (PropertiesTab propertiesTab : this.propertiesTabs) {
            propertiesTab.setValues();
        }
    }

    public void storeAllSettings() {
        for (PropertiesTab propertiesTab : this.propertiesTabs) {
            propertiesTab.storeSettings();
        }
    }

    public List<PropertiesTab> getPropertiesTabs() {
        return this.propertiesTabs;
    }
}

