/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.importer.fetcher;

import com.tobiasdiez.easybind.EasyBind;
import de.saxsys.mvvmfx.utils.commands.Command;
import de.saxsys.mvvmfx.utils.validation.ValidationMessage;
import javafx.beans.property.BooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.css.PseudoClass;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.TextField;
import javafx.scene.control.TextInputControl;
import javafx.scene.control.Tooltip;
import javafx.scene.input.KeyCode;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import org.controlsfx.control.textfield.CustomTextField;
import org.jabref.gui.ClipBoardManager;
import org.jabref.gui.DialogService;
import org.jabref.gui.StateManager;
import org.jabref.gui.actions.ActionFactory;
import org.jabref.gui.actions.StandardActions;
import org.jabref.gui.help.HelpAction;
import org.jabref.gui.importer.fetcher.WebSearchPaneViewModel;
import org.jabref.gui.search.SearchTextField;
import org.jabref.gui.util.ViewModelListCellFactory;
import org.jabref.logic.importer.WebFetcher;
import org.jabref.logic.l10n.Localization;
import org.jabref.preferences.PreferencesService;

public class WebSearchPaneView
extends VBox {
    private static final PseudoClass QUERY_INVALID = PseudoClass.getPseudoClass((String)"invalid");
    private final WebSearchPaneViewModel viewModel;
    private final PreferencesService preferences;
    private final DialogService dialogService;

    public WebSearchPaneView(PreferencesService preferences, DialogService dialogService, StateManager stateManager) {
        this.preferences = preferences;
        this.dialogService = dialogService;
        this.viewModel = new WebSearchPaneViewModel(preferences, dialogService, stateManager);
        this.initialize();
    }

    private void initialize() {
        ComboBox fetchers = new ComboBox();
        new ViewModelListCellFactory().withText(WebFetcher::getName).install(fetchers);
        fetchers.itemsProperty().bind(this.viewModel.fetchersProperty());
        fetchers.valueProperty().bindBidirectional(this.viewModel.selectedFetcherProperty());
        fetchers.setMaxWidth(Double.POSITIVE_INFINITY);
        HBox.setHgrow((Node)fetchers, (Priority)Priority.ALWAYS);
        StackPane helpButtonContainer = this.createHelpButtonContainer();
        HBox fetcherContainer = new HBox(new Node[]{fetchers, helpButtonContainer});
        CustomTextField query = SearchTextField.create(this.preferences.getKeyBindingRepository());
        this.getChildren().addAll((Object[])new Node[]{fetcherContainer, query, this.createSearchButton()});
        this.viewModel.queryProperty().bind((ObservableValue)query.textProperty());
        this.addQueryValidationHints((TextField)query);
        this.enableEnterToTriggerSearch((TextField)query);
        ClipBoardManager.addX11Support((TextInputControl)query);
    }

    private void enableEnterToTriggerSearch(TextField query) {
        query.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER) {
                this.viewModel.search();
            }
        });
    }

    private void addQueryValidationHints(TextField query) {
        EasyBind.subscribe((ObservableValue)this.viewModel.queryValidationStatus().validProperty(), valid -> {
            if (!valid.booleanValue() && this.viewModel.queryValidationStatus().getHighestMessage().isPresent()) {
                query.setTooltip(new Tooltip(((ValidationMessage)this.viewModel.queryValidationStatus().getHighestMessage().get()).getMessage()));
                query.pseudoClassStateChanged(QUERY_INVALID, true);
            } else {
                query.setTooltip(null);
                query.pseudoClassStateChanged(QUERY_INVALID, false);
            }
        });
    }

    private Button createSearchButton() {
        BooleanProperty importerEnabled = this.preferences.getImporterPreferences().importerEnabledProperty();
        Button search = new Button(Localization.lang("Search", new Object[0]));
        search.setDefaultButton(false);
        search.setOnAction(event -> this.viewModel.search());
        search.setMaxWidth(Double.MAX_VALUE);
        search.disableProperty().bind((ObservableValue)importerEnabled.not());
        return search;
    }

    private StackPane createHelpButtonContainer() {
        StackPane helpButtonContainer = new StackPane();
        ActionFactory factory = new ActionFactory();
        EasyBind.subscribe(this.viewModel.selectedFetcherProperty(), fetcher -> {
            if (fetcher != null && fetcher.getHelpPage().isPresent()) {
                Button helpButton = factory.createIconButton(StandardActions.HELP, (Command)new HelpAction(fetcher.getHelpPage().get(), this.dialogService, this.preferences.getFilePreferences()));
                helpButtonContainer.getChildren().setAll((Object[])new Node[]{helpButton});
            } else {
                helpButtonContainer.getChildren().clear();
            }
        });
        return helpButtonContainer;
    }
}

