/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.importer.fetcher;

import java.util.List;
import java.util.Optional;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javax.swing.undo.UndoManager;
import org.jabref.gui.DialogService;
import org.jabref.gui.StateManager;
import org.jabref.gui.actions.Action;
import org.jabref.gui.actions.ActionHelper;
import org.jabref.gui.actions.SimpleCommand;
import org.jabref.gui.undo.NamedCompound;
import org.jabref.gui.undo.UndoableFieldChange;
import org.jabref.gui.util.BackgroundTask;
import org.jabref.gui.util.BindingsHelper;
import org.jabref.gui.util.TaskExecutor;
import org.jabref.gui.util.UiTaskExecutor;
import org.jabref.logic.importer.FetcherException;
import org.jabref.logic.importer.IdFetcher;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.FieldChange;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.identifier.Identifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LookupIdentifierAction<T extends Identifier>
extends SimpleCommand {
    private static final Logger LOGGER = LoggerFactory.getLogger(LookupIdentifierAction.class);
    private final IdFetcher<T> fetcher;
    private final StateManager stateManager;
    private final UndoManager undoManager;
    private final DialogService dialogService;
    private final TaskExecutor taskExecutor;

    public LookupIdentifierAction(IdFetcher<T> fetcher, StateManager stateManager, UndoManager undoManager, DialogService dialogService, TaskExecutor taskExecutor) {
        this.fetcher = fetcher;
        this.stateManager = stateManager;
        this.undoManager = undoManager;
        this.dialogService = dialogService;
        this.taskExecutor = taskExecutor;
        this.executable.bind((ObservableValue)ActionHelper.needsDatabase(this.stateManager).and((ObservableBooleanValue)ActionHelper.needsEntriesSelected(this.stateManager)));
        this.statusMessage.bind(BindingsHelper.ifThenElse((ObservableValue<Boolean>)this.executable, "", Localization.lang("This operation requires one or more entries to be selected.", new Object[0])));
    }

    public void execute() {
        try {
            BackgroundTask.wrap(() -> this.lookupIdentifiers((List<BibEntry>)this.stateManager.getSelectedEntries())).onSuccess(this.dialogService::notify).executeWith(this.taskExecutor);
        }
        catch (Exception e) {
            LOGGER.error("Problem running ID Worker", (Throwable)e);
        }
    }

    public Action getAction() {
        return this.fetcher::getIdentifierName;
    }

    private String lookupIdentifiers(List<BibEntry> bibEntries) {
        String totalCount = Integer.toString(bibEntries.size());
        NamedCompound namedCompound = new NamedCompound(Localization.lang("Look up %0", this.fetcher.getIdentifierName()));
        int count = 0;
        int foundCount = 0;
        for (BibEntry bibEntry : bibEntries) {
            Optional<FieldChange> fieldChange;
            String statusMessage = Localization.lang("Looking up %0... - entry %1 out of %2 - found %3", this.fetcher.getIdentifierName(), Integer.toString(++count), totalCount, Integer.toString(foundCount));
            UiTaskExecutor.runInJavaFXThread(() -> this.dialogService.notify(statusMessage));
            Optional identifier = Optional.empty();
            try {
                identifier = this.fetcher.findIdentifier(bibEntry);
            }
            catch (FetcherException e) {
                LOGGER.error("Could not fetch " + this.fetcher.getIdentifierName(), (Throwable)e);
            }
            if (!identifier.isPresent() || bibEntry.hasField(((Identifier)identifier.get()).getDefaultField()) || !(fieldChange = bibEntry.setField(((Identifier)identifier.get()).getDefaultField(), ((Identifier)identifier.get()).getNormalized())).isPresent()) continue;
            namedCompound.addEdit(new UndoableFieldChange(fieldChange.get()));
            String nextStatusMessage = Localization.lang("Looking up %0... - entry %1 out of %2 - found %3", this.fetcher.getIdentifierName(), Integer.toString(count), totalCount, Integer.toString(++foundCount));
            UiTaskExecutor.runInJavaFXThread(() -> this.dialogService.notify(nextStatusMessage));
        }
        namedCompound.end();
        if (foundCount > 0) {
            this.undoManager.addEdit(namedCompound);
        }
        return Localization.lang("Determined %0 for %1 entries", this.fetcher.getIdentifierName(), Integer.toString(foundCount));
    }
}

