/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.importer;

import com.airhacks.afterburner.views.ViewLoader;
import jakarta.inject.Inject;
import java.util.List;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.cell.CheckBoxListCell;
import javafx.scene.layout.VBox;
import org.controlsfx.control.CheckListView;
import org.jabref.gui.importer.BibEntryTypePrefsAndFileViewModel;
import org.jabref.gui.importer.ImportCustomEntryTypesDialogViewModel;
import org.jabref.gui.util.BaseDialog;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.database.BibDatabaseMode;
import org.jabref.model.entry.BibEntryType;
import org.jabref.preferences.PreferencesService;

public class ImportCustomEntryTypesDialog
extends BaseDialog<Void> {
    private final List<BibEntryType> customEntryTypes;
    @Inject
    private PreferencesService preferencesService;
    @FXML
    private VBox boxDifferentCustomization;
    @FXML
    private CheckListView<BibEntryType> unknownEntryTypesCheckList;
    @FXML
    private CheckListView<BibEntryTypePrefsAndFileViewModel> differentCustomizationCheckList;
    private final BibDatabaseMode mode;
    private ImportCustomEntryTypesDialogViewModel viewModel;

    public ImportCustomEntryTypesDialog(BibDatabaseMode mode, List<BibEntryType> customEntryTypes) {
        this.mode = mode;
        this.customEntryTypes = customEntryTypes;
        ViewLoader.view((Object)((Object)this)).load().setAsDialogPane((Dialog)this);
        this.setResultConverter(btn -> {
            if (btn == ButtonType.OK) {
                this.viewModel.importBibEntryTypes((List<BibEntryType>)this.unknownEntryTypesCheckList.getCheckModel().getCheckedItems(), this.differentCustomizationCheckList.getCheckModel().getCheckedItems().stream().map(BibEntryTypePrefsAndFileViewModel::customTypeFromPreferences).toList());
            }
            return null;
        });
        this.setTitle(Localization.lang("Custom entry types", new Object[0]));
    }

    @FXML
    public void initialize() {
        this.viewModel = new ImportCustomEntryTypesDialogViewModel(this.mode, this.customEntryTypes, this.preferencesService);
        this.boxDifferentCustomization.visibleProperty().bind((ObservableValue)Bindings.isNotEmpty(this.viewModel.differentCustomizations()));
        this.boxDifferentCustomization.managedProperty().bind((ObservableValue)Bindings.isNotEmpty(this.viewModel.differentCustomizations()));
        this.unknownEntryTypesCheckList.setItems(this.viewModel.newTypes());
        this.unknownEntryTypesCheckList.setCellFactory(listView -> new CheckBoxListCell<BibEntryType>(this, arg_0 -> this.unknownEntryTypesCheckList.getItemBooleanProperty(arg_0)){

            public void updateItem(BibEntryType bibEntryType, boolean empty) {
                super.updateItem((Object)bibEntryType, empty);
                this.setText(bibEntryType == null ? "" : bibEntryType.getType().getDisplayName());
            }
        });
        this.differentCustomizationCheckList.setItems(this.viewModel.differentCustomizations());
    }
}

