/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.groups;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.UndoManager;
import org.jabref.gui.groups.GroupDescriptions;
import org.jabref.gui.groups.UndoableAddOrRemoveGroup;
import org.jabref.gui.groups.UndoableChangeEntriesOfGroup;
import org.jabref.gui.undo.CountingUndoManager;
import org.jabref.model.FieldChange;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.groups.AbstractGroup;
import org.jabref.model.groups.AllEntriesGroup;
import org.jabref.model.groups.ExplicitGroup;
import org.jabref.model.groups.GroupEntryChanger;
import org.jabref.model.groups.GroupTreeNode;
import org.jabref.model.groups.KeywordGroup;
import org.jabref.model.groups.SearchGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupTreeNodeViewModel {
    private static final Logger LOGGER = LoggerFactory.getLogger(GroupTreeNodeViewModel.class);
    private final GroupTreeNode node;

    public GroupTreeNodeViewModel(GroupTreeNode node) {
        this.node = node;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("GroupTreeNodeViewModel{");
        sb.append("node=").append(this.node);
        sb.append('}');
        return sb.toString();
    }

    public GroupTreeNode getNode() {
        return this.node;
    }

    public List<GroupTreeNodeViewModel> getChildren() {
        ArrayList<GroupTreeNodeViewModel> children = new ArrayList<GroupTreeNodeViewModel>();
        for (GroupTreeNode child : this.node.getChildren()) {
            children.add(new GroupTreeNodeViewModel(child));
        }
        return children;
    }

    protected boolean printInItalics() {
        return this.node.getGroup().isDynamic();
    }

    public String getDescription() {
        AbstractGroup group = this.node.getGroup();
        String shortDescription = "";
        boolean showDynamic = true;
        if (group instanceof ExplicitGroup) {
            ExplicitGroup explicitGroup = (ExplicitGroup)group;
            shortDescription = GroupDescriptions.getShortDescriptionExplicitGroup(explicitGroup);
        } else if (group instanceof KeywordGroup) {
            KeywordGroup keywordGroup = (KeywordGroup)group;
            shortDescription = GroupDescriptions.getShortDescriptionKeywordGroup(keywordGroup, showDynamic);
        } else if (group instanceof SearchGroup) {
            SearchGroup searchGroup = (SearchGroup)group;
            shortDescription = GroupDescriptions.getShortDescription(searchGroup, showDynamic);
        } else {
            shortDescription = GroupDescriptions.getShortDescriptionAllEntriesGroup();
        }
        return "<html>" + shortDescription + "</html>";
    }

    public boolean canAddEntries(List<BibEntry> entries) {
        return this.getNode().getGroup() instanceof GroupEntryChanger && !this.getNode().getGroup().containsAll(entries);
    }

    public boolean canRemoveEntries(List<BibEntry> entries) {
        return this.getNode().getGroup() instanceof GroupEntryChanger && this.getNode().getGroup().containsAny(entries);
    }

    public void sortChildrenByName(boolean recursive) {
        this.getNode().sortChildren((node1, node2) -> node1.getGroup().getName().compareToIgnoreCase(node2.getGroup().getName()), recursive);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GroupTreeNodeViewModel viewModel = (GroupTreeNodeViewModel)o;
        return this.node.equals(viewModel.node);
    }

    public int hashCode() {
        return this.node.hashCode();
    }

    public String getName() {
        return this.getNode().getGroup().getName();
    }

    public boolean canBeEdited() {
        return this.getNode().getGroup() instanceof AllEntriesGroup;
    }

    public boolean canMoveUp() {
        return this.getNode().getPreviousSibling() != null && !(this.getNode().getGroup() instanceof AllEntriesGroup);
    }

    public boolean canMoveDown() {
        return this.getNode().getNextSibling() != null && !(this.getNode().getGroup() instanceof AllEntriesGroup);
    }

    public boolean canMoveLeft() {
        return !(this.getNode().getGroup() instanceof AllEntriesGroup) && !(((GroupTreeNode)this.getNode().getParent().get()).getGroup() instanceof AllEntriesGroup);
    }

    public boolean canMoveRight() {
        return this.getNode().getPreviousSibling() != null && !(this.getNode().getGroup() instanceof AllEntriesGroup);
    }

    public void changeEntriesTo(List<BibEntry> entries, UndoManager undoManager) {
        AbstractGroup group = this.node.getGroup();
        List<Object> changesRemove = new ArrayList();
        List<Object> changesAdd = new ArrayList();
        ArrayList<BibEntry> toRemove = new ArrayList<BibEntry>(entries.size());
        ArrayList<BibEntry> toAdd = new ArrayList<BibEntry>(entries.size());
        for (BibEntry entry : entries) {
            if (group.contains(entry)) {
                toRemove.add(entry);
                continue;
            }
            toAdd.add(entry);
        }
        if (!toRemove.isEmpty()) {
            changesRemove = this.removeEntriesFromGroup(toRemove);
        }
        if (!toAdd.isEmpty()) {
            changesAdd = this.addEntriesToGroup(toAdd);
        }
        if (!changesRemove.isEmpty()) {
            AbstractUndoableEdit undoRemove = UndoableChangeEntriesOfGroup.getUndoableEdit(this, changesRemove);
            if (!changesAdd.isEmpty() && undoRemove != null) {
                undoRemove.addEdit(UndoableChangeEntriesOfGroup.getUndoableEdit(this, changesAdd));
            }
            undoManager.addEdit(undoRemove);
        } else if (!changesAdd.isEmpty()) {
            undoManager.addEdit(UndoableChangeEntriesOfGroup.getUndoableEdit(this, changesAdd));
        }
    }

    public List<FieldChange> removeEntriesFromGroup(List<BibEntry> entries) {
        return this.node.removeEntriesFromGroup(entries);
    }

    public boolean isAllEntriesGroup() {
        return this.getNode().getGroup() instanceof AllEntriesGroup;
    }

    public void addNewGroup(AbstractGroup newGroup, CountingUndoManager undoManager) {
        GroupTreeNode newNode = GroupTreeNode.fromGroup(newGroup);
        this.getNode().addChild(newNode);
        UndoableAddOrRemoveGroup undo = new UndoableAddOrRemoveGroup(this, new GroupTreeNodeViewModel(newNode), 0);
        undoManager.addEdit(undo);
    }

    public List<FieldChange> addEntriesToGroup(List<BibEntry> entries) {
        return this.node.addEntriesToGroup(entries);
    }

    public void subscribeToDescendantChanged(Consumer<GroupTreeNodeViewModel> subscriber) {
        this.getNode().subscribeToDescendantChanged((T node) -> subscriber.accept(new GroupTreeNodeViewModel((GroupTreeNode)node)));
    }
}

