/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.groups;

import de.saxsys.mvvmfx.utils.validation.CompositeValidator;
import de.saxsys.mvvmfx.utils.validation.FunctionBasedValidator;
import de.saxsys.mvvmfx.utils.validation.ValidationMessage;
import de.saxsys.mvvmfx.utils.validation.ValidationStatus;
import de.saxsys.mvvmfx.utils.validation.Validator;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ListProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleListProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.event.Event;
import javafx.scene.control.ButtonType;
import javafx.scene.paint.Color;
import org.jabref.gui.DialogService;
import org.jabref.gui.groups.GroupColorPicker;
import org.jabref.gui.icon.IconTheme;
import org.jabref.gui.util.FileDialogConfiguration;
import org.jabref.logic.auxparser.DefaultAuxParser;
import org.jabref.logic.l10n.Localization;
import org.jabref.logic.util.StandardFileType;
import org.jabref.logic.util.io.FileUtil;
import org.jabref.model.database.BibDatabase;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.entry.Keyword;
import org.jabref.model.entry.field.FieldFactory;
import org.jabref.model.groups.AbstractGroup;
import org.jabref.model.groups.AutomaticGroup;
import org.jabref.model.groups.AutomaticKeywordGroup;
import org.jabref.model.groups.AutomaticPersonsGroup;
import org.jabref.model.groups.ExplicitGroup;
import org.jabref.model.groups.GroupHierarchyType;
import org.jabref.model.groups.GroupTreeNode;
import org.jabref.model.groups.RegexKeywordGroup;
import org.jabref.model.groups.SearchGroup;
import org.jabref.model.groups.TexGroup;
import org.jabref.model.groups.WordKeywordGroup;
import org.jabref.model.metadata.MetaData;
import org.jabref.model.search.rules.SearchRules;
import org.jabref.model.strings.StringUtil;
import org.jabref.model.util.FileUpdateMonitor;
import org.jabref.preferences.PreferencesService;
import org.jspecify.annotations.Nullable;

public class GroupDialogViewModel {
    private final StringProperty nameProperty = new SimpleStringProperty("");
    private final StringProperty descriptionProperty = new SimpleStringProperty("");
    private final StringProperty iconProperty = new SimpleStringProperty("");
    private final BooleanProperty colorUseProperty = new SimpleBooleanProperty();
    private final ObjectProperty<Color> colorProperty = new SimpleObjectProperty();
    private final ListProperty<GroupHierarchyType> groupHierarchyListProperty = new SimpleListProperty();
    private final ObjectProperty<GroupHierarchyType> groupHierarchySelectedProperty = new SimpleObjectProperty();
    private final BooleanProperty typeExplicitProperty = new SimpleBooleanProperty();
    private final BooleanProperty typeKeywordsProperty = new SimpleBooleanProperty();
    private final BooleanProperty typeSearchProperty = new SimpleBooleanProperty();
    private final BooleanProperty typeAutoProperty = new SimpleBooleanProperty();
    private final BooleanProperty typeTexProperty = new SimpleBooleanProperty();
    private final StringProperty keywordGroupSearchTermProperty = new SimpleStringProperty("");
    private final StringProperty keywordGroupSearchFieldProperty = new SimpleStringProperty("");
    private final BooleanProperty keywordGroupCaseSensitiveProperty = new SimpleBooleanProperty();
    private final BooleanProperty keywordGroupRegexProperty = new SimpleBooleanProperty();
    private final StringProperty searchGroupSearchTermProperty = new SimpleStringProperty("");
    private final ObjectProperty<EnumSet<SearchRules.SearchFlags>> searchFlagsProperty = new SimpleObjectProperty(EnumSet.noneOf(SearchRules.SearchFlags.class));
    private final BooleanProperty autoGroupKeywordsOptionProperty = new SimpleBooleanProperty();
    private final StringProperty autoGroupKeywordsFieldProperty = new SimpleStringProperty("");
    private final StringProperty autoGroupKeywordsDelimiterProperty = new SimpleStringProperty("");
    private final StringProperty autoGroupKeywordsHierarchicalDelimiterProperty = new SimpleStringProperty("");
    private final BooleanProperty autoGroupPersonsOptionProperty = new SimpleBooleanProperty();
    private final StringProperty autoGroupPersonsFieldProperty = new SimpleStringProperty("");
    private final StringProperty texGroupFilePathProperty = new SimpleStringProperty("");
    private Validator nameValidator;
    private Validator nameContainsDelimiterValidator;
    private Validator sameNameValidator;
    private Validator keywordRegexValidator;
    private Validator keywordFieldEmptyValidator;
    private Validator keywordSearchTermEmptyValidator;
    private Validator searchRegexValidator;
    private Validator searchSearchTermEmptyValidator;
    private Validator texGroupFilePathValidator;
    private CompositeValidator validator;
    private final DialogService dialogService;
    private final PreferencesService preferencesService;
    private final BibDatabaseContext currentDatabase;
    private final AbstractGroup editedGroup;
    private final GroupTreeNode parentNode;
    private final FileUpdateMonitor fileUpdateMonitor;

    public GroupDialogViewModel(DialogService dialogService, BibDatabaseContext currentDatabase, PreferencesService preferencesService, @Nullable AbstractGroup editedGroup, @Nullable GroupTreeNode parentNode, FileUpdateMonitor fileUpdateMonitor) {
        this.dialogService = dialogService;
        this.preferencesService = preferencesService;
        this.currentDatabase = currentDatabase;
        this.editedGroup = editedGroup;
        this.parentNode = parentNode;
        this.fileUpdateMonitor = fileUpdateMonitor;
        this.setupValidation();
        this.setValues();
    }

    private void setupValidation() {
        this.validator = new CompositeValidator();
        this.nameValidator = new FunctionBasedValidator((ObservableValue)this.nameProperty, StringUtil::isNotBlank, ValidationMessage.error((String)Localization.lang("Please enter a name for the group.", new Object[0])));
        this.nameContainsDelimiterValidator = new FunctionBasedValidator((ObservableValue)this.nameProperty, name -> !name.contains(Character.toString(this.preferencesService.getBibEntryPreferences().getKeywordSeparator().charValue())), ValidationMessage.warning((String)Localization.lang("The group name contains the keyword separator \"%0\" and thus probably does not work as expected.", Character.toString(this.preferencesService.getBibEntryPreferences().getKeywordSeparator().charValue()))));
        this.sameNameValidator = new FunctionBasedValidator((ObservableValue)this.nameProperty, name -> {
            Optional<GroupTreeNode> rootGroup = this.currentDatabase.getMetaData().getGroups();
            if (rootGroup.isPresent()) {
                int groupsWithSameName = rootGroup.get().findChildrenSatisfying(group -> group.getName().equals(name)).size();
                if (this.editedGroup == null && groupsWithSameName > 0) {
                    return false;
                }
                return this.editedGroup == null || this.editedGroup.getName().equals(name) || groupsWithSameName <= 0;
            }
            return true;
        }, ValidationMessage.warning((String)Localization.lang("There already exists a group with the same name.\nIf you use it, it will inherit all entries from this other group.", new Object[0])));
        this.keywordRegexValidator = new FunctionBasedValidator((ObservableValue)this.keywordGroupSearchTermProperty, input -> {
            if (!this.keywordGroupRegexProperty.getValue().booleanValue()) {
                return true;
            }
            if (StringUtil.isNullOrEmpty(input)) {
                return false;
            }
            try {
                Pattern.compile(input);
                return true;
            }
            catch (PatternSyntaxException ignored) {
                return false;
            }
        }, ValidationMessage.error((String)"%s > %n %s %n %n %s".formatted(Localization.lang("Searching for a keyword", new Object[0]), Localization.lang("Keywords", new Object[0]), Localization.lang("Invalid regular expression.", new Object[0]))));
        this.keywordFieldEmptyValidator = new FunctionBasedValidator((ObservableValue)this.keywordGroupSearchFieldProperty, StringUtil::isNotBlank, ValidationMessage.error((String)Localization.lang("Please enter a field name to search for a keyword.", new Object[0])));
        this.keywordSearchTermEmptyValidator = new FunctionBasedValidator((ObservableValue)this.keywordGroupSearchTermProperty, input -> !StringUtil.isNullOrEmpty(input), ValidationMessage.error((String)"%s > %n %s %n %n %s".formatted(Localization.lang("Searching for a keyword", new Object[0]), Localization.lang("Keywords", new Object[0]), Localization.lang("Search term is empty.", new Object[0]))));
        this.searchRegexValidator = new FunctionBasedValidator((ObservableValue)this.searchGroupSearchTermProperty, input -> {
            if (!((EnumSet)this.searchFlagsProperty.getValue()).contains((Object)SearchRules.SearchFlags.CASE_SENSITIVE)) {
                return true;
            }
            if (StringUtil.isNullOrEmpty(input)) {
                return false;
            }
            try {
                Pattern.compile(input);
                return true;
            }
            catch (PatternSyntaxException e) {
                return false;
            }
        }, ValidationMessage.error((String)"%s > %n %s".formatted(Localization.lang("Free search expression", new Object[0]), Localization.lang("Invalid regular expression.", new Object[0]))));
        this.searchSearchTermEmptyValidator = new FunctionBasedValidator((ObservableValue)this.searchGroupSearchTermProperty, input -> !StringUtil.isNullOrEmpty(input), ValidationMessage.error((String)"%s > %n %s".formatted(Localization.lang("Free search expression", new Object[0]), Localization.lang("Search term is empty.", new Object[0]))));
        this.texGroupFilePathValidator = new FunctionBasedValidator((ObservableValue)this.texGroupFilePathProperty, input -> {
            if (StringUtil.isBlank(input)) {
                return false;
            }
            Path inputPath = this.getAbsoluteTexGroupPath((String)input);
            if (!inputPath.isAbsolute() || !Files.isRegularFile(inputPath, new LinkOption[0])) {
                return false;
            }
            return FileUtil.getFileExtension(input).map(extension -> "aux".equalsIgnoreCase((String)extension)).orElse(false);
        }, ValidationMessage.error((String)Localization.lang("Please provide a valid aux file.", new Object[0])));
        this.typeSearchProperty.addListener((obs, _oldValue, isSelected) -> {
            if (isSelected.booleanValue()) {
                this.validator.addValidators(new Validator[]{this.searchRegexValidator, this.searchSearchTermEmptyValidator});
            } else {
                this.validator.removeValidators(new Validator[]{this.searchRegexValidator, this.searchSearchTermEmptyValidator});
            }
        });
        this.typeKeywordsProperty.addListener((obs, _oldValue, isSelected) -> {
            if (isSelected.booleanValue()) {
                this.validator.addValidators(new Validator[]{this.keywordFieldEmptyValidator, this.keywordRegexValidator, this.keywordSearchTermEmptyValidator});
            } else {
                this.validator.removeValidators(new Validator[]{this.keywordFieldEmptyValidator, this.keywordRegexValidator, this.keywordSearchTermEmptyValidator});
            }
        });
        this.typeTexProperty.addListener((obs, oldValue, isSelected) -> {
            if (isSelected.booleanValue()) {
                this.validator.addValidators(new Validator[]{this.texGroupFilePathValidator});
            } else {
                this.validator.removeValidators(new Validator[]{this.texGroupFilePathValidator});
            }
        });
        this.validator.addValidators(new Validator[]{this.nameValidator, this.nameContainsDelimiterValidator, this.sameNameValidator});
    }

    private Path getAbsoluteTexGroupPath(String input) {
        Optional<Path> latexFileDirectory = this.currentDatabase.getMetaData().getLatexFileDirectory(this.preferencesService.getFilePreferences().getUserAndHost());
        return latexFileDirectory.map(path -> path.resolve(input)).orElse(Path.of(input, new String[0]));
    }

    public void validationHandler(Event event) {
        ValidationStatus validationStatus = this.validator.getValidationStatus();
        if (validationStatus.getHighestMessage().isPresent()) {
            this.dialogService.showErrorDialogAndWait(((ValidationMessage)validationStatus.getHighestMessage().get()).getMessage());
            event.consume();
        }
    }

    public AbstractGroup resultConverter(ButtonType button) {
        if (button != ButtonType.OK) {
            return null;
        }
        AbstractGroup resultingGroup = null;
        try {
            String groupName = this.nameProperty.getValue().trim();
            if (this.typeExplicitProperty.getValue().booleanValue()) {
                resultingGroup = new ExplicitGroup(groupName, (GroupHierarchyType)((Object)this.groupHierarchySelectedProperty.getValue()), this.preferencesService.getBibEntryPreferences().getKeywordSeparator());
            } else if (this.typeKeywordsProperty.getValue().booleanValue()) {
                resultingGroup = this.keywordGroupRegexProperty.getValue().booleanValue() ? new RegexKeywordGroup(groupName, (GroupHierarchyType)((Object)this.groupHierarchySelectedProperty.getValue()), FieldFactory.parseField(this.keywordGroupSearchFieldProperty.getValue().trim()), this.keywordGroupSearchTermProperty.getValue().trim(), this.keywordGroupCaseSensitiveProperty.getValue()) : new WordKeywordGroup(groupName, (GroupHierarchyType)((Object)this.groupHierarchySelectedProperty.getValue()), FieldFactory.parseField(this.keywordGroupSearchFieldProperty.getValue().trim()), this.keywordGroupSearchTermProperty.getValue().trim(), this.keywordGroupCaseSensitiveProperty.getValue(), this.preferencesService.getBibEntryPreferences().getKeywordSeparator(), false);
            } else if (this.typeSearchProperty.getValue().booleanValue()) {
                resultingGroup = new SearchGroup(groupName, (GroupHierarchyType)((Object)this.groupHierarchySelectedProperty.getValue()), this.searchGroupSearchTermProperty.getValue().trim(), (EnumSet)this.searchFlagsProperty.getValue());
            } else if (this.typeAutoProperty.getValue().booleanValue()) {
                if (this.autoGroupKeywordsOptionProperty.getValue().booleanValue()) {
                    char delimiter = ',';
                    char hierarDelimiter = Keyword.DEFAULT_HIERARCHICAL_DELIMITER.charValue();
                    this.autoGroupKeywordsOptionProperty.setValue(Boolean.TRUE);
                    if (!this.autoGroupKeywordsDelimiterProperty.getValue().isEmpty()) {
                        delimiter = this.autoGroupKeywordsDelimiterProperty.getValue().charAt(0);
                    }
                    if (!this.autoGroupKeywordsHierarchicalDelimiterProperty.getValue().isEmpty()) {
                        hierarDelimiter = this.autoGroupKeywordsHierarchicalDelimiterProperty.getValue().charAt(0);
                    }
                    resultingGroup = new AutomaticKeywordGroup(groupName, (GroupHierarchyType)((Object)this.groupHierarchySelectedProperty.getValue()), FieldFactory.parseField(this.autoGroupKeywordsFieldProperty.getValue().trim()), Character.valueOf(delimiter), Character.valueOf(hierarDelimiter));
                } else {
                    resultingGroup = new AutomaticPersonsGroup(groupName, (GroupHierarchyType)((Object)this.groupHierarchySelectedProperty.getValue()), FieldFactory.parseField(this.autoGroupPersonsFieldProperty.getValue().trim()));
                }
            } else if (this.typeTexProperty.getValue().booleanValue()) {
                resultingGroup = TexGroup.create(groupName, (GroupHierarchyType)((Object)this.groupHierarchySelectedProperty.getValue()), Path.of(this.texGroupFilePathProperty.getValue().trim(), new String[0]), new DefaultAuxParser(new BibDatabase()), this.fileUpdateMonitor, this.currentDatabase.getMetaData());
            }
            if (resultingGroup != null) {
                this.preferencesService.getGroupsPreferences().setDefaultHierarchicalContext((GroupHierarchyType)((Object)this.groupHierarchySelectedProperty.getValue()));
                resultingGroup.setColor(this.colorUseProperty.getValue() != false ? (Color)this.colorProperty.getValue() : null);
                resultingGroup.setDescription(this.descriptionProperty.getValue());
                resultingGroup.setIconName(this.iconProperty.getValue());
                return resultingGroup;
            }
            return null;
        }
        catch (IOException | IllegalArgumentException exception) {
            this.dialogService.showErrorDialogAndWait(exception.getLocalizedMessage(), exception);
            return null;
        }
    }

    public void setValues() {
        this.groupHierarchyListProperty.setValue(FXCollections.observableArrayList((Object[])GroupHierarchyType.values()));
        if (this.editedGroup == null) {
            this.colorUseProperty.setValue(Boolean.valueOf(false));
            this.colorProperty.setValue((Object)this.determineColor());
            if (this.parentNode != null) {
                this.parentNode.getGroup().getIconName().filter(iconName -> !iconName.equals("ALL_ENTRIES_GROUP_ICON")).ifPresent(arg_0 -> ((StringProperty)this.iconProperty).setValue(arg_0));
                this.parentNode.getGroup().getColor().ifPresent(color -> this.colorUseProperty.setValue(Boolean.valueOf(true)));
            }
            this.typeExplicitProperty.setValue(Boolean.valueOf(true));
            this.groupHierarchySelectedProperty.setValue((Object)this.preferencesService.getGroupsPreferences().getDefaultHierarchicalContext());
            this.autoGroupKeywordsOptionProperty.setValue(Boolean.TRUE);
        } else {
            this.nameProperty.setValue(this.editedGroup.getName());
            this.colorUseProperty.setValue(Boolean.valueOf(this.editedGroup.getColor().isPresent()));
            this.colorProperty.setValue((Object)this.editedGroup.getColor().orElse(IconTheme.getDefaultGroupColor()));
            this.descriptionProperty.setValue(this.editedGroup.getDescription().orElse(""));
            this.iconProperty.setValue(this.editedGroup.getIconName().orElse(""));
            this.groupHierarchySelectedProperty.setValue((Object)this.editedGroup.getHierarchicalContext());
            if (this.editedGroup.getClass() == WordKeywordGroup.class) {
                this.typeKeywordsProperty.setValue(Boolean.valueOf(true));
                WordKeywordGroup group = (WordKeywordGroup)this.editedGroup;
                this.keywordGroupSearchFieldProperty.setValue(group.getSearchField().getName());
                this.keywordGroupSearchTermProperty.setValue(group.getSearchExpression());
                this.keywordGroupCaseSensitiveProperty.setValue(Boolean.valueOf(group.isCaseSensitive()));
                this.keywordGroupRegexProperty.setValue(Boolean.valueOf(false));
            } else if (this.editedGroup.getClass() == RegexKeywordGroup.class) {
                this.typeKeywordsProperty.setValue(Boolean.valueOf(true));
                RegexKeywordGroup group = (RegexKeywordGroup)this.editedGroup;
                this.keywordGroupSearchFieldProperty.setValue(group.getSearchField().getName());
                this.keywordGroupSearchTermProperty.setValue(group.getSearchExpression());
                this.keywordGroupCaseSensitiveProperty.setValue(Boolean.valueOf(group.isCaseSensitive()));
                this.keywordGroupRegexProperty.setValue(Boolean.valueOf(true));
            } else if (this.editedGroup.getClass() == SearchGroup.class) {
                this.typeSearchProperty.setValue(Boolean.valueOf(true));
                SearchGroup group = (SearchGroup)this.editedGroup;
                this.searchGroupSearchTermProperty.setValue(group.getSearchExpression());
                this.searchFlagsProperty.setValue(group.getSearchFlags());
            } else if (this.editedGroup.getClass() == ExplicitGroup.class) {
                this.typeExplicitProperty.setValue(Boolean.valueOf(true));
            } else if (this.editedGroup instanceof AutomaticGroup) {
                this.typeAutoProperty.setValue(Boolean.valueOf(true));
                if (this.editedGroup.getClass() == AutomaticKeywordGroup.class) {
                    AutomaticKeywordGroup group = (AutomaticKeywordGroup)this.editedGroup;
                    this.autoGroupKeywordsOptionProperty.setValue(Boolean.TRUE);
                    this.autoGroupKeywordsDelimiterProperty.setValue(group.getKeywordDelimiter().toString());
                    this.autoGroupKeywordsHierarchicalDelimiterProperty.setValue(group.getKeywordHierarchicalDelimiter().toString());
                    this.autoGroupKeywordsFieldProperty.setValue(group.getField().getName());
                } else if (this.editedGroup.getClass() == AutomaticPersonsGroup.class) {
                    AutomaticPersonsGroup group = (AutomaticPersonsGroup)this.editedGroup;
                    this.autoGroupPersonsOptionProperty.setValue(Boolean.TRUE);
                    this.autoGroupPersonsFieldProperty.setValue(group.getField().getName());
                }
            } else if (this.editedGroup.getClass() == TexGroup.class) {
                this.typeTexProperty.setValue(Boolean.valueOf(true));
                TexGroup group = (TexGroup)this.editedGroup;
                this.texGroupFilePathProperty.setValue(group.getFilePath().toString());
            }
        }
    }

    private Color determineColor() {
        Color color;
        if (this.parentNode == null) {
            color = GroupColorPicker.generateColor(List.of());
        } else {
            List colorsOfSiblings = this.parentNode.getChildren().stream().map(child -> child.getGroup().getColor()).flatMap(Optional::stream).toList();
            Optional<Color> parentColor = this.parentNode.getGroup().getColor();
            color = parentColor.map(value -> GroupColorPicker.generateColor(colorsOfSiblings, value)).orElseGet(() -> GroupColorPicker.generateColor(colorsOfSiblings));
        }
        return color;
    }

    public void texGroupBrowse() {
        FileDialogConfiguration fileDialogConfiguration = new FileDialogConfiguration.Builder().addExtensionFilter(StandardFileType.AUX).withDefaultExtension(StandardFileType.AUX).withInitialDirectory(this.currentDatabase.getMetaData().getLatexFileDirectory(this.preferencesService.getFilePreferences().getUserAndHost()).orElse(FileUtil.getInitialDirectory(this.currentDatabase, this.preferencesService.getFilePreferences().getWorkingDirectory()))).build();
        this.dialogService.showFileOpenDialog(fileDialogConfiguration).ifPresent(file -> this.texGroupFilePathProperty.setValue(FileUtil.relativize(file.toAbsolutePath(), this.getFileDirectoriesAsPaths()).toString()));
    }

    private List<Path> getFileDirectoriesAsPaths() {
        ArrayList<Path> fileDirs = new ArrayList<Path>();
        MetaData metaData = this.currentDatabase.getMetaData();
        metaData.getLatexFileDirectory(this.preferencesService.getFilePreferences().getUserAndHost()).ifPresent(fileDirs::add);
        return fileDirs;
    }

    public ValidationStatus validationStatus() {
        return this.validator.getValidationStatus();
    }

    public ValidationStatus nameValidationStatus() {
        return this.nameValidator.getValidationStatus();
    }

    public ValidationStatus nameContainsDelimiterValidationStatus() {
        return this.nameContainsDelimiterValidator.getValidationStatus();
    }

    public ValidationStatus sameNameValidationStatus() {
        return this.sameNameValidator.getValidationStatus();
    }

    public ValidationStatus searchRegexValidationStatus() {
        return this.searchRegexValidator.getValidationStatus();
    }

    public ValidationStatus searchSearchTermEmptyValidationStatus() {
        return this.searchSearchTermEmptyValidator.getValidationStatus();
    }

    public ValidationStatus keywordRegexValidationStatus() {
        return this.keywordRegexValidator.getValidationStatus();
    }

    public ValidationStatus keywordFieldEmptyValidationStatus() {
        return this.keywordFieldEmptyValidator.getValidationStatus();
    }

    public ValidationStatus keywordSearchTermEmptyValidationStatus() {
        return this.keywordSearchTermEmptyValidator.getValidationStatus();
    }

    public ValidationStatus texGroupFilePathValidatonStatus() {
        return this.texGroupFilePathValidator.getValidationStatus();
    }

    public StringProperty nameProperty() {
        return this.nameProperty;
    }

    public StringProperty descriptionProperty() {
        return this.descriptionProperty;
    }

    public StringProperty iconProperty() {
        return this.iconProperty;
    }

    public BooleanProperty colorUseProperty() {
        return this.colorUseProperty;
    }

    public ObjectProperty<Color> colorFieldProperty() {
        return this.colorProperty;
    }

    public ListProperty<GroupHierarchyType> groupHierarchyListProperty() {
        return this.groupHierarchyListProperty;
    }

    public ObjectProperty<GroupHierarchyType> groupHierarchySelectedProperty() {
        return this.groupHierarchySelectedProperty;
    }

    public BooleanProperty typeExplicitProperty() {
        return this.typeExplicitProperty;
    }

    public BooleanProperty typeKeywordsProperty() {
        return this.typeKeywordsProperty;
    }

    public BooleanProperty typeSearchProperty() {
        return this.typeSearchProperty;
    }

    public BooleanProperty typeAutoProperty() {
        return this.typeAutoProperty;
    }

    public BooleanProperty typeTexProperty() {
        return this.typeTexProperty;
    }

    public StringProperty keywordGroupSearchTermProperty() {
        return this.keywordGroupSearchTermProperty;
    }

    public StringProperty keywordGroupSearchFieldProperty() {
        return this.keywordGroupSearchFieldProperty;
    }

    public BooleanProperty keywordGroupCaseSensitiveProperty() {
        return this.keywordGroupCaseSensitiveProperty;
    }

    public BooleanProperty keywordGroupRegexProperty() {
        return this.keywordGroupRegexProperty;
    }

    public StringProperty searchGroupSearchTermProperty() {
        return this.searchGroupSearchTermProperty;
    }

    public ObjectProperty<EnumSet<SearchRules.SearchFlags>> searchFlagsProperty() {
        return this.searchFlagsProperty;
    }

    public BooleanProperty autoGroupKeywordsOptionProperty() {
        return this.autoGroupKeywordsOptionProperty;
    }

    public StringProperty autoGroupKeywordsFieldProperty() {
        return this.autoGroupKeywordsFieldProperty;
    }

    public StringProperty autoGroupKeywordsDeliminatorProperty() {
        return this.autoGroupKeywordsDelimiterProperty;
    }

    public StringProperty autoGroupKeywordsHierarchicalDeliminatorProperty() {
        return this.autoGroupKeywordsHierarchicalDelimiterProperty;
    }

    public BooleanProperty autoGroupPersonsOptionProperty() {
        return this.autoGroupPersonsOptionProperty;
    }

    public StringProperty autoGroupPersonsFieldProperty() {
        return this.autoGroupPersonsFieldProperty;
    }

    public StringProperty texGroupFilePathProperty() {
        return this.texGroupFilePathProperty;
    }
}

