/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.groups;

import java.util.List;
import javafx.scene.paint.Color;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class GroupColorPicker {
    public static Color generateColor(List<Color> siblingColors) {
        return GroupColorPicker.generateColor(siblingColors, null);
    }

    public static Color generateColor(List<Color> siblingColors, @Nullable Color parentColor) {
        if (siblingColors.isEmpty()) {
            if (parentColor == null) {
                return Color.hsb((double)(Math.random() * 360.0), (double)0.5, (double)0.75);
            }
            return GroupColorPicker.generateSubGroupColor(parentColor);
        }
        double sumSin = 0.0;
        double sumCos = 0.0;
        for (Color color : siblingColors) {
            double hue = color.getHue();
            sumSin += Math.sin(Math.toRadians(hue));
            sumCos += Math.cos(Math.toRadians(hue));
        }
        double meanAngle = Math.toDegrees(Math.atan2(sumSin, sumCos));
        meanAngle = (meanAngle + 360.0) % 360.0;
        double newHue = (meanAngle + 180.0) % 360.0;
        double sumSaturation = 0.0;
        double sumBrightness = 0.0;
        for (Color color : siblingColors) {
            sumSaturation += color.getSaturation();
            sumBrightness += color.getBrightness();
        }
        double averageSaturation = sumSaturation / (double)siblingColors.size();
        double averageBrightness = sumBrightness / (double)siblingColors.size();
        return Color.hsb((double)newHue, (double)averageSaturation, (double)averageBrightness);
    }

    private static Color generateSubGroupColor(Color baseColor) {
        return baseColor.deriveColor(0.0, 1.0, 0.9, 1.0);
    }
}

