/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.fieldeditors.identifier;

import com.tobiasdiez.easybind.EasyBind;
import javafx.beans.value.ObservableValue;
import javafx.collections.MapChangeListener;
import javafx.collections.WeakMapChangeListener;
import javax.swing.undo.UndoManager;
import org.jabref.gui.DialogService;
import org.jabref.gui.autocompleter.SuggestionProvider;
import org.jabref.gui.fieldeditors.identifier.BaseIdentifierEditorViewModel;
import org.jabref.gui.util.TaskExecutor;
import org.jabref.logic.integrity.FieldCheckers;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.field.Field;
import org.jabref.model.entry.field.StandardField;
import org.jabref.model.entry.identifier.ARK;
import org.jabref.model.entry.identifier.ArXivIdentifier;
import org.jabref.model.entry.identifier.EprintIdentifier;
import org.jabref.preferences.PreferencesService;

public class EprintIdentifierEditorViewModel
extends BaseIdentifierEditorViewModel<EprintIdentifier> {
    private MapChangeListener<Field, String> eprintTypeFieldListener = change -> {
        Field changedField = (Field)change.getKey();
        if (StandardField.EPRINTTYPE == changedField) {
            this.updateIdentifier();
        }
    };

    public EprintIdentifierEditorViewModel(SuggestionProvider<?> suggestionProvider, FieldCheckers fieldCheckers, DialogService dialogService, TaskExecutor taskExecutor, PreferencesService preferences, UndoManager undoManager) {
        super(StandardField.EPRINT, suggestionProvider, fieldCheckers, dialogService, taskExecutor, preferences, undoManager);
        this.configure(false, false);
        EasyBind.subscribe((ObservableValue)this.identifier, newIdentifier -> newIdentifier.ifPresent(id -> {
            if (id instanceof ArXivIdentifier) {
                this.configure(true, false);
            } else if (id instanceof ARK) {
                this.configure(false, false);
            }
        }));
    }

    @Override
    public void bindToEntry(BibEntry entry) {
        super.bindToEntry(entry);
        entry.getFieldsObservable().addListener((MapChangeListener)new WeakMapChangeListener(this.eprintTypeFieldListener));
    }
}

