/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.fieldeditors.identifier;

import com.tobiasdiez.easybind.EasyBind;
import java.io.IOException;
import java.util.Optional;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javax.swing.undo.UndoManager;
import org.jabref.gui.DialogService;
import org.jabref.gui.autocompleter.SuggestionProvider;
import org.jabref.gui.desktop.JabRefDesktop;
import org.jabref.gui.fieldeditors.AbstractEditorViewModel;
import org.jabref.gui.util.TaskExecutor;
import org.jabref.logic.importer.FetcherClientException;
import org.jabref.logic.importer.FetcherServerException;
import org.jabref.logic.importer.IdFetcher;
import org.jabref.logic.importer.util.IdentifierParser;
import org.jabref.logic.integrity.FieldCheckers;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.field.Field;
import org.jabref.model.entry.identifier.Identifier;
import org.jabref.preferences.PreferencesService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseIdentifierEditorViewModel<T extends Identifier>
extends AbstractEditorViewModel {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseIdentifierEditorViewModel.class);
    protected BooleanProperty isInvalidIdentifier = new SimpleBooleanProperty();
    protected final BooleanProperty identifierLookupInProgress = new SimpleBooleanProperty(false);
    protected final BooleanProperty canLookupIdentifier = new SimpleBooleanProperty(true);
    protected final BooleanProperty canFetchBibliographyInformationById = new SimpleBooleanProperty();
    protected IdentifierParser identifierParser;
    protected final ObjectProperty<Optional<T>> identifier = new SimpleObjectProperty(Optional.empty());
    protected DialogService dialogService;
    protected TaskExecutor taskExecutor;
    protected PreferencesService preferences;

    public BaseIdentifierEditorViewModel(Field field, SuggestionProvider<?> suggestionProvider, FieldCheckers fieldCheckers, DialogService dialogService, TaskExecutor taskExecutor, PreferencesService preferences, UndoManager undoManager) {
        super(field, suggestionProvider, fieldCheckers, undoManager);
        this.dialogService = dialogService;
        this.taskExecutor = taskExecutor;
        this.preferences = preferences;
    }

    protected final void configure(boolean canFetchBibliographyInformationById, boolean canLookupIdentifier) {
        this.canLookupIdentifier.set(canLookupIdentifier);
        this.canFetchBibliographyInformationById.set(canFetchBibliographyInformationById);
    }

    protected Optional<T> updateIdentifier() {
        if (this.identifierParser == null) {
            return Optional.empty();
        }
        this.identifier.set(this.identifierParser.parse(this.field));
        return (Optional)this.identifier.get();
    }

    protected void handleIdentifierFetchingError(Exception exception, IdFetcher<T> fetcher) {
        LOGGER.error("Error while fetching identifier", (Throwable)exception);
        if (exception instanceof FetcherClientException) {
            this.dialogService.showInformationDialogAndWait(Localization.lang("Look up %0", fetcher.getName()), Localization.lang("No data was found for the identifier", new Object[0]));
        } else if (exception instanceof FetcherServerException) {
            this.dialogService.showInformationDialogAndWait(Localization.lang("Look up %0", fetcher.getName()), Localization.lang("Server not available", new Object[0]));
        } else if (exception.getCause() != null) {
            this.dialogService.showWarningDialogAndWait(Localization.lang("Look up %0", fetcher.getName()), Localization.lang("Error occurred %0", exception.getCause().getMessage()));
        } else {
            this.dialogService.showWarningDialogAndWait(Localization.lang("Look up %0", fetcher.getName()), Localization.lang("Error occurred %0", exception.getCause().getMessage()));
        }
    }

    public BooleanProperty canFetchBibliographyInformationByIdProperty() {
        return this.canFetchBibliographyInformationById;
    }

    public boolean getCanFetchBibliographyInformationById() {
        return this.canFetchBibliographyInformationById.get();
    }

    public BooleanProperty canLookupIdentifierProperty() {
        return this.canLookupIdentifier;
    }

    public boolean getCanLookupIdentifier() {
        return this.canLookupIdentifier.get();
    }

    public BooleanProperty isInvalidIdentifierProperty() {
        return this.isInvalidIdentifier;
    }

    public boolean getIsInvalidIdentifier() {
        return this.isInvalidIdentifier.get();
    }

    public boolean getIdentifierLookupInProgress() {
        return this.identifierLookupInProgress.get();
    }

    public BooleanProperty identifierLookupInProgressProperty() {
        return this.identifierLookupInProgress;
    }

    public void fetchBibliographyInformation(BibEntry bibEntry) {
        LOGGER.warn("Unable to fetch bibliography information using the '{}' identifier", (Object)this.field.getDisplayName());
    }

    public void lookupIdentifier(BibEntry bibEntry) {
        LOGGER.warn("Unable to lookup identifier for '{}'", (Object)this.field.getDisplayName());
    }

    public void openExternalLink() {
        ((Optional)this.identifier.get()).flatMap(Identifier::getExternalURI).ifPresent(url -> {
            try {
                JabRefDesktop.openBrowser(url, this.preferences.getFilePreferences());
            }
            catch (IOException ex) {
                this.dialogService.showErrorDialogAndWait(Localization.lang("Unable to open link.", new Object[0]), ex);
            }
        });
    }

    @Override
    public void bindToEntry(BibEntry entry) {
        super.bindToEntry(entry);
        this.identifierParser = new IdentifierParser(entry);
        EasyBind.subscribe((ObservableValue)this.textProperty(), ignored -> this.updateIdentifier());
        EasyBind.subscribe(this.identifier, newIdentifier -> this.isInvalidIdentifier.set(newIdentifier.isEmpty()));
    }
}

