/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.fieldeditors.contextmenu;

import com.sun.javafx.scene.control.Properties;
import de.saxsys.mvvmfx.utils.commands.Command;
import java.util.List;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.MenuItem;
import javafx.scene.control.PasswordField;
import javafx.scene.control.TextInputControl;
import javafx.scene.input.Clipboard;
import org.jabref.gui.actions.ActionFactory;
import org.jabref.gui.actions.SimpleCommand;
import org.jabref.gui.actions.StandardActions;
import org.jabref.gui.util.BindingsHelper;
import org.jabref.logic.util.OS;

public class EditorContextAction
extends SimpleCommand {
    private static final boolean SHOW_HANDLES = Properties.IS_TOUCH_SUPPORTED && !OS.OS_X;
    private final StandardActions command;
    private final TextInputControl textInputControl;

    public EditorContextAction(StandardActions command, TextInputControl textInputControl) {
        this.command = command;
        this.textInputControl = textInputControl;
        BooleanProperty editableBinding = textInputControl.editableProperty();
        BooleanBinding hasTextBinding = Bindings.createBooleanBinding(() -> textInputControl.getLength() > 0, (Observable[])new Observable[]{textInputControl.textProperty()});
        BooleanBinding hasStringInClipboardBinding = (BooleanBinding)BindingsHelper.constantOf(Clipboard.getSystemClipboard().hasString());
        BooleanBinding hasSelectionBinding = Bindings.createBooleanBinding(() -> textInputControl.getSelection().getLength() > 0, (Observable[])new Observable[]{textInputControl.selectionProperty()});
        BooleanBinding allSelectedBinding = Bindings.createBooleanBinding(() -> textInputControl.getSelection().getLength() == textInputControl.getLength(), (Observable[])new Observable[0]);
        BooleanBinding maskTextBinding = (BooleanBinding)BindingsHelper.constantOf(textInputControl instanceof PasswordField);
        this.executable.bind((ObservableValue)(switch (command) {
            case StandardActions.COPY -> editableBinding.and((ObservableBooleanValue)maskTextBinding.not()).and((ObservableBooleanValue)hasSelectionBinding);
            case StandardActions.CUT -> maskTextBinding.not().and((ObservableBooleanValue)hasSelectionBinding);
            case StandardActions.PASTE -> editableBinding.and((ObservableBooleanValue)hasStringInClipboardBinding);
            case StandardActions.DELETE -> editableBinding.and((ObservableBooleanValue)hasSelectionBinding);
            case StandardActions.SELECT_ALL -> {
                if (SHOW_HANDLES) {
                    yield hasTextBinding.and((ObservableBooleanValue)allSelectedBinding.not());
                }
                yield BindingsHelper.constantOf(true);
            }
            default -> BindingsHelper.constantOf(true);
        }));
    }

    public void execute() {
        switch (this.command) {
            case COPY: {
                this.textInputControl.copy();
                break;
            }
            case CUT: {
                this.textInputControl.cut();
                break;
            }
            case PASTE: {
                this.textInputControl.paste();
                break;
            }
            case DELETE: {
                this.textInputControl.deleteText(this.textInputControl.getSelection());
                break;
            }
            case SELECT_ALL: {
                this.textInputControl.selectAll();
            }
        }
        this.textInputControl.requestFocus();
    }

    public static List<MenuItem> getDefaultContextMenuItems(TextInputControl textInputControl) {
        ActionFactory factory = new ActionFactory();
        MenuItem selectAllMenuItem = factory.createMenuItem(StandardActions.SELECT_ALL, (Command)new EditorContextAction(StandardActions.SELECT_ALL, textInputControl));
        if (SHOW_HANDLES) {
            selectAllMenuItem.getProperties().put((Object)"refreshMenu", (Object)Boolean.TRUE);
        }
        return List.of(factory.createMenuItem(StandardActions.CUT, (Command)new EditorContextAction(StandardActions.CUT, textInputControl)), factory.createMenuItem(StandardActions.COPY, (Command)new EditorContextAction(StandardActions.COPY, textInputControl)), factory.createMenuItem(StandardActions.PASTE, (Command)new EditorContextAction(StandardActions.PASTE, textInputControl)), factory.createMenuItem(StandardActions.DELETE, (Command)new EditorContextAction(StandardActions.DELETE, textInputControl)), selectAllMenuItem);
    }
}

