/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.fieldeditors.contextmenu;

import com.tobiasdiez.easybind.EasyBind;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.TextInputControl;
import org.jabref.gui.fieldeditors.contextmenu.ProtectedTermsMenu;
import org.jabref.logic.cleanup.Formatter;
import org.jabref.logic.formatter.Formatters;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.strings.StringUtil;

public class DefaultMenu
implements Supplier<List<MenuItem>> {
    TextInputControl textInputControl;

    public DefaultMenu(TextInputControl textInputControl) {
        this.textInputControl = textInputControl;
    }

    @Override
    public List<MenuItem> get() {
        return List.of(DefaultMenu.getCaseChangeMenu(this.textInputControl), DefaultMenu.getConversionMenu(this.textInputControl), new SeparatorMenuItem(), new ProtectedTermsMenu(this.textInputControl), new SeparatorMenuItem(), DefaultMenu.getClearFieldMenuItem(this.textInputControl));
    }

    private static Menu getCaseChangeMenu(TextInputControl textInputControl) {
        Objects.requireNonNull(textInputControl.textProperty());
        Menu submenu = new Menu(Localization.lang("Change case", new Object[0]));
        for (Formatter caseChanger : Formatters.getCaseChangers()) {
            MenuItem menuItem = new MenuItem(caseChanger.getName());
            EasyBind.subscribe((ObservableValue)textInputControl.textProperty(), value -> menuItem.setDisable(StringUtil.isNullOrEmpty(value)));
            menuItem.setOnAction(event -> textInputControl.textProperty().set((Object)caseChanger.format((String)textInputControl.textProperty().get())));
            submenu.getItems().add((Object)menuItem);
        }
        return submenu;
    }

    private static Menu getConversionMenu(TextInputControl textInputControl) {
        Menu submenu = new Menu(Localization.lang("Convert", new Object[0]));
        for (Formatter converter : Formatters.getConverters()) {
            MenuItem menuItem = new MenuItem(converter.getName());
            EasyBind.subscribe((ObservableValue)textInputControl.textProperty(), value -> menuItem.setDisable(StringUtil.isNullOrEmpty(value)));
            menuItem.setOnAction(event -> textInputControl.textProperty().set((Object)converter.format((String)textInputControl.textProperty().get())));
            submenu.getItems().add((Object)menuItem);
        }
        return submenu;
    }

    private static MenuItem getClearFieldMenuItem(TextInputControl textInputControl) {
        MenuItem menuItem = new MenuItem(Localization.lang("Clear", new Object[0]));
        menuItem.setOnAction(event -> textInputControl.setText(""));
        return menuItem;
    }
}

