/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.fieldeditors;

import java.util.List;
import java.util.stream.Collectors;
import javafx.beans.property.ListProperty;
import javafx.beans.property.SimpleListProperty;
import javafx.collections.FXCollections;
import javafx.util.StringConverter;
import javax.swing.undo.UndoManager;
import org.jabref.gui.autocompleter.SuggestionProvider;
import org.jabref.gui.fieldeditors.AbstractEditorViewModel;
import org.jabref.gui.util.BindingsHelper;
import org.jabref.logic.integrity.FieldCheckers;
import org.jabref.model.entry.Keyword;
import org.jabref.model.entry.KeywordList;
import org.jabref.model.entry.field.Field;
import org.jabref.preferences.PreferencesService;
import org.tinylog.Logger;

public class KeywordsEditorViewModel
extends AbstractEditorViewModel {
    private final ListProperty<Keyword> keywordListProperty = new SimpleListProperty(FXCollections.observableArrayList());
    private final Character keywordSeparator;
    private final SuggestionProvider<?> suggestionProvider;

    public KeywordsEditorViewModel(Field field, SuggestionProvider<?> suggestionProvider, FieldCheckers fieldCheckers, PreferencesService preferencesService, UndoManager undoManager) {
        super(field, suggestionProvider, fieldCheckers, undoManager);
        this.keywordSeparator = preferencesService.getBibEntryPreferences().getKeywordSeparator();
        this.suggestionProvider = suggestionProvider;
        BindingsHelper.bindContentBidirectional(this.keywordListProperty, this.text, this::serializeKeywords, this::parseKeywords);
    }

    private String serializeKeywords(List<Keyword> keywords) {
        return KeywordList.serialize(keywords, this.keywordSeparator);
    }

    private List<Keyword> parseKeywords(String newText) {
        return KeywordList.parse(newText, this.keywordSeparator).stream().toList();
    }

    public ListProperty<Keyword> keywordListProperty() {
        return this.keywordListProperty;
    }

    public StringConverter<Keyword> getStringConverter() {
        return new StringConverter<Keyword>(this){

            public String toString(Keyword keyword) {
                if (keyword == null) {
                    Logger.debug((Object)"Keyword is null");
                    return "";
                }
                return keyword.get();
            }

            public Keyword fromString(String keywordString) {
                return new Keyword(keywordString);
            }
        };
    }

    public List<Keyword> getSuggestions(String request) {
        Keyword requestedKeyword;
        List<Keyword> suggestions = this.suggestionProvider.getPossibleSuggestions().stream().map(String.class::cast).filter(keyword -> keyword.toLowerCase().contains(request.toLowerCase())).map(Keyword::new).distinct().collect(Collectors.toList());
        if (!suggestions.contains(requestedKeyword = new Keyword(request))) {
            suggestions.addFirst(requestedKeyword);
        }
        return suggestions;
    }

    public Character getKeywordSeparator() {
        return this.keywordSeparator;
    }
}

