/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.fieldeditors;

import java.util.List;
import java.util.Optional;
import javafx.scene.input.TransferMode;
import javax.swing.undo.UndoManager;
import org.jabref.gui.DragAndDropDataFormats;
import org.jabref.gui.autocompleter.SuggestionProvider;
import org.jabref.gui.fieldeditors.SimpleEditor;
import org.jabref.gui.undo.RedoAction;
import org.jabref.gui.undo.UndoAction;
import org.jabref.logic.integrity.FieldCheckers;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.field.Field;
import org.jabref.model.entry.field.StandardField;
import org.jabref.preferences.PreferencesService;

public class GroupEditor
extends SimpleEditor {
    private Optional<BibEntry> bibEntry;

    public GroupEditor(Field field, SuggestionProvider<?> suggestionProvider, FieldCheckers fieldCheckers, PreferencesService preferences, boolean isMultiLine, UndoManager undoManager, UndoAction undoAction, RedoAction redoAction) {
        super(field, suggestionProvider, fieldCheckers, preferences, isMultiLine, undoManager, undoAction, redoAction);
        this.setOnDragOver(event -> {
            if (event.getDragboard().hasContent(DragAndDropDataFormats.GROUP)) {
                event.acceptTransferModes(new TransferMode[]{TransferMode.MOVE});
            }
            event.consume();
        });
        this.setOnDragDropped(event -> {
            boolean success = false;
            if (event.getDragboard().hasContent(DragAndDropDataFormats.GROUP)) {
                List draggedGroups = (List)event.getDragboard().getContent(DragAndDropDataFormats.GROUP);
                if (this.bibEntry.isPresent() && draggedGroups.getFirst() != null) {
                    String newGroup = this.bibEntry.map(entry -> entry.getField(StandardField.GROUPS).map(oldGroups -> oldGroups + preferences.getBibEntryPreferences().getKeywordSeparator() + (String)draggedGroups.getFirst()).orElse((String)draggedGroups.getFirst())).orElse(null);
                    this.bibEntry.map(entry -> entry.setField(StandardField.GROUPS, newGroup));
                    success = true;
                }
            }
            event.setDropCompleted(success);
            event.consume();
        });
    }

    @Override
    public void bindToEntry(BibEntry entry) {
        super.bindToEntry(entry);
        this.bibEntry = Optional.of(entry);
    }
}

