/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.fieldeditors;

import com.airhacks.afterburner.views.ViewLoader;
import jakarta.inject.Inject;
import java.util.Collections;
import javafx.fxml.FXML;
import javafx.scene.Parent;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBase;
import javafx.scene.control.TextInputControl;
import javafx.scene.layout.HBox;
import javax.swing.undo.UndoManager;
import org.jabref.gui.DialogService;
import org.jabref.gui.actions.ActionFactory;
import org.jabref.gui.actions.StandardActions;
import org.jabref.gui.autocompleter.SuggestionProvider;
import org.jabref.gui.fieldeditors.CitationKeyEditorViewModel;
import org.jabref.gui.fieldeditors.EditorTextField;
import org.jabref.gui.fieldeditors.EditorValidator;
import org.jabref.gui.fieldeditors.FieldEditorFX;
import org.jabref.gui.keyboard.KeyBindingRepository;
import org.jabref.gui.undo.RedoAction;
import org.jabref.gui.undo.UndoAction;
import org.jabref.logic.integrity.FieldCheckers;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.field.Field;
import org.jabref.preferences.PreferencesService;

public class CitationKeyEditor
extends HBox
implements FieldEditorFX {
    @FXML
    private final CitationKeyEditorViewModel viewModel;
    @FXML
    private Button generateCitationKeyButton;
    @FXML
    private EditorTextField textField;
    @Inject
    private PreferencesService preferencesService;
    @Inject
    private KeyBindingRepository keyBindingRepository;
    @Inject
    private DialogService dialogService;
    @Inject
    private UndoManager undoManager;

    public CitationKeyEditor(Field field, SuggestionProvider<?> suggestionProvider, FieldCheckers fieldCheckers, BibDatabaseContext databaseContext, UndoAction undoAction, RedoAction redoAction) {
        ViewLoader.view((Object)this).root((Object)this).load();
        this.viewModel = new CitationKeyEditorViewModel(field, suggestionProvider, fieldCheckers, this.preferencesService, databaseContext, this.undoManager, this.dialogService);
        this.establishBinding((TextInputControl)this.textField, this.viewModel.textProperty(), this.keyBindingRepository, undoAction, redoAction);
        this.textField.initContextMenu(Collections::emptyList, this.keyBindingRepository);
        new EditorValidator(this.preferencesService).configureValidation(this.viewModel.getFieldValidator().getValidationStatus(), (TextInputControl)this.textField);
    }

    public CitationKeyEditorViewModel getViewModel() {
        return this.viewModel;
    }

    @Override
    public void bindToEntry(BibEntry entry) {
        this.viewModel.bindToEntry(entry);
        new ActionFactory().configureIconButton(StandardActions.GENERATE_CITE_KEY, this.viewModel.getGenerateCiteKeyCommand(), (ButtonBase)this.generateCitationKeyButton);
    }

    @Override
    public Parent getNode() {
        return this;
    }
}

