/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.externalfiles;

import de.saxsys.mvvmfx.utils.validation.FunctionBasedValidator;
import de.saxsys.mvvmfx.utils.validation.ValidationMessage;
import de.saxsys.mvvmfx.utils.validation.ValidationStatus;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleListProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.control.TreeItem;
import javax.swing.undo.UndoManager;
import org.jabref.gui.DialogService;
import org.jabref.gui.StateManager;
import org.jabref.gui.externalfiles.DateRange;
import org.jabref.gui.externalfiles.ExternalFileSorter;
import org.jabref.gui.externalfiles.FileExtensionViewModel;
import org.jabref.gui.externalfiles.ImportFilesResultItemViewModel;
import org.jabref.gui.externalfiles.ImportHandler;
import org.jabref.gui.externalfiles.UnlinkedFilesCrawler;
import org.jabref.gui.util.BackgroundTask;
import org.jabref.gui.util.DirectoryDialogConfiguration;
import org.jabref.gui.util.FileDialogConfiguration;
import org.jabref.gui.util.FileNodeViewModel;
import org.jabref.gui.util.TaskExecutor;
import org.jabref.logic.l10n.Localization;
import org.jabref.logic.util.StandardFileType;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.util.FileUpdateMonitor;
import org.jabref.preferences.PreferencesService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnlinkedFilesDialogViewModel {
    private static final Logger LOGGER = LoggerFactory.getLogger(UnlinkedFilesDialogViewModel.class);
    private final ImportHandler importHandler;
    private final StringProperty directoryPath = new SimpleStringProperty("");
    private final ObjectProperty<FileExtensionViewModel> selectedExtension = new SimpleObjectProperty();
    private final ObjectProperty<DateRange> selectedDate = new SimpleObjectProperty();
    private final ObjectProperty<ExternalFileSorter> selectedSort = new SimpleObjectProperty();
    private final ObjectProperty<Optional<FileNodeViewModel>> treeRootProperty = new SimpleObjectProperty();
    private final SimpleListProperty<TreeItem<FileNodeViewModel>> checkedFileListProperty = new SimpleListProperty(FXCollections.observableArrayList());
    private final BooleanProperty taskActiveProperty = new SimpleBooleanProperty(false);
    private final DoubleProperty progressValueProperty = new SimpleDoubleProperty(0.0);
    private final StringProperty progressTextProperty = new SimpleStringProperty();
    private final ObservableList<ImportFilesResultItemViewModel> resultList = FXCollections.observableArrayList();
    private final ObservableList<FileExtensionViewModel> fileFilterList;
    private final ObservableList<DateRange> dateFilterList;
    private final ObservableList<ExternalFileSorter> fileSortList;
    private final DialogService dialogService;
    private final PreferencesService preferences;
    private BackgroundTask<FileNodeViewModel> findUnlinkedFilesTask;
    private BackgroundTask<List<ImportFilesResultItemViewModel>> importFilesBackgroundTask;
    private final BibDatabaseContext bibDatabase;
    private final TaskExecutor taskExecutor;
    private final FunctionBasedValidator<String> scanDirectoryValidator;

    public UnlinkedFilesDialogViewModel(DialogService dialogService, UndoManager undoManager, FileUpdateMonitor fileUpdateMonitor, PreferencesService preferences, StateManager stateManager, TaskExecutor taskExecutor) {
        this.preferences = preferences;
        this.dialogService = dialogService;
        this.taskExecutor = taskExecutor;
        this.bibDatabase = stateManager.getActiveDatabase().orElseThrow(() -> new NullPointerException("Database null"));
        this.importHandler = new ImportHandler(this.bibDatabase, preferences, fileUpdateMonitor, undoManager, stateManager, dialogService, taskExecutor);
        this.fileFilterList = FXCollections.observableArrayList((Object[])new FileExtensionViewModel[]{new FileExtensionViewModel(StandardFileType.ANY_FILE, preferences.getFilePreferences()), new FileExtensionViewModel(StandardFileType.HTML, preferences.getFilePreferences()), new FileExtensionViewModel(StandardFileType.MARKDOWN, preferences.getFilePreferences()), new FileExtensionViewModel(StandardFileType.PDF, preferences.getFilePreferences())});
        this.dateFilterList = FXCollections.observableArrayList((Object[])DateRange.values());
        this.fileSortList = FXCollections.observableArrayList((Object[])ExternalFileSorter.values());
        Predicate<String> isDirectory = path -> Files.isDirectory(Path.of(path, new String[0]), new LinkOption[0]);
        this.scanDirectoryValidator = new FunctionBasedValidator((ObservableValue)this.directoryPath, isDirectory, ValidationMessage.error((String)Localization.lang("Please enter a valid file path.", new Object[0])));
        this.treeRootProperty.setValue(Optional.empty());
    }

    public void startSearch() {
        Path directory = this.getSearchDirectory();
        DirectoryStream.Filter<Path> selectedFileFilter = ((FileExtensionViewModel)this.selectedExtension.getValue()).dirFilter();
        DateRange selectedDateFilter = (DateRange)((Object)this.selectedDate.getValue());
        ExternalFileSorter selectedSortFilter = (ExternalFileSorter)((Object)this.selectedSort.getValue());
        this.progressValueProperty.unbind();
        this.progressTextProperty.unbind();
        this.findUnlinkedFilesTask = new UnlinkedFilesCrawler(directory, selectedFileFilter, selectedDateFilter, selectedSortFilter, this.bibDatabase, this.preferences.getFilePreferences()).onRunning(() -> {
            this.progressValueProperty.set(-1.0);
            this.progressTextProperty.setValue(Localization.lang("Searching file system...", new Object[0]));
            this.progressTextProperty.bind((ObservableValue)this.findUnlinkedFilesTask.messageProperty());
            this.taskActiveProperty.setValue(Boolean.valueOf(true));
            this.treeRootProperty.setValue(Optional.empty());
        }).onFinished(() -> {
            this.progressValueProperty.set(0.0);
            this.taskActiveProperty.setValue(Boolean.valueOf(false));
        }).onSuccess(treeRoot -> this.treeRootProperty.setValue(Optional.of(treeRoot)));
        this.findUnlinkedFilesTask.executeWith(this.taskExecutor);
    }

    public void startImport() {
        List<Path> fileList = this.checkedFileListProperty.stream().map(item -> ((FileNodeViewModel)item.getValue()).getPath()).filter(path -> path.toFile().isFile()).collect(Collectors.toList());
        if (fileList.isEmpty()) {
            LOGGER.warn("There are no valid files checked");
            return;
        }
        this.resultList.clear();
        this.importFilesBackgroundTask = this.importHandler.importFilesInBackground(fileList).onRunning(() -> {
            this.progressValueProperty.bind((ObservableValue)this.importFilesBackgroundTask.workDonePercentageProperty());
            this.progressTextProperty.bind((ObservableValue)this.importFilesBackgroundTask.messageProperty());
            this.taskActiveProperty.setValue(Boolean.valueOf(true));
        }).onFinished(() -> {
            this.progressValueProperty.unbind();
            this.progressTextProperty.unbind();
            this.taskActiveProperty.setValue(Boolean.valueOf(false));
        }).onSuccess(arg_0 -> this.resultList.addAll(arg_0));
        this.importFilesBackgroundTask.executeWith(this.taskExecutor);
    }

    public void startExport() {
        List<Path> fileList = this.checkedFileListProperty.stream().map(item -> ((FileNodeViewModel)item.getValue()).getPath()).filter(path -> path.toFile().isFile()).toList();
        if (fileList.isEmpty()) {
            LOGGER.warn("There are no valid files checked");
            return;
        }
        FileDialogConfiguration fileDialogConfiguration = new FileDialogConfiguration.Builder().withInitialDirectory(this.preferences.getFilePreferences().getWorkingDirectory()).addExtensionFilter(StandardFileType.TXT).withDefaultExtension(StandardFileType.TXT).build();
        Optional<Path> exportPath = this.dialogService.showFileSaveDialog(fileDialogConfiguration);
        if (exportPath.isEmpty()) {
            return;
        }
        try (BufferedWriter writer = Files.newBufferedWriter(exportPath.get(), StandardCharsets.UTF_8, StandardOpenOption.CREATE);){
            for (Path file : fileList) {
                writer.write(file.toString() + "\n");
            }
        }
        catch (IOException e) {
            LOGGER.error("Error exporting", (Throwable)e);
        }
    }

    public ObservableList<FileExtensionViewModel> getFileFilters() {
        return this.fileFilterList;
    }

    public ObservableList<DateRange> getDateFilters() {
        return this.dateFilterList;
    }

    public ObservableList<ExternalFileSorter> getSorters() {
        return this.fileSortList;
    }

    public void cancelTasks() {
        if (this.findUnlinkedFilesTask != null) {
            this.findUnlinkedFilesTask.cancel();
        }
        if (this.importFilesBackgroundTask != null) {
            this.importFilesBackgroundTask.cancel();
        }
    }

    public void browseFileDirectory() {
        DirectoryDialogConfiguration directoryDialogConfiguration = new DirectoryDialogConfiguration.Builder().withInitialDirectory(this.preferences.getFilePreferences().getWorkingDirectory()).build();
        this.dialogService.showDirectorySelectionDialog(directoryDialogConfiguration).ifPresent(selectedDirectory -> {
            this.directoryPath.setValue(selectedDirectory.toAbsolutePath().toString());
            this.preferences.getFilePreferences().setWorkingDirectory(selectedDirectory.toAbsolutePath());
        });
    }

    private Path getSearchDirectory() {
        Path directory = Path.of(this.directoryPath.getValue(), new String[0]);
        if (Files.notExists(directory, new LinkOption[0])) {
            directory = Path.of(System.getProperty("user.dir"), new String[0]);
            this.directoryPath.setValue(directory.toAbsolutePath().toString());
        }
        if (!Files.isDirectory(directory, new LinkOption[0])) {
            directory = directory.getParent();
            this.directoryPath.setValue(directory.toAbsolutePath().toString());
        }
        return directory;
    }

    public ObservableList<ImportFilesResultItemViewModel> resultTableItems() {
        return this.resultList;
    }

    public ObjectProperty<Optional<FileNodeViewModel>> treeRootProperty() {
        return this.treeRootProperty;
    }

    public ObjectProperty<FileExtensionViewModel> selectedExtensionProperty() {
        return this.selectedExtension;
    }

    public ObjectProperty<DateRange> selectedDateProperty() {
        return this.selectedDate;
    }

    public ObjectProperty<ExternalFileSorter> selectedSortProperty() {
        return this.selectedSort;
    }

    public StringProperty directoryPathProperty() {
        return this.directoryPath;
    }

    public ValidationStatus directoryPathValidationStatus() {
        return this.scanDirectoryValidator.getValidationStatus();
    }

    public DoubleProperty progressValueProperty() {
        return this.progressValueProperty;
    }

    public StringProperty progressTextProperty() {
        return this.progressTextProperty;
    }

    public BooleanProperty taskActiveProperty() {
        return this.taskActiveProperty;
    }

    public SimpleListProperty<TreeItem<FileNodeViewModel>> checkedFileListProperty() {
        return this.checkedFileListProperty;
    }
}

