/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.externalfiles;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.jabref.gui.externalfiles.ChainedFilters;
import org.jabref.gui.externalfiles.DateRange;
import org.jabref.gui.externalfiles.ExternalFileSorter;
import org.jabref.gui.externalfiles.FileFilterUtils;
import org.jabref.gui.externalfiles.GitIgnoreFileFilter;
import org.jabref.gui.externalfiles.UnlinkedPDFFileFilter;
import org.jabref.gui.util.BackgroundTask;
import org.jabref.gui.util.FileNodeViewModel;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.preferences.FilePreferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnlinkedFilesCrawler
extends BackgroundTask<FileNodeViewModel> {
    private static final Logger LOGGER = LoggerFactory.getLogger(UnlinkedFilesCrawler.class);
    private final Path directory;
    private final DirectoryStream.Filter<Path> fileFilter;
    private final DateRange dateFilter;
    private final ExternalFileSorter sorter;
    private final BibDatabaseContext databaseContext;
    private final FilePreferences filePreferences;

    public UnlinkedFilesCrawler(Path directory, DirectoryStream.Filter<Path> fileFilter, DateRange dateFilter, ExternalFileSorter sorter, BibDatabaseContext databaseContext, FilePreferences filePreferences) {
        this.directory = directory;
        this.fileFilter = fileFilter;
        this.dateFilter = dateFilter;
        this.sorter = sorter;
        this.databaseContext = databaseContext;
        this.filePreferences = filePreferences;
    }

    @Override
    protected FileNodeViewModel call() throws IOException {
        UnlinkedPDFFileFilter unlinkedPDFFileFilter = new UnlinkedPDFFileFilter(this.fileFilter, this.databaseContext, this.filePreferences);
        return this.searchDirectory(this.directory, unlinkedPDFFileFilter);
    }

    FileNodeViewModel searchDirectory(Path directory, UnlinkedPDFFileFilter unlinkedPDFFileFilter) throws IOException {
        Map<Boolean, List<Path>> directoryAndFilePartition;
        if (directory == null || !Files.isDirectory(directory, new LinkOption[0])) {
            throw new IOException("Invalid directory for searching: %s".formatted(directory));
        }
        FileNodeViewModel fileNodeViewModelForCurrentDirectory = new FileNodeViewModel(directory);
        ChainedFilters filters = new ChainedFilters(unlinkedPDFFileFilter, new GitIgnoreFileFilter(directory));
        try (Stream<Path> filesStream = StreamSupport.stream(Files.newDirectoryStream(directory, filters).spliterator(), false);){
            directoryAndFilePartition = filesStream.collect(Collectors.partitioningBy(x$0 -> Files.isDirectory(x$0, new LinkOption[0])));
        }
        catch (IOException e) {
            LOGGER.error("Error while searching files", (Throwable)e);
            return fileNodeViewModelForCurrentDirectory;
        }
        List<Path> subDirectories = directoryAndFilePartition.get(true);
        List<Path> files = directoryAndFilePartition.get(false);
        int fileCountOfSubdirectories = 0;
        for (Path subDirectory : subDirectories) {
            FileNodeViewModel subRoot = this.searchDirectory(subDirectory, unlinkedPDFFileFilter);
            if (subRoot.getChildren().isEmpty()) continue;
            fileCountOfSubdirectories += subRoot.getFileCount();
            fileNodeViewModelForCurrentDirectory.getChildren().add((Object)subRoot);
        }
        List<Path> resultingFiles = new ArrayList<Path>();
        for (Path path : files) {
            if (!FileFilterUtils.filterByDate(path, this.dateFilter)) continue;
            resultingFiles.add(path);
        }
        resultingFiles = FileFilterUtils.sortByDate(resultingFiles, this.sorter);
        fileNodeViewModelForCurrentDirectory.setFileCount(resultingFiles.size() + fileCountOfSubdirectories);
        fileNodeViewModelForCurrentDirectory.getChildren().addAll((Collection)resultingFiles.stream().map(FileNodeViewModel::new).collect(Collectors.toList()));
        return fileNodeViewModelForCurrentDirectory;
    }
}

