/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.externalfiles;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jabref.gui.externalfiletype.ExternalFileType;
import org.jabref.gui.externalfiletype.ExternalFileTypes;
import org.jabref.gui.externalfiletype.UnknownExternalFileType;
import org.jabref.gui.undo.NamedCompound;
import org.jabref.gui.undo.UndoableFieldChange;
import org.jabref.gui.util.UiTaskExecutor;
import org.jabref.logic.bibtex.FileFieldWriter;
import org.jabref.logic.util.io.AutoLinkPreferences;
import org.jabref.logic.util.io.FileFinder;
import org.jabref.logic.util.io.FileFinders;
import org.jabref.logic.util.io.FileUtil;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.LinkedFile;
import org.jabref.model.entry.field.StandardField;
import org.jabref.preferences.FilePreferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoSetFileLinksUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(AutoSetFileLinksUtil.class);
    private final List<Path> directories;
    private final AutoLinkPreferences autoLinkPreferences;
    private final FilePreferences filePreferences;

    public AutoSetFileLinksUtil(BibDatabaseContext databaseContext, FilePreferences filePreferences, AutoLinkPreferences autoLinkPreferences) {
        this(databaseContext.getFileDirectories(filePreferences), filePreferences, autoLinkPreferences);
    }

    private AutoSetFileLinksUtil(List<Path> directories, FilePreferences filePreferences, AutoLinkPreferences autoLinkPreferences) {
        this.directories = directories;
        this.autoLinkPreferences = autoLinkPreferences;
        this.filePreferences = filePreferences;
    }

    public LinkFilesResult linkAssociatedFiles(List<BibEntry> entries, NamedCompound ce) {
        LinkFilesResult result = new LinkFilesResult();
        for (BibEntry entry : entries) {
            List<Object> linkedFiles = new ArrayList();
            try {
                linkedFiles = this.findAssociatedNotLinkedFiles(entry);
            }
            catch (IOException e) {
                result.addFileException(e);
                LOGGER.error("Problem finding files", (Throwable)e);
            }
            if (ce == null) continue;
            boolean changed = false;
            for (LinkedFile linkedFile : linkedFiles) {
                String newVal = FileFieldWriter.getStringRepresentation(linkedFile);
                String oldVal = entry.getField(StandardField.FILE).orElse(null);
                UndoableFieldChange fieldChange = new UndoableFieldChange(entry, StandardField.FILE, oldVal, newVal);
                ce.addEdit(fieldChange);
                changed = true;
                UiTaskExecutor.runInJavaFXThread(() -> entry.addFile(linkedFile));
            }
            if (!changed) continue;
            result.addBibEntry(entry);
        }
        return result;
    }

    public List<LinkedFile> findAssociatedNotLinkedFiles(BibEntry entry) throws IOException {
        ArrayList<LinkedFile> linkedFiles = new ArrayList<LinkedFile>();
        List<String> extensions = this.filePreferences.getExternalFileTypes().stream().map(ExternalFileType::getExtension).collect(Collectors.toList());
        FileFinder fileFinder = FileFinders.constructFromConfiguration(this.autoLinkPreferences);
        List<Path> result = fileFinder.findAssociatedFiles(entry, this.directories, extensions);
        for (Path foundFile : result) {
            boolean fileAlreadyLinked = entry.getFiles().stream().map(file -> file.findIn(this.directories)).anyMatch(file -> {
                try {
                    return file.isPresent() && Files.isSameFile((Path)file.get(), foundFile);
                }
                catch (IOException e) {
                    LOGGER.error("Problem with isSameFile", (Throwable)e);
                    return false;
                }
            });
            if (fileAlreadyLinked) continue;
            Optional<UnknownExternalFileType> type = FileUtil.getFileExtension(foundFile).map(extension -> ExternalFileTypes.getExternalFileTypeByExt(extension, this.filePreferences)).orElse(Optional.of(new UnknownExternalFileType("")));
            String strType = type.isPresent() ? ((ExternalFileType)type.get()).getName() : "";
            Path relativeFilePath = FileUtil.relativize(foundFile, this.directories);
            LinkedFile linkedFile = new LinkedFile("", relativeFilePath, strType);
            linkedFiles.add(linkedFile);
        }
        return linkedFiles;
    }

    public static class LinkFilesResult {
        private final List<BibEntry> changedEntries = new ArrayList<BibEntry>();
        private final List<IOException> fileExceptions = new ArrayList<IOException>();

        protected void addBibEntry(BibEntry bibEntry) {
            this.changedEntries.add(bibEntry);
        }

        protected void addFileException(IOException exception) {
            this.fileExceptions.add(exception);
        }

        public List<BibEntry> getChangedEntries() {
            return this.changedEntries;
        }

        public List<IOException> getFileExceptions() {
            return this.fileExceptions;
        }
    }
}

