/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.errorconsole;

import com.airhacks.afterburner.views.ViewLoader;
import jakarta.inject.Inject;
import java.util.List;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SelectionMode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.stage.Modality;
import javafx.util.Callback;
import org.jabref.gui.ClipBoardManager;
import org.jabref.gui.DialogService;
import org.jabref.gui.errorconsole.ErrorConsoleViewModel;
import org.jabref.gui.errorconsole.LogEventViewModel;
import org.jabref.gui.icon.IconTheme;
import org.jabref.gui.keyboard.KeyBinding;
import org.jabref.gui.keyboard.KeyBindingRepository;
import org.jabref.gui.theme.ThemeManager;
import org.jabref.gui.util.BaseDialog;
import org.jabref.gui.util.ControlHelper;
import org.jabref.logic.l10n.Localization;
import org.jabref.logic.util.BuildInfo;
import org.jabref.preferences.PreferencesService;

public class ErrorConsoleView
extends BaseDialog<Void> {
    private ErrorConsoleViewModel viewModel;
    @FXML
    private ButtonType copyLogButton;
    @FXML
    private ButtonType clearLogButton;
    @FXML
    private ButtonType createIssueButton;
    @FXML
    private ListView<LogEventViewModel> messagesListView;
    @FXML
    private Label descriptionLabel;
    @Inject
    private DialogService dialogService;
    @Inject
    private PreferencesService preferencesService;
    @Inject
    private ClipBoardManager clipBoardManager;
    @Inject
    private BuildInfo buildInfo;
    @Inject
    private KeyBindingRepository keyBindingRepository;
    @Inject
    private ThemeManager themeManager;

    public ErrorConsoleView() {
        this.setTitle(Localization.lang("Event log", new Object[0]));
        this.initModality(Modality.NONE);
        ViewLoader.view((Object)((Object)this)).load().setAsDialogPane((Dialog)this);
        ControlHelper.setAction(this.copyLogButton, this.getDialogPane(), event -> this.copyLog());
        ControlHelper.setAction(this.clearLogButton, this.getDialogPane(), event -> this.clearLog());
        ControlHelper.setAction(this.createIssueButton, this.getDialogPane(), event -> this.createIssue());
        this.themeManager.updateFontStyle(this.getDialogPane().getScene());
    }

    @FXML
    private void initialize() {
        this.viewModel = new ErrorConsoleViewModel(this.dialogService, this.preferencesService, this.clipBoardManager, this.buildInfo);
        this.messagesListView.setCellFactory(this.createCellFactory());
        this.messagesListView.itemsProperty().bind(this.viewModel.allMessagesDataProperty());
        this.messagesListView.scrollTo(this.viewModel.allMessagesDataProperty().getSize() - 1);
        this.messagesListView.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.viewModel.allMessagesDataProperty().addListener(change -> {
            int size = this.viewModel.allMessagesDataProperty().size();
            if (size > 0) {
                this.messagesListView.scrollTo(size - 1);
            }
        });
        this.descriptionLabel.setGraphic(IconTheme.JabRefIcons.CONSOLE.getGraphicNode());
    }

    private Callback<ListView<LogEventViewModel>, ListCell<LogEventViewModel>> createCellFactory() {
        return cell -> new ListCell<LogEventViewModel>(){
            private HBox graphic = new HBox(10.0);
            private Node icon;
            private VBox message;
            private Label heading = new Label();
            private Label stacktrace = new Label();
            {
                this.message = new VBox();
                this.message.getChildren().setAll((Object[])new Node[]{this.heading, this.stacktrace});
                this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
            }

            public void updateItem(LogEventViewModel event, boolean empty) {
                super.updateItem((Object)event, empty);
                if (event == null || empty) {
                    this.setGraphic(null);
                } else {
                    this.icon = event.getIcon().getGraphicNode();
                    this.heading.setText(event.getDisplayText());
                    this.heading.getStyleClass().setAll((Object[])new String[]{event.getStyleClass()});
                    this.stacktrace.setText(event.getStackTrace().orElse(""));
                    this.graphic.getStyleClass().setAll((Object[])new String[]{event.getStyleClass()});
                    this.graphic.getChildren().setAll((Object[])new Node[]{this.icon, this.message});
                    this.setGraphic((Node)this.graphic);
                    this.setContextMenu(this.createContextMenu(event));
                }
            }

            private ContextMenu createContextMenu(LogEventViewModel selectedLogEntry) {
                ContextMenu contextMenu = new ContextMenu();
                MenuItem copyItem = new MenuItem("Copy");
                copyItem.setOnAction(event -> ErrorConsoleView.this.viewModel.copyLogEntry(selectedLogEntry));
                contextMenu.getItems().add((Object)copyItem);
                return contextMenu;
            }
        };
    }

    @FXML
    private void copySelectedLogEntries(KeyEvent event) {
        if (this.keyBindingRepository.checkKeyCombinationEquality(KeyBinding.COPY, event)) {
            ObservableList selectedEntries = this.messagesListView.getSelectionModel().getSelectedItems();
            this.viewModel.copyLog((List<LogEventViewModel>)selectedEntries);
        }
    }

    @FXML
    private void copyLog() {
        this.viewModel.copyLog();
    }

    @FXML
    private void clearLog() {
        this.viewModel.clearLog();
    }

    @FXML
    private void createIssue() {
        this.viewModel.reportIssue();
    }
}

