/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.entryeditor.fileannotationtab;

import de.saxsys.mvvmfx.utils.commands.Command;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Separator;
import javafx.scene.control.Tooltip;
import javafx.scene.input.MouseButton;
import javafx.scene.text.Text;
import javafx.scene.text.TextFlow;
import org.jabref.gui.DialogService;
import org.jabref.gui.StateManager;
import org.jabref.gui.actions.ActionFactory;
import org.jabref.gui.actions.StandardActions;
import org.jabref.gui.desktop.JabRefDesktop;
import org.jabref.gui.documentviewer.DocumentViewerView;
import org.jabref.gui.entryeditor.EntryEditorTab;
import org.jabref.gui.maintable.OpenExternalFileAction;
import org.jabref.gui.maintable.OpenFolderAction;
import org.jabref.gui.util.TaskExecutor;
import org.jabref.gui.util.TooltipTextUtil;
import org.jabref.logic.l10n.Localization;
import org.jabref.logic.search.SearchQuery;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.LinkedFile;
import org.jabref.model.pdf.search.PdfSearchResults;
import org.jabref.model.pdf.search.SearchResult;
import org.jabref.model.search.rules.SearchRules;
import org.jabref.preferences.PreferencesService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FulltextSearchResultsTab
extends EntryEditorTab {
    public static final String NAME = "Search results";
    private static final Logger LOGGER = LoggerFactory.getLogger(FulltextSearchResultsTab.class);
    private final StateManager stateManager;
    private final PreferencesService preferencesService;
    private final DialogService dialogService;
    private final ActionFactory actionFactory;
    private final TaskExecutor taskExecutor;
    private final TextFlow content;
    private BibEntry entry;
    private DocumentViewerView documentViewerView;

    public FulltextSearchResultsTab(StateManager stateManager, PreferencesService preferencesService, DialogService dialogService, TaskExecutor taskExecutor) {
        this.stateManager = stateManager;
        this.preferencesService = preferencesService;
        this.dialogService = dialogService;
        this.actionFactory = new ActionFactory();
        this.taskExecutor = taskExecutor;
        this.content = new TextFlow();
        ScrollPane scrollPane = new ScrollPane((Node)this.content);
        scrollPane.setFitToWidth(true);
        this.content.setPadding(new Insets(10.0));
        this.setContent((Node)scrollPane);
        this.setText(Localization.lang(NAME, new Object[0]));
        this.stateManager.activeSearchQueryProperty().addListener((observable, oldValue, newValue) -> this.bindToEntry(this.entry));
    }

    @Override
    public boolean shouldShow(BibEntry entry) {
        return this.stateManager.activeSearchQueryProperty().isPresent().get() && ((Optional)this.stateManager.activeSearchQueryProperty().get()).isPresent() && ((SearchQuery)((Optional)this.stateManager.activeSearchQueryProperty().get()).get()).getSearchFlags().contains((Object)SearchRules.SearchFlags.FULLTEXT) && !((SearchQuery)((Optional)this.stateManager.activeSearchQueryProperty().get()).get()).getQuery().isEmpty();
    }

    @Override
    protected void bindToEntry(BibEntry entry) {
        if (entry == null || !this.shouldShow(entry)) {
            return;
        }
        if (this.documentViewerView == null) {
            this.documentViewerView = new DocumentViewerView();
        }
        this.entry = entry;
        PdfSearchResults searchResults = ((SearchQuery)((Optional)this.stateManager.activeSearchQueryProperty().get()).get()).getRule().getFulltextResults(((SearchQuery)((Optional)this.stateManager.activeSearchQueryProperty().get()).get()).getQuery(), entry);
        this.content.getChildren().clear();
        if (searchResults.numSearchResults() == 0) {
            this.content.getChildren().add((Object)new Text(Localization.lang("No search matches.", new Object[0])));
        }
        for (Map.Entry<String, List<SearchResult>> resultsForPath : searchResults.getSearchResultsByPath().entrySet()) {
            entry.getFiles().stream().filter(file -> file.getLink().equals(resultsForPath.getKey())).findFirst().ifPresent(linkedFile -> {
                this.content.getChildren().addAll((Object[])new Node[]{this.createFileLink((LinkedFile)linkedFile), this.lineSeparator()});
                for (SearchResult searchResult : (List)resultsForPath.getValue()) {
                    for (String resultTextHtml : searchResult.getContentResultStringsHtml()) {
                        this.content.getChildren().addAll(TooltipTextUtil.createTextsFromHtml(resultTextHtml.replace("</b> <b>", " ")));
                        this.content.getChildren().addAll((Object[])new Node[]{new Text(System.lineSeparator()), this.lineSeparator(0.8), this.createPageLink((LinkedFile)linkedFile, searchResult.getPageNumber())});
                    }
                    if (!searchResult.getAnnotationsResultStringsHtml().isEmpty()) {
                        Text annotationsText = new Text(System.lineSeparator() + Localization.lang("Found matches in Annotations:", new Object[0]) + System.lineSeparator() + System.lineSeparator());
                        annotationsText.setStyle("-fx-font-style: italic;");
                        this.content.getChildren().add((Object)annotationsText);
                    }
                    for (String resultTextHtml : searchResult.getAnnotationsResultStringsHtml()) {
                        this.content.getChildren().addAll(TooltipTextUtil.createTextsFromHtml(resultTextHtml.replace("</b> <b>", " ")));
                        this.content.getChildren().addAll((Object[])new Node[]{new Text(System.lineSeparator()), this.lineSeparator(0.8), this.createPageLink((LinkedFile)linkedFile, searchResult.getPageNumber())});
                    }
                }
            });
        }
    }

    private Text createFileLink(LinkedFile linkedFile) {
        Text fileLinkText = new Text(Localization.lang("Found match in %0", linkedFile.getLink()) + System.lineSeparator() + System.lineSeparator());
        fileLinkText.setStyle("-fx-font-weight: bold;");
        ContextMenu fileContextMenu = this.getFileContextMenu(linkedFile);
        Path resolvedPath = linkedFile.findIn(this.stateManager.getActiveDatabase().get(), this.preferencesService.getFilePreferences()).orElse(Path.of(linkedFile.getLink(), new String[0]));
        Tooltip fileLinkTooltip = new Tooltip(resolvedPath.toAbsolutePath().toString());
        Tooltip.install((Node)fileLinkText, (Tooltip)fileLinkTooltip);
        fileLinkText.setOnMouseClicked(event -> {
            if (MouseButton.PRIMARY == event.getButton()) {
                try {
                    JabRefDesktop.openBrowser(resolvedPath.toUri(), this.preferencesService.getFilePreferences());
                }
                catch (IOException e) {
                    LOGGER.error("Cannot open {}.", (Object)resolvedPath, (Object)e);
                }
            } else {
                fileContextMenu.show((Node)fileLinkText, event.getScreenX(), event.getScreenY());
            }
        });
        return fileLinkText;
    }

    private Text createPageLink(LinkedFile linkedFile, int pageNumber) {
        Text pageLink = new Text(Localization.lang("On page %0", pageNumber) + System.lineSeparator() + System.lineSeparator());
        pageLink.setStyle("-fx-font-style: italic; -fx-font-weight: bold;");
        pageLink.setOnMouseClicked(event -> {
            if (MouseButton.PRIMARY == event.getButton()) {
                this.documentViewerView.switchToFile(linkedFile);
                this.documentViewerView.gotoPage(pageNumber);
                this.documentViewerView.disableLiveMode();
                this.dialogService.showCustomDialog(this.documentViewerView);
            }
        });
        return pageLink;
    }

    private ContextMenu getFileContextMenu(LinkedFile file) {
        ContextMenu fileContextMenu = new ContextMenu();
        fileContextMenu.getItems().add((Object)this.actionFactory.createMenuItem(StandardActions.OPEN_FOLDER, (Command)new OpenFolderAction(this.dialogService, this.stateManager, this.preferencesService, this.entry, file, this.taskExecutor)));
        fileContextMenu.getItems().add((Object)this.actionFactory.createMenuItem(StandardActions.OPEN_EXTERNAL_FILE, (Command)new OpenExternalFileAction(this.dialogService, this.stateManager, this.preferencesService, this.entry, file, this.taskExecutor)));
        return fileContextMenu;
    }

    private Separator lineSeparator() {
        return this.lineSeparator(1.0);
    }

    private Separator lineSeparator(double widthMultiplier) {
        Separator lineSeparator = new Separator(Orientation.HORIZONTAL);
        lineSeparator.prefWidthProperty().bind((ObservableValue)this.content.widthProperty().multiply(widthMultiplier));
        lineSeparator.setPrefHeight(15.0);
        return lineSeparator;
    }
}

