/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.entryeditor.fileannotationtab;

import com.tobiasdiez.easybind.EasyBind;
import jakarta.inject.Inject;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.geometry.HPos;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TextArea;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.VBox;
import javafx.scene.text.TextAlignment;
import org.jabref.gui.ClipBoardManager;
import org.jabref.gui.entryeditor.fileannotationtab.FileAnnotationTabViewModel;
import org.jabref.gui.entryeditor.fileannotationtab.FileAnnotationViewModel;
import org.jabref.gui.util.ViewModelListCellFactory;
import org.jabref.logic.l10n.Localization;
import org.jabref.logic.pdf.FileAnnotationCache;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.util.FileUpdateMonitor;

public class FileAnnotationTabView {
    @FXML
    public ComboBox<Path> files;
    @FXML
    public ListView<FileAnnotationViewModel> annotationList;
    @FXML
    public Label author;
    @FXML
    public Label page;
    @FXML
    public Label date;
    @FXML
    public TextArea content;
    @FXML
    public TextArea marking;
    @FXML
    public VBox details;
    private final BibEntry entry;
    private final FileAnnotationCache fileAnnotationCache;
    private FileAnnotationTabViewModel viewModel;
    @Inject
    private FileUpdateMonitor fileMonitor;
    @Inject
    private ClipBoardManager clipBoardManager;

    public FileAnnotationTabView(BibEntry entry, FileAnnotationCache fileAnnotationCache) {
        this.entry = entry;
        this.fileAnnotationCache = fileAnnotationCache;
    }

    @FXML
    public void initialize() {
        this.viewModel = new FileAnnotationTabViewModel(this.fileAnnotationCache, this.entry, this.fileMonitor, this.clipBoardManager);
        this.files.getItems().setAll((Collection)this.viewModel.filesProperty().get());
        this.files.getSelectionModel().selectedItemProperty().addListener((observable, oldValue, newValue) -> this.viewModel.notifyNewSelectedFile((Path)newValue));
        this.files.getSelectionModel().selectFirst();
        this.annotationList.getSelectionModel().setSelectionMode(SelectionMode.SINGLE);
        this.annotationList.getSelectionModel().selectedItemProperty().addListener((observable, oldValue, newValue) -> this.viewModel.notifyNewSelectedAnnotation((FileAnnotationViewModel)newValue));
        ViewModelListCellFactory cellFactory = new ViewModelListCellFactory().withGraphic(this::createFileAnnotationNode);
        this.annotationList.setCellFactory(cellFactory);
        this.annotationList.setPlaceholder((Node)new Label(Localization.lang("File has no attached annotations", new Object[0])));
        Bindings.bindContent((List)((List)this.annotationList.itemsProperty().get()), this.viewModel.annotationsProperty());
        this.annotationList.getSelectionModel().selectFirst();
        ((ObservableList)this.annotationList.itemsProperty().get()).addListener(c -> this.annotationList.getSelectionModel().selectFirst());
        this.content.textProperty().bind((ObservableValue)EasyBind.select(this.viewModel.currentAnnotationProperty()).selectObject(FileAnnotationViewModel::contentProperty));
        this.marking.textProperty().bind((ObservableValue)EasyBind.select(this.viewModel.currentAnnotationProperty()).selectObject(FileAnnotationViewModel::markingProperty));
        this.details.disableProperty().bind((ObservableValue)this.viewModel.isAnnotationsEmpty());
    }

    private Node createFileAnnotationNode(FileAnnotationViewModel annotation) {
        GridPane node = new GridPane();
        ColumnConstraints firstColumn = new ColumnConstraints();
        ColumnConstraints secondColumn = new ColumnConstraints();
        firstColumn.setPercentWidth(70.0);
        secondColumn.setPercentWidth(30.0);
        firstColumn.setHalignment(HPos.LEFT);
        secondColumn.setHalignment(HPos.RIGHT);
        node.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{firstColumn, secondColumn});
        Label marking = new Label(annotation.getMarking());
        Label author = new Label(annotation.getAuthor());
        Label date = new Label(annotation.getDate());
        Label page = new Label(Localization.lang("Page", new Object[0]) + ": " + annotation.getPage());
        marking.setStyle("-fx-font-size: 0.75em; -fx-font-weight: bold");
        marking.setMaxHeight(30.0);
        Tooltip markingTooltip = new Tooltip(annotation.getMarking());
        markingTooltip.setMaxWidth(800.0);
        markingTooltip.setWrapText(true);
        marking.setTooltip(markingTooltip);
        marking.setTextAlignment(TextAlignment.LEFT);
        marking.setAlignment(Pos.TOP_LEFT);
        marking.setMaxWidth(500.0);
        marking.setWrapText(true);
        author.setTextAlignment(TextAlignment.LEFT);
        author.setAlignment(Pos.TOP_LEFT);
        date.setTextAlignment(TextAlignment.RIGHT);
        date.setAlignment(Pos.TOP_RIGHT);
        page.setTextAlignment(TextAlignment.RIGHT);
        page.setAlignment(Pos.TOP_RIGHT);
        node.add((Node)marking, 0, 0);
        node.add((Node)author, 0, 1);
        node.add((Node)date, 1, 0);
        node.add((Node)page, 1, 1);
        return node;
    }

    public void copy() {
        this.viewModel.copyCurrentAnnotation();
    }
}

