/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.entryeditor;

import com.tobiasdiez.easybind.EasyBind;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import javafx.geometry.HPos;
import javafx.scene.Node;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;
import org.controlsfx.control.HyperlinkLabel;
import org.jabref.gui.DialogService;
import org.jabref.gui.desktop.JabRefDesktop;
import org.jabref.gui.entryeditor.EntryEditorTab;
import org.jabref.gui.entryeditor.SciteTabViewModel;
import org.jabref.gui.entryeditor.SciteTallyModel;
import org.jabref.gui.util.TaskExecutor;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.entry.BibEntry;
import org.jabref.preferences.FilePreferences;
import org.jabref.preferences.PreferencesService;

public class SciteTab
extends EntryEditorTab {
    public static final String NAME = "Citation information";
    public static final String SCITE_REPORTS_URL_BASE = "https://scite.ai/reports/";
    private final GridPane sciteResultsPane;
    private final ProgressIndicator progressIndicator;
    private final SciteTabViewModel viewModel;
    private final PreferencesService preferencesService;
    private final DialogService dialogService;

    public SciteTab(PreferencesService preferencesService, TaskExecutor taskExecutor, DialogService dialogService) {
        this.preferencesService = preferencesService;
        this.viewModel = new SciteTabViewModel(preferencesService, taskExecutor);
        this.dialogService = dialogService;
        this.sciteResultsPane = new GridPane();
        this.progressIndicator = new ProgressIndicator();
        this.setText(NAME);
        this.setTooltip(new Tooltip(Localization.lang("Search scite.ai for Smart Citations", new Object[0])));
        this.setSciteResultsPane();
    }

    private void setSciteResultsPane() {
        this.progressIndicator.setMaxSize(100.0, 100.0);
        this.sciteResultsPane.add((Node)this.progressIndicator, 0, 0);
        ColumnConstraints column = new ColumnConstraints();
        column.setPercentWidth(100.0);
        column.setHalignment(HPos.CENTER);
        this.sciteResultsPane.getColumnConstraints().setAll((Object[])new ColumnConstraints[]{column});
        this.sciteResultsPane.setId("scitePane");
        this.setContent((Node)this.sciteResultsPane);
        EasyBind.subscribe(this.viewModel.statusProperty(), status -> {
            this.sciteResultsPane.getChildren().clear();
            switch (status) {
                case IN_PROGRESS: {
                    this.sciteResultsPane.add((Node)this.progressIndicator, 0, 0);
                    break;
                }
                case FOUND: {
                    this.viewModel.getCurrentResult().ifPresent(result -> this.sciteResultsPane.add((Node)this.getTalliesPane((SciteTallyModel)result), 0, 0));
                    break;
                }
                case ERROR: {
                    this.sciteResultsPane.add((Node)this.getErrorPane(), 0, 0);
                }
            }
        });
    }

    @Override
    public boolean shouldShow(BibEntry entry) {
        return this.viewModel.shouldShow();
    }

    @Override
    protected void bindToEntry(BibEntry entry) {
        this.viewModel.bindToEntry(entry);
    }

    private VBox getErrorPane() {
        Label titleLabel = new Label(Localization.lang("Error", new Object[0]));
        titleLabel.getStyleClass().add((Object)"scite-error-label");
        Text errorMessageText = new Text((String)this.viewModel.searchErrorProperty().get());
        VBox errorMessageBox = new VBox(30.0, new Node[]{titleLabel, errorMessageText});
        errorMessageBox.getStyleClass().add((Object)"scite-error-box");
        return errorMessageBox;
    }

    private VBox getTalliesPane(SciteTallyModel tallModel) {
        Label titleLabel = new Label(Localization.lang("Tallies for %0", tallModel.doi()));
        titleLabel.getStyleClass().add((Object)"scite-tallies-label");
        Text message = new Text("Total Citations: %d\nSupporting: %d\nContradicting: %d\nMentioning: %d\nUnclassified: %d\nCiting Publications: %d".formatted(tallModel.total(), tallModel.supporting(), tallModel.contradicting(), tallModel.mentioning(), tallModel.unclassified(), tallModel.citingPublications()));
        String url = SCITE_REPORTS_URL_BASE + URLEncoder.encode(tallModel.doi(), StandardCharsets.UTF_8);
        VBox messageBox = this.getMessageBox(url, titleLabel, message);
        messageBox.getStyleClass().add((Object)"scite-message-box");
        return messageBox;
    }

    private VBox getMessageBox(String url, Label titleLabel, Text message) {
        HyperlinkLabel link = new HyperlinkLabel(Localization.lang("See full report at [%0]", url));
        link.setOnAction(event -> {
            if (event.getSource() instanceof Hyperlink) {
                FilePreferences filePreferences = this.preferencesService.getFilePreferences();
                try {
                    JabRefDesktop.openBrowser(url, filePreferences);
                }
                catch (IOException ioex) {
                    this.dialogService.showErrorDialogAndWait("An error occurred opening web browser", "JabRef was unable to open a web browser for link:\n\n" + url + "\n\nError Message:\n\n" + ioex.getMessage(), ioex);
                }
            }
        });
        return new VBox(30.0, new Node[]{titleLabel, message, link});
    }
}

