/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.entryeditor;

import javafx.scene.Node;
import org.jabref.gui.DialogService;
import org.jabref.gui.StateManager;
import org.jabref.gui.entryeditor.EntryEditorTab;
import org.jabref.gui.entryeditor.OffersPreview;
import org.jabref.gui.icon.IconTheme;
import org.jabref.gui.preview.PreviewPanel;
import org.jabref.gui.theme.ThemeManager;
import org.jabref.gui.util.TaskExecutor;
import org.jabref.logic.l10n.Localization;
import org.jabref.logic.pdf.search.IndexingTaskManager;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.entry.BibEntry;
import org.jabref.preferences.PreferencesService;

public class PreviewTab
extends EntryEditorTab
implements OffersPreview {
    public static final String NAME = "Preview";
    private final DialogService dialogService;
    private final BibDatabaseContext databaseContext;
    private final PreferencesService preferences;
    private final StateManager stateManager;
    private final ThemeManager themeManager;
    private final IndexingTaskManager indexingTaskManager;
    private final TaskExecutor taskExecutor;
    private PreviewPanel previewPanel;

    public PreviewTab(BibDatabaseContext databaseContext, DialogService dialogService, PreferencesService preferences, StateManager stateManager, ThemeManager themeManager, IndexingTaskManager indexingTaskManager, TaskExecutor taskExecutor) {
        this.databaseContext = databaseContext;
        this.dialogService = dialogService;
        this.preferences = preferences;
        this.stateManager = stateManager;
        this.themeManager = themeManager;
        this.indexingTaskManager = indexingTaskManager;
        this.taskExecutor = taskExecutor;
        this.setGraphic(IconTheme.JabRefIcons.TOGGLE_ENTRY_PREVIEW.getGraphicNode());
        this.setText(Localization.lang(NAME, new Object[0]));
    }

    @Override
    public void nextPreviewStyle() {
        if (this.previewPanel != null) {
            this.previewPanel.nextPreviewStyle();
        }
    }

    @Override
    public void previousPreviewStyle() {
        if (this.previewPanel != null) {
            this.previewPanel.previousPreviewStyle();
        }
    }

    @Override
    public boolean shouldShow(BibEntry entry) {
        return this.preferences.getPreviewPreferences().shouldShowPreviewAsExtraTab();
    }

    @Override
    protected void bindToEntry(BibEntry entry) {
        if (this.previewPanel == null) {
            this.previewPanel = new PreviewPanel(this.databaseContext, this.dialogService, this.preferences.getKeyBindingRepository(), this.preferences, this.stateManager, this.themeManager, this.indexingTaskManager, this.taskExecutor);
            this.setContent((Node)this.previewPanel);
        }
        this.previewPanel.setEntry(entry);
    }
}

