/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.entryeditor;

import java.io.File;
import java.io.FileFilter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Optional;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyListWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.monitor.FileAlterationListener;
import org.apache.commons.io.monitor.FileAlterationObserver;
import org.jabref.gui.AbstractViewModel;
import org.jabref.gui.DialogService;
import org.jabref.gui.util.DirectoryDialogConfiguration;
import org.jabref.gui.util.UiTaskExecutor;
import org.jabref.logic.l10n.Localization;
import org.jabref.logic.texparser.DefaultLatexParser;
import org.jabref.logic.util.io.FileUtil;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.texparser.Citation;
import org.jabref.model.texparser.LatexParserResult;
import org.jabref.model.texparser.LatexParserResults;
import org.jabref.model.util.DirectoryMonitorManager;
import org.jabref.preferences.PreferencesService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LatexCitationsTabViewModel
extends AbstractViewModel {
    private static final Logger LOGGER = LoggerFactory.getLogger(LatexCitationsTabViewModel.class);
    private static final String TEX_EXT = ".tex";
    private static final IOFileFilter FILE_FILTER = FileFilterUtils.or((IOFileFilter[])new IOFileFilter[]{FileFilterUtils.suffixFileFilter((String)".tex"), FileFilterUtils.directoryFileFilter()});
    private final BibDatabaseContext databaseContext;
    private final PreferencesService preferencesService;
    private final DialogService dialogService;
    private final ObjectProperty<Path> directory;
    private final ObservableList<Citation> citationList;
    private final ObjectProperty<Status> status;
    private final StringProperty searchError;
    private final BooleanProperty updateStatusOnCreate;
    private final DefaultLatexParser latexParser;
    private final LatexParserResults latexFiles;
    private final DirectoryMonitorManager directoryMonitorManager;
    private final FileAlterationListener listener;
    private FileAlterationObserver observer;
    private BibEntry currentEntry;

    public LatexCitationsTabViewModel(BibDatabaseContext databaseContext, PreferencesService preferencesService, DialogService dialogService, DirectoryMonitorManager directoryMonitorManager) {
        this.databaseContext = databaseContext;
        this.preferencesService = preferencesService;
        this.dialogService = dialogService;
        this.directory = new SimpleObjectProperty((Object)databaseContext.getMetaData().getLatexFileDirectory(preferencesService.getFilePreferences().getUserAndHost()).orElse(FileUtil.getInitialDirectory(databaseContext, preferencesService.getFilePreferences().getWorkingDirectory())));
        this.citationList = FXCollections.observableArrayList();
        this.status = new SimpleObjectProperty((Object)Status.IN_PROGRESS);
        this.searchError = new SimpleStringProperty("");
        this.directoryMonitorManager = directoryMonitorManager;
        this.updateStatusOnCreate = new SimpleBooleanProperty(false);
        this.listener = this.getListener();
        this.latexParser = new DefaultLatexParser();
        this.latexFiles = new LatexParserResults();
    }

    private FileAlterationListener getListener() {
        return new FileAlterationListener(){

            public void onStart(FileAlterationObserver observer) {
                if (!LatexCitationsTabViewModel.this.updateStatusOnCreate.get()) {
                    UiTaskExecutor.runInJavaFXThread(() -> LatexCitationsTabViewModel.this.status.set((Object)Status.IN_PROGRESS));
                }
            }

            public void onStop(FileAlterationObserver observer) {
                if (!LatexCitationsTabViewModel.this.updateStatusOnCreate.get()) {
                    LatexCitationsTabViewModel.this.updateStatusOnCreate.set(true);
                    LatexCitationsTabViewModel.this.updateStatus();
                }
            }

            public void onFileCreate(File file) {
                Path path = file.toPath();
                LatexParserResult result = LatexCitationsTabViewModel.this.latexParser.parse(path).get();
                LatexCitationsTabViewModel.this.latexFiles.add(path, result);
                Optional<String> citationKey = LatexCitationsTabViewModel.this.currentEntry.getCitationKey();
                if (citationKey.isPresent()) {
                    Collection<Citation> citations = result.getCitationsByKey(citationKey.get());
                    UiTaskExecutor.runInJavaFXThread(() -> LatexCitationsTabViewModel.this.citationList.addAll(citations));
                }
                if (LatexCitationsTabViewModel.this.updateStatusOnCreate.get()) {
                    LatexCitationsTabViewModel.this.updateStatus();
                }
            }

            public void onFileDelete(File file) {
                LatexParserResult result = LatexCitationsTabViewModel.this.latexFiles.remove(file.toPath());
                Optional<String> citationKey = LatexCitationsTabViewModel.this.currentEntry.getCitationKey();
                if (citationKey.isPresent()) {
                    Collection<Citation> citations = result.getCitationsByKey(citationKey.get());
                    UiTaskExecutor.runInJavaFXThread(() -> LatexCitationsTabViewModel.this.citationList.removeAll(citations));
                    LatexCitationsTabViewModel.this.updateStatus();
                }
            }

            public void onFileChange(File file) {
                this.onFileDelete(file);
                this.onFileCreate(file);
                LatexCitationsTabViewModel.this.updateStatus();
            }

            public void onDirectoryChange(File directory) {
            }

            public void onDirectoryCreate(File directory) {
            }

            public void onDirectoryDelete(File directory) {
            }
        };
    }

    public void bindToEntry(BibEntry entry) {
        this.checkAndUpdateDirectory();
        this.currentEntry = entry;
        Optional<String> citationKey = entry.getCitationKey();
        if (this.observer == null) {
            this.observer = new FileAlterationObserver(((Path)this.directory.get()).toFile(), (FileFilter)FILE_FILTER);
            this.directoryMonitorManager.addObserver(this.observer, this.listener);
        }
        if (citationKey.isPresent()) {
            this.citationList.setAll(this.latexFiles.getCitationsByKey(citationKey.get()));
            if (this.status.get() != Status.IN_PROGRESS) {
                this.updateStatus();
            }
        } else {
            this.searchError.set((Object)Localization.lang("Selected entry does not have an associated citation key.", new Object[0]));
            this.status.set((Object)Status.ERROR);
        }
    }

    public void setLatexDirectory() {
        DirectoryDialogConfiguration directoryDialogConfiguration = new DirectoryDialogConfiguration.Builder().withInitialDirectory((Path)this.directory.get()).build();
        this.dialogService.showDirectorySelectionDialog(directoryDialogConfiguration).ifPresent(selectedDirectory -> this.databaseContext.getMetaData().setLatexFileDirectory(this.preferencesService.getFilePreferences().getUserAndHost(), selectedDirectory.toAbsolutePath()));
        this.checkAndUpdateDirectory();
    }

    private void checkAndUpdateDirectory() {
        Path newDirectory = this.databaseContext.getMetaData().getLatexFileDirectory(this.preferencesService.getFilePreferences().getUserAndHost()).orElse(FileUtil.getInitialDirectory(this.databaseContext, this.preferencesService.getFilePreferences().getWorkingDirectory()));
        if (!newDirectory.equals(this.directory.get())) {
            this.status.set((Object)Status.IN_PROGRESS);
            this.updateStatusOnCreate.set(false);
            this.citationList.clear();
            this.latexFiles.clear();
            this.directoryMonitorManager.removeObserver(this.observer);
            this.directory.set((Object)newDirectory);
            this.observer = new FileAlterationObserver(((Path)this.directory.get()).toFile(), (FileFilter)FILE_FILTER);
            this.directoryMonitorManager.addObserver(this.observer, this.listener);
        }
    }

    private void updateStatus() {
        UiTaskExecutor.runInJavaFXThread(() -> {
            if (!Files.exists((Path)this.directory.get(), new LinkOption[0])) {
                this.searchError.set((Object)Localization.lang("Current search directory does not exist: %0", this.directory.get()));
                this.status.set((Object)Status.ERROR);
            } else if (this.citationList.isEmpty()) {
                this.status.set((Object)Status.NO_RESULTS);
            } else {
                this.status.set((Object)Status.CITATIONS_FOUND);
            }
        });
    }

    public ObjectProperty<Path> directoryProperty() {
        return this.directory;
    }

    public ObservableList<Citation> getCitationList() {
        return new ReadOnlyListWrapper(this.citationList);
    }

    public ObjectProperty<Status> statusProperty() {
        return this.status;
    }

    public StringProperty searchErrorProperty() {
        return this.searchError;
    }

    public boolean shouldShow() {
        return this.preferencesService.getEntryEditorPreferences().shouldShowLatexCitationsTab();
    }

    public static enum Status {
        IN_PROGRESS,
        CITATIONS_FOUND,
        NO_RESULTS,
        ERROR;

    }
}

