/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.entryeditor;

import com.tobiasdiez.easybind.EasyBind;
import com.tobiasdiez.easybind.Subscription;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.SequencedSet;
import java.util.stream.Stream;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.SplitPane;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.RowConstraints;
import javax.swing.undo.UndoManager;
import org.jabref.gui.DialogService;
import org.jabref.gui.StateManager;
import org.jabref.gui.autocompleter.SuggestionProviders;
import org.jabref.gui.entryeditor.EntryEditorTab;
import org.jabref.gui.entryeditor.OffersPreview;
import org.jabref.gui.fieldeditors.FieldEditorFX;
import org.jabref.gui.fieldeditors.FieldEditors;
import org.jabref.gui.fieldeditors.FieldNameLabel;
import org.jabref.gui.preview.PreviewPanel;
import org.jabref.gui.theme.ThemeManager;
import org.jabref.gui.undo.RedoAction;
import org.jabref.gui.undo.UndoAction;
import org.jabref.gui.util.TaskExecutor;
import org.jabref.logic.journals.JournalAbbreviationRepository;
import org.jabref.logic.pdf.search.IndexingTaskManager;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.field.Field;
import org.jabref.preferences.PreferencesService;

abstract class FieldsEditorTab
extends EntryEditorTab
implements OffersPreview {
    protected final BibDatabaseContext databaseContext;
    protected final Map<Field, FieldEditorFX> editors = new LinkedHashMap<Field, FieldEditorFX>();
    protected GridPane gridPane;
    private final boolean isCompressed;
    private final SuggestionProviders suggestionProviders;
    private final UndoAction undoAction;
    private final RedoAction redoAction;
    private final DialogService dialogService;
    private final PreferencesService preferences;
    private final ThemeManager themeManager;
    private final TaskExecutor taskExecutor;
    private final JournalAbbreviationRepository journalAbbreviationRepository;
    private final StateManager stateManager;
    private final IndexingTaskManager indexingTaskManager;
    private PreviewPanel previewPanel;
    private final UndoManager undoManager;
    private Collection<Field> fields = new ArrayList<Field>();
    private Subscription dividerPositionSubscription;

    public FieldsEditorTab(boolean compressed, BibDatabaseContext databaseContext, SuggestionProviders suggestionProviders, UndoManager undoManager, UndoAction undoAction, RedoAction redoAction, DialogService dialogService, PreferencesService preferences, StateManager stateManager, ThemeManager themeManager, TaskExecutor taskExecutor, JournalAbbreviationRepository journalAbbreviationRepository, IndexingTaskManager indexingTaskManager) {
        this.isCompressed = compressed;
        this.databaseContext = Objects.requireNonNull(databaseContext);
        this.suggestionProviders = Objects.requireNonNull(suggestionProviders);
        this.undoManager = Objects.requireNonNull(undoManager);
        this.undoAction = undoAction;
        this.redoAction = redoAction;
        this.dialogService = Objects.requireNonNull(dialogService);
        this.preferences = Objects.requireNonNull(preferences);
        this.themeManager = themeManager;
        this.taskExecutor = Objects.requireNonNull(taskExecutor);
        this.journalAbbreviationRepository = Objects.requireNonNull(journalAbbreviationRepository);
        this.stateManager = stateManager;
        this.indexingTaskManager = indexingTaskManager;
    }

    private static void addColumn(GridPane gridPane, int columnIndex, List<Label> nodes) {
        gridPane.addColumn(columnIndex, nodes.toArray(new Node[0]));
    }

    private static void addColumn(GridPane gridPane, int columnIndex, Stream<Parent> nodes) {
        gridPane.addColumn(columnIndex, (Node[])nodes.toArray(Node[]::new));
    }

    protected void setupPanel(BibEntry entry, boolean compressed) {
        if (this.preferences == null) {
            return;
        }
        this.editors.clear();
        this.gridPane.getChildren().clear();
        this.gridPane.getColumnConstraints().clear();
        this.gridPane.getRowConstraints().clear();
        this.fields = this.determineFieldsToShow(entry);
        List<Label> labels = this.fields.stream().map(field -> this.createLabelAndEditor(entry, (Field)field)).toList();
        ColumnConstraints columnExpand = new ColumnConstraints();
        columnExpand.setHgrow(Priority.ALWAYS);
        ColumnConstraints columnDoNotContract = new ColumnConstraints();
        columnDoNotContract.setMinWidth(Double.NEGATIVE_INFINITY);
        if (compressed) {
            int rows = (int)Math.ceil((double)this.fields.size() / 2.0);
            FieldsEditorTab.addColumn(this.gridPane, 0, labels.subList(0, rows));
            FieldsEditorTab.addColumn(this.gridPane, 1, this.editors.values().stream().map(FieldEditorFX::getNode).limit(rows));
            FieldsEditorTab.addColumn(this.gridPane, 3, labels.subList(rows, labels.size()));
            FieldsEditorTab.addColumn(this.gridPane, 4, this.editors.values().stream().map(FieldEditorFX::getNode).skip(rows));
            columnExpand.setPercentWidth(40.0);
            this.gridPane.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{columnDoNotContract, columnExpand, new ColumnConstraints(10.0), columnDoNotContract, columnExpand});
            FieldsEditorTab.setCompressedRowLayout(this.gridPane, rows);
        } else {
            FieldsEditorTab.addColumn(this.gridPane, 0, labels);
            FieldsEditorTab.addColumn(this.gridPane, 1, this.editors.values().stream().map(FieldEditorFX::getNode));
            this.gridPane.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{columnDoNotContract, columnExpand});
            this.setRegularRowLayout(this.gridPane);
        }
    }

    protected Label createLabelAndEditor(BibEntry entry, Field field) {
        FieldEditorFX fieldEditor = FieldEditors.getForField(field, this.taskExecutor, this.dialogService, this.journalAbbreviationRepository, this.preferences, this.databaseContext, entry.getType(), this.suggestionProviders, this.undoManager, this.undoAction, this.redoAction);
        fieldEditor.bindToEntry(entry);
        this.editors.put(field, fieldEditor);
        return new FieldNameLabel(field);
    }

    private void setRegularRowLayout(GridPane gridPane) {
        double totalWeight = this.fields.stream().mapToDouble(field -> this.editors.get(field).getWeight()).sum();
        List<RowConstraints> constraints = this.fields.stream().map(field -> {
            RowConstraints rowExpand = new RowConstraints();
            rowExpand.setVgrow(Priority.ALWAYS);
            rowExpand.setValignment(VPos.TOP);
            rowExpand.setPercentHeight(100.0 * this.editors.get(field).getWeight() / totalWeight);
            return rowExpand;
        }).toList();
        gridPane.getRowConstraints().addAll(constraints);
    }

    protected static void setCompressedRowLayout(GridPane gridPane, int rows) {
        RowConstraints rowExpand = new RowConstraints();
        rowExpand.setVgrow(Priority.ALWAYS);
        rowExpand.setValignment(VPos.TOP);
        if (rows == 0) {
            rowExpand.setPercentHeight(100.0);
        } else {
            rowExpand.setPercentHeight(100.0 / (double)rows);
        }
        ObservableList rowConstraints = gridPane.getRowConstraints();
        rowConstraints.clear();
        for (int i = 0; i < rows; ++i) {
            rowConstraints.add((Object)rowExpand);
        }
    }

    public void requestFocus(Field fieldName) {
        if (this.editors.containsKey(fieldName)) {
            this.editors.get(fieldName).focus();
        }
    }

    @Override
    public boolean shouldShow(BibEntry entry) {
        return !this.determineFieldsToShow(entry).isEmpty();
    }

    @Override
    protected void bindToEntry(BibEntry entry) {
        this.initPanel();
        this.setupPanel(entry, this.isCompressed);
        if (this.previewPanel != null) {
            this.previewPanel.setEntry(entry);
        }
    }

    @Override
    public void nextPreviewStyle() {
        if (this.previewPanel != null) {
            this.previewPanel.nextPreviewStyle();
        }
    }

    @Override
    public void previousPreviewStyle() {
        if (this.previewPanel != null) {
            this.previewPanel.previousPreviewStyle();
        }
    }

    protected abstract SequencedSet<Field> determineFieldsToShow(BibEntry var1);

    public Collection<Field> getShownFields() {
        return this.fields;
    }

    private void initPanel() {
        if (this.gridPane == null) {
            this.gridPane = new GridPane();
            this.gridPane.getStyleClass().add((Object)"editorPane");
            ScrollPane scrollPane = new ScrollPane();
            scrollPane.setHbarPolicy(ScrollPane.ScrollBarPolicy.NEVER);
            scrollPane.setVbarPolicy(ScrollPane.ScrollBarPolicy.AS_NEEDED);
            scrollPane.setContent((Node)this.gridPane);
            scrollPane.setFitToWidth(true);
            scrollPane.setFitToHeight(true);
            SplitPane container = new SplitPane(new Node[]{scrollPane});
            this.previewPanel = new PreviewPanel(this.databaseContext, this.dialogService, this.preferences.getKeyBindingRepository(), this.preferences, this.stateManager, this.themeManager, this.indexingTaskManager, this.taskExecutor);
            EasyBind.subscribe((ObservableValue)this.preferences.getPreviewPreferences().showPreviewAsExtraTabProperty(), show -> {
                if (show.booleanValue()) {
                    container.getItems().remove((Object)this.previewPanel);
                } else {
                    container.getItems().add(1, (Object)this.previewPanel);
                    container.setDividerPositions(new double[]{this.preferences.getEntryEditorPreferences().getPreviewWidthDividerPosition()});
                }
            });
            this.dividerPositionSubscription = EasyBind.valueAt((ObservableList)container.getDividers(), (int)0).mapObservable(SplitPane.Divider::positionProperty).subscribeToValues(this::savePreviewWidthDividerPosition);
            this.setContent((Node)container);
        }
    }

    private void savePreviewWidthDividerPosition(Number position) {
        if (!this.preferences.getPreviewPreferences().shouldShowPreviewAsExtraTab()) {
            this.preferences.getEntryEditorPreferences().setPreviewWidthDividerPosition(position.doubleValue());
        }
    }
}

