/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.edit.automaticfiededitor.renamefield;

import com.airhacks.afterburner.views.ViewLoader;
import com.tobiasdiez.easybind.EasyBind;
import de.saxsys.mvvmfx.utils.validation.visualization.ControlsFxVisualizer;
import java.util.List;
import javafx.application.Platform;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Control;
import javafx.scene.control.TextField;
import org.jabref.gui.StateManager;
import org.jabref.gui.edit.automaticfiededitor.AbstractAutomaticFieldEditorTabView;
import org.jabref.gui.edit.automaticfiededitor.AutomaticFieldEditorTab;
import org.jabref.gui.edit.automaticfiededitor.renamefield.RenameFieldViewModel;
import org.jabref.gui.util.FieldsUtil;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.database.BibDatabase;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.field.Field;

public class RenameFieldTabView
extends AbstractAutomaticFieldEditorTabView
implements AutomaticFieldEditorTab {
    @FXML
    private Button renameButton;
    @FXML
    private ComboBox<Field> fieldComboBox;
    @FXML
    private TextField newFieldNameTextField;
    private final List<BibEntry> selectedEntries;
    private final BibDatabase database;
    private final StateManager stateManager;
    private RenameFieldViewModel viewModel;
    private final ControlsFxVisualizer visualizer = new ControlsFxVisualizer();

    public RenameFieldTabView(BibDatabase database, StateManager stateManager) {
        this.selectedEntries = stateManager.getSelectedEntries();
        this.database = database;
        this.stateManager = stateManager;
        ViewLoader.view((Object)this).root((Object)this).load();
    }

    @FXML
    public void initialize() {
        this.viewModel = new RenameFieldViewModel(this.selectedEntries, this.database, this.stateManager);
        this.fieldComboBox.getItems().setAll(this.viewModel.getAllFields());
        this.fieldComboBox.getSelectionModel().selectFirst();
        this.fieldComboBox.setConverter(FieldsUtil.FIELD_STRING_CONVERTER);
        this.fieldComboBox.valueProperty().bindBidirectional(this.viewModel.selectedFieldProperty());
        EasyBind.listen((ObservableValue)this.fieldComboBox.getEditor().textProperty(), observable -> this.fieldComboBox.commitValue());
        this.renameButton.disableProperty().bind((ObservableValue)this.viewModel.canRenameProperty().not());
        this.newFieldNameTextField.textProperty().bindBidirectional((Property)this.viewModel.newFieldNameProperty());
        Platform.runLater(() -> this.visualizer.initVisualization(this.viewModel.fieldNameValidationStatus(), (Control)this.newFieldNameTextField, true));
    }

    @Override
    public String getTabName() {
        return Localization.lang("Rename field", new Object[0]);
    }

    @FXML
    void renameField() {
        this.viewModel.renameField();
    }
}

