/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.edit.automaticfiededitor.editfieldcontent;

import de.saxsys.mvvmfx.utils.validation.FunctionBasedValidator;
import de.saxsys.mvvmfx.utils.validation.ValidationMessage;
import de.saxsys.mvvmfx.utils.validation.ValidationStatus;
import de.saxsys.mvvmfx.utils.validation.Validator;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableBooleanValue;
import org.jabref.gui.StateManager;
import org.jabref.gui.edit.automaticfiededitor.AbstractAutomaticFieldEditorTabViewModel;
import org.jabref.gui.edit.automaticfiededitor.LastAutomaticFieldEditorEdit;
import org.jabref.gui.undo.NamedCompound;
import org.jabref.gui.undo.UndoableFieldChange;
import org.jabref.model.FieldChange;
import org.jabref.model.database.BibDatabase;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.field.Field;
import org.jabref.model.entry.field.StandardField;
import org.jabref.model.strings.StringUtil;

public class EditFieldContentViewModel
extends AbstractAutomaticFieldEditorTabViewModel {
    public static final int TAB_INDEX = 0;
    private final List<BibEntry> selectedEntries;
    private final StringProperty fieldValue = new SimpleStringProperty("");
    private final ObjectProperty<Field> selectedField = new SimpleObjectProperty((Object)StandardField.AUTHOR);
    private final BooleanProperty overwriteFieldContent = new SimpleBooleanProperty(Boolean.FALSE.booleanValue());
    private final Validator fieldValidator;
    private final BooleanBinding canAppend;

    public EditFieldContentViewModel(BibDatabase database, List<BibEntry> selectedEntries, StateManager stateManager) {
        super(database, stateManager);
        this.selectedEntries = new ArrayList<BibEntry>(selectedEntries);
        this.fieldValidator = new FunctionBasedValidator(this.selectedField, field -> {
            if (StringUtil.isBlank(field.getName())) {
                return ValidationMessage.error((String)"Field name cannot be empty");
            }
            if (StringUtil.containsWhitespace(field.getName())) {
                return ValidationMessage.error((String)"Field name cannot have whitespace characters");
            }
            return null;
        });
        this.canAppend = Bindings.and((ObservableBooleanValue)this.overwriteFieldContentProperty(), (ObservableBooleanValue)this.fieldValidationStatus().validProperty());
    }

    public ValidationStatus fieldValidationStatus() {
        return this.fieldValidator.getValidationStatus();
    }

    public BooleanBinding canAppendProperty() {
        return this.canAppend;
    }

    public void clearSelectedField() {
        NamedCompound clearFieldEdit = new NamedCompound("CLEAR_SELECTED_FIELD");
        int affectedEntriesCount = 0;
        for (BibEntry entry : this.selectedEntries) {
            Optional<String> oldFieldValue = entry.getField((Field)this.selectedField.get());
            if (!oldFieldValue.isPresent()) continue;
            entry.clearField((Field)this.selectedField.get()).ifPresent(fieldChange -> clearFieldEdit.addEdit(new UndoableFieldChange((FieldChange)fieldChange)));
            ++affectedEntriesCount;
        }
        if (clearFieldEdit.hasEdits()) {
            clearFieldEdit.end();
        }
        this.stateManager.setLastAutomaticFieldEditorEdit(new LastAutomaticFieldEditorEdit(affectedEntriesCount, 0, clearFieldEdit));
    }

    public void setFieldValue() {
        NamedCompound setFieldEdit = new NamedCompound("CHANGE_SELECTED_FIELD");
        String toSetFieldValue = this.fieldValue.getValue();
        int affectedEntriesCount = 0;
        for (BibEntry entry : this.selectedEntries) {
            Optional<String> oldFieldValue = entry.getField((Field)this.selectedField.get());
            if (!oldFieldValue.isEmpty() && !this.overwriteFieldContent.get()) continue;
            entry.setField((Field)this.selectedField.get(), toSetFieldValue).ifPresent(fieldChange -> setFieldEdit.addEdit(new UndoableFieldChange((FieldChange)fieldChange)));
            this.fieldValue.set((Object)"");
            ++affectedEntriesCount;
        }
        if (setFieldEdit.hasEdits()) {
            setFieldEdit.end();
        }
        this.stateManager.setLastAutomaticFieldEditorEdit(new LastAutomaticFieldEditorEdit(affectedEntriesCount, 0, setFieldEdit));
    }

    public void appendToFieldValue() {
        NamedCompound appendToFieldEdit = new NamedCompound("APPEND_TO_SELECTED_FIELD");
        String toAppendFieldValue = this.fieldValue.getValue();
        int affectedEntriesCount = 0;
        for (BibEntry entry : this.selectedEntries) {
            Optional<String> oldFieldValue = entry.getField((Field)this.selectedField.get());
            if (!this.overwriteFieldContent.get()) continue;
            String newFieldValue = oldFieldValue.orElse("").concat(toAppendFieldValue);
            entry.setField((Field)this.selectedField.get(), newFieldValue).ifPresent(fieldChange -> appendToFieldEdit.addEdit(new UndoableFieldChange((FieldChange)fieldChange)));
            this.fieldValue.set((Object)"");
            ++affectedEntriesCount;
        }
        if (appendToFieldEdit.hasEdits()) {
            appendToFieldEdit.end();
        }
        this.stateManager.setLastAutomaticFieldEditorEdit(new LastAutomaticFieldEditorEdit(affectedEntriesCount, 0, appendToFieldEdit));
    }

    public ObjectProperty<Field> selectedFieldProperty() {
        return this.selectedField;
    }

    public Field getSelectedField() {
        return (Field)this.selectedFieldProperty().get();
    }

    public String getFieldValue() {
        return (String)this.fieldValue.get();
    }

    public StringProperty fieldValueProperty() {
        return this.fieldValue;
    }

    public BooleanProperty overwriteFieldContentProperty() {
        return this.overwriteFieldContent;
    }
}

