/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.edit.automaticfiededitor;

import java.util.Collection;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Objects;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import org.jabref.gui.AbstractViewModel;
import org.jabref.gui.StateManager;
import org.jabref.model.database.BibDatabase;
import org.jabref.model.entry.field.Field;
import org.jabref.model.entry.field.StandardField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAutomaticFieldEditorTabViewModel
extends AbstractViewModel {
    public static final Logger LOGGER = LoggerFactory.getLogger(AbstractAutomaticFieldEditorTabViewModel.class);
    protected final StateManager stateManager;
    private final ObservableList<Field> allFields = FXCollections.observableArrayList();

    public AbstractAutomaticFieldEditorTabViewModel(BibDatabase bibDatabase, StateManager stateManager) {
        Objects.requireNonNull(bibDatabase);
        Objects.requireNonNull(stateManager);
        this.stateManager = stateManager;
        this.addFields(EnumSet.allOf(StandardField.class));
        this.addFields(bibDatabase.getAllVisibleFields());
        this.allFields.sort(Comparator.comparing(Field::getName));
    }

    public ObservableList<Field> getAllFields() {
        return this.allFields;
    }

    private void addFields(Collection<? extends Field> fields) {
        HashSet<Field> fieldsSet = new HashSet<Field>((Collection<Field>)this.allFields);
        fieldsSet.addAll(fields);
        this.allFields.setAll(fieldsSet);
    }
}

