/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.edit;

import java.util.Objects;
import java.util.Set;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import org.jabref.gui.AbstractViewModel;
import org.jabref.gui.LibraryTab;
import org.jabref.gui.undo.NamedCompound;
import org.jabref.gui.undo.UndoableFieldChange;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.field.Field;
import org.jabref.model.entry.field.FieldFactory;

public class ReplaceStringViewModel
extends AbstractViewModel {
    private boolean allFieldReplace;
    private String findString;
    private String replaceString;
    private Set<Field> fields;
    private LibraryTab panel;
    private StringProperty findStringProperty = new SimpleStringProperty();
    private StringProperty replaceStringProperty = new SimpleStringProperty();
    private StringProperty fieldStringProperty = new SimpleStringProperty();
    private BooleanProperty allFieldReplaceProperty = new SimpleBooleanProperty();
    private BooleanProperty selectOnlyProperty = new SimpleBooleanProperty();

    public ReplaceStringViewModel(LibraryTab libraryTab) {
        Objects.requireNonNull(libraryTab);
        this.panel = libraryTab;
    }

    public int replace() {
        this.findString = this.findStringProperty.getValue();
        this.replaceString = this.replaceStringProperty.getValue();
        this.fields = FieldFactory.parseFieldList(this.fieldStringProperty.getValue());
        boolean selOnly = this.selectOnlyProperty.getValue();
        this.allFieldReplace = this.allFieldReplaceProperty.getValue();
        NamedCompound compound = new NamedCompound(Localization.lang("Replace string", new Object[0]));
        int counter = 0;
        if (selOnly) {
            for (BibEntry bibEntry : this.panel.getSelectedEntries()) {
                counter += this.replaceItem(bibEntry, compound);
            }
        } else {
            for (BibEntry bibEntry : this.panel.getDatabase().getEntries()) {
                counter += this.replaceItem(bibEntry, compound);
            }
        }
        return counter;
    }

    private int replaceItem(BibEntry entry, NamedCompound compound) {
        int counter = 0;
        if (this.allFieldReplace) {
            for (Field field : entry.getFields()) {
                counter += this.replaceField(entry, field, compound);
            }
        } else {
            for (Field espField : this.fields) {
                counter += this.replaceField(entry, espField, compound);
            }
        }
        return counter;
    }

    private int replaceField(BibEntry entry, Field field, NamedCompound compound) {
        int ind;
        if (!entry.hasField(field)) {
            return 0;
        }
        String txt = entry.getField(field).get();
        StringBuilder stringBuilder = new StringBuilder();
        int piv = 0;
        int counter = 0;
        int len1 = this.findString.length();
        while ((ind = txt.indexOf(this.findString, piv)) >= 0) {
            ++counter;
            stringBuilder.append(txt, piv, ind);
            stringBuilder.append(this.replaceString);
            piv = ind + len1;
        }
        stringBuilder.append(txt.substring(piv));
        String newStr = stringBuilder.toString();
        entry.setField(field, newStr);
        compound.addEdit(new UndoableFieldChange(entry, field, txt, newStr));
        return counter;
    }

    public BooleanProperty allFieldReplaceProperty() {
        return this.allFieldReplaceProperty;
    }

    public BooleanProperty selectOnlyProperty() {
        return this.selectOnlyProperty;
    }

    public StringProperty fieldStringProperty() {
        return this.fieldStringProperty;
    }

    public StringProperty findStringProperty() {
        return this.findStringProperty;
    }

    public StringProperty replaceStringProperty() {
        return this.replaceStringProperty;
    }
}

