/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.documentviewer;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Objects;
import javafx.scene.image.PixelWriter;
import javafx.scene.image.WritableImage;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.rendering.ImageType;
import org.apache.pdfbox.rendering.PDFRenderer;
import org.jabref.architecture.AllowedToUseAwt;
import org.jabref.gui.documentviewer.DocumentPageViewModel;

@AllowedToUseAwt(value="Requires AWT due to PDFBox")
public class PdfDocumentPageViewModel
extends DocumentPageViewModel {
    private final PDPage page;
    private final int pageNumber;
    private final PDDocument document;

    public PdfDocumentPageViewModel(PDPage page, int pageNumber, PDDocument document) {
        this.page = Objects.requireNonNull(page);
        this.pageNumber = pageNumber;
        this.document = document;
    }

    private static BufferedImage resize(BufferedImage img, int newWidth, int newHeight) {
        Image tmp = img.getScaledInstance(newWidth, newHeight, 4);
        BufferedImage dimg = new BufferedImage(newWidth, newHeight, 2);
        Graphics2D g2d = dimg.createGraphics();
        g2d.drawImage(tmp, 0, 0, null);
        g2d.dispose();
        return dimg;
    }

    @Override
    public javafx.scene.image.Image render(int width, int height) {
        PDFRenderer renderer = new PDFRenderer(this.document);
        try {
            int resolution = 96;
            BufferedImage image = renderer.renderImageWithDPI(this.pageNumber, (float)(2 * resolution), ImageType.RGB);
            return PdfDocumentPageViewModel.convertToFxImage(PdfDocumentPageViewModel.resize(image, width, height));
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public int getPageNumber() {
        return this.pageNumber + 1;
    }

    @Override
    public double getAspectRatio() {
        PDRectangle mediaBox = this.page.getMediaBox();
        return mediaBox.getWidth() / mediaBox.getHeight();
    }

    private static javafx.scene.image.Image convertToFxImage(BufferedImage image) {
        WritableImage wr = null;
        if (image != null) {
            wr = new WritableImage(image.getWidth(), image.getHeight());
            PixelWriter pw = wr.getPixelWriter();
            for (int x = 0; x < image.getWidth(); ++x) {
                for (int y = 0; y < image.getHeight(); ++y) {
                    pw.setArgb(x, y, image.getRGB(x, y));
                }
            }
        }
        return wr;
    }
}

