/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.dialogs;

import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import javafx.scene.control.ButtonType;
import javax.swing.undo.UndoManager;
import org.jabref.gui.DialogService;
import org.jabref.gui.LibraryTab;
import org.jabref.gui.StateManager;
import org.jabref.gui.autosaveandbackup.BackupManager;
import org.jabref.gui.backup.BackupResolverDialog;
import org.jabref.gui.collab.DatabaseChange;
import org.jabref.gui.collab.DatabaseChangeList;
import org.jabref.gui.collab.DatabaseChangeResolverFactory;
import org.jabref.gui.collab.DatabaseChangesResolverDialog;
import org.jabref.gui.undo.NamedCompound;
import org.jabref.gui.util.UiTaskExecutor;
import org.jabref.logic.importer.ImportFormatPreferences;
import org.jabref.logic.importer.OpenDatabase;
import org.jabref.logic.importer.ParserResult;
import org.jabref.logic.l10n.Localization;
import org.jabref.logic.util.BackupFileType;
import org.jabref.logic.util.io.BackupFileUtil;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.util.DummyFileUpdateMonitor;
import org.jabref.model.util.FileUpdateMonitor;
import org.jabref.preferences.ExternalApplicationsPreferences;
import org.jabref.preferences.PreferencesService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BackupUIManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(BackupUIManager.class);

    private BackupUIManager() {
    }

    public static Optional<ParserResult> showRestoreBackupDialog(DialogService dialogService, Path originalPath, PreferencesService preferencesService, FileUpdateMonitor fileUpdateMonitor, UndoManager undoManager, StateManager stateManager) {
        Optional<ButtonType> actionOpt = BackupUIManager.showBackupResolverDialog(dialogService, preferencesService.getExternalApplicationsPreferences(), originalPath, preferencesService.getFilePreferences().getBackupDirectory());
        return actionOpt.flatMap(action -> {
            if (action == BackupResolverDialog.RESTORE_FROM_BACKUP) {
                BackupManager.restoreBackup(originalPath, preferencesService.getFilePreferences().getBackupDirectory());
                return Optional.empty();
            }
            if (action == BackupResolverDialog.REVIEW_BACKUP) {
                return BackupUIManager.showReviewBackupDialog(dialogService, originalPath, preferencesService, fileUpdateMonitor, undoManager, stateManager);
            }
            return Optional.empty();
        });
    }

    private static Optional<ButtonType> showBackupResolverDialog(DialogService dialogService, ExternalApplicationsPreferences externalApplicationsPreferences, Path originalPath, Path backupDir) {
        return UiTaskExecutor.runInJavaFXThread(() -> dialogService.showCustomDialogAndWait(new BackupResolverDialog(originalPath, backupDir, externalApplicationsPreferences)));
    }

    private static Optional<ParserResult> showReviewBackupDialog(DialogService dialogService, Path originalPath, PreferencesService preferencesService, FileUpdateMonitor fileUpdateMonitor, UndoManager undoManager, StateManager stateManager) {
        try {
            ImportFormatPreferences importFormatPreferences = preferencesService.getImportFormatPreferences();
            ParserResult originalParserResult = OpenDatabase.loadDatabase(originalPath, importFormatPreferences, fileUpdateMonitor);
            BibDatabaseContext originalDatabase = originalParserResult.getDatabaseContext();
            Path backupPath = BackupFileUtil.getPathOfLatestExistingBackupFile(originalPath, BackupFileType.BACKUP, preferencesService.getFilePreferences().getBackupDirectory()).orElseThrow();
            BibDatabaseContext backupDatabase = OpenDatabase.loadDatabase(backupPath, importFormatPreferences, new DummyFileUpdateMonitor()).getDatabaseContext();
            DatabaseChangeResolverFactory changeResolverFactory = new DatabaseChangeResolverFactory(dialogService, originalDatabase, preferencesService);
            return UiTaskExecutor.runInJavaFXThread(() -> {
                List<DatabaseChange> changes = DatabaseChangeList.compareAndGetChanges(originalDatabase, backupDatabase, changeResolverFactory);
                DatabaseChangesResolverDialog reviewBackupDialog = new DatabaseChangesResolverDialog(changes, originalDatabase, "Review Backup");
                Optional<Boolean> allChangesResolved = dialogService.showCustomDialogAndWait(reviewBackupDialog);
                LibraryTab saveState = (LibraryTab)((Object)((Object)((Optional)stateManager.activeTabProperty().get()).get()));
                NamedCompound CE = new NamedCompound(Localization.lang("Merged external changes", new Object[0]));
                changes.stream().filter(DatabaseChange::isAccepted).forEach(change -> change.applyChange(CE));
                CE.end();
                undoManager.addEdit(CE);
                if (allChangesResolved.get().booleanValue()) {
                    if (reviewBackupDialog.areAllChangesDenied()) {
                        saveState.resetChangeMonitor();
                    } else {
                        saveState.markBaseChanged();
                    }
                    return Optional.of(originalParserResult);
                }
                return BackupUIManager.showRestoreBackupDialog(dialogService, originalPath, preferencesService, fileUpdateMonitor, undoManager, stateManager);
            });
        }
        catch (IOException e) {
            LOGGER.error("Error while loading backup or current database", (Throwable)e);
            return Optional.empty();
        }
    }
}

