/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.desktop.os;

import java.awt.Desktop;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import org.jabref.architecture.AllowedToUseAwt;
import org.jabref.gui.DialogService;
import org.jabref.gui.desktop.os.NativeDesktop;
import org.jabref.gui.externalfiletype.ExternalFileType;
import org.jabref.gui.externalfiletype.ExternalFileTypes;
import org.jabref.gui.util.StreamGobbler;
import org.jabref.logic.l10n.Localization;
import org.jabref.logic.util.HeadlessExecutorService;
import org.jabref.preferences.FilePreferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AllowedToUseAwt(value="Requires AWT to open a file with the native method")
public class Linux
extends NativeDesktop {
    private static final String ETC_ALTERNATIVES_X_TERMINAL_EMULATOR = "/etc/alternatives/x-terminal-emulator";

    private void nativeOpenFile(String filePath) {
        HeadlessExecutorService.INSTANCE.execute(() -> {
            try {
                File file = new File(filePath);
                Desktop.getDesktop().open(file);
                LoggerFactory.getLogger(Linux.class).debug("Open file in default application with Desktop integration");
            }
            catch (IllegalArgumentException e) {
                LoggerFactory.getLogger(Linux.class).debug("Fail back to xdg-open");
                try {
                    String[] cmd = new String[]{"xdg-open", filePath};
                    Runtime.getRuntime().exec(cmd);
                }
                catch (Exception e2) {
                    LoggerFactory.getLogger(Linux.class).warn("Open operation not successful: ", (Throwable)e2);
                }
            }
            catch (IOException e) {
                LoggerFactory.getLogger(Linux.class).warn("Native open operation not successful: ", (Throwable)e);
            }
        });
    }

    @Override
    public void openFile(String filePath, String fileType, FilePreferences filePreferences) throws IOException {
        Optional<ExternalFileType> type = ExternalFileTypes.getExternalFileTypeByExt(fileType, filePreferences);
        if (type.isPresent() && !type.get().getOpenWithApplication().isEmpty()) {
            String viewer = type.get().getOpenWithApplication();
            ProcessBuilder processBuilder = new ProcessBuilder(viewer, filePath);
            Process process = processBuilder.start();
            StreamGobbler streamGobblerInput = new StreamGobbler(process.getInputStream(), arg_0 -> ((Logger)LoggerFactory.getLogger(Linux.class)).debug(arg_0));
            StreamGobbler streamGobblerError = new StreamGobbler(process.getErrorStream(), arg_0 -> ((Logger)LoggerFactory.getLogger(Linux.class)).debug(arg_0));
            HeadlessExecutorService.INSTANCE.execute(streamGobblerInput);
            HeadlessExecutorService.INSTANCE.execute(streamGobblerError);
        } else {
            this.nativeOpenFile(filePath);
        }
    }

    @Override
    public void openFileWithApplication(String filePath, String application) throws IOException {
        if (application != null && !application.isEmpty()) {
            String[] openWith = application.split(" ");
            String[] cmdArray = new String[openWith.length + 1];
            System.arraycopy(openWith, 0, cmdArray, 0, openWith.length);
            cmdArray[cmdArray.length - 1] = filePath;
            ProcessBuilder processBuilder = new ProcessBuilder(cmdArray);
            Process process = processBuilder.start();
            StreamGobbler streamGobblerInput = new StreamGobbler(process.getInputStream(), arg_0 -> ((Logger)LoggerFactory.getLogger(Linux.class)).debug(arg_0));
            StreamGobbler streamGobblerError = new StreamGobbler(process.getErrorStream(), arg_0 -> ((Logger)LoggerFactory.getLogger(Linux.class)).debug(arg_0));
            HeadlessExecutorService.INSTANCE.execute(streamGobblerInput);
            HeadlessExecutorService.INSTANCE.execute(streamGobblerError);
        } else {
            this.nativeOpenFile(filePath);
        }
    }

    @Override
    public void openFolderAndSelectFile(Path filePath) throws IOException {
        String desktopSession = System.getenv("DESKTOP_SESSION");
        String absoluteFilePath = filePath.toAbsolutePath().toString();
        CharSequence[] cmd = new String[]{"xdg-open", filePath.getParent().toString()};
        if (desktopSession != null) {
            if ((desktopSession = desktopSession.toLowerCase(Locale.ROOT)).contains("gnome")) {
                cmd = new String[]{"nautilus", "--select", absoluteFilePath};
            } else if (desktopSession.contains("kde") || desktopSession.contains("plasma")) {
                cmd = new String[]{"dolphin", "--select", absoluteFilePath};
            } else if (desktopSession.contains("mate")) {
                cmd = new String[]{"caja", "--select", absoluteFilePath};
            } else if (desktopSession.contains("cinnamon")) {
                cmd = new String[]{"nemo", absoluteFilePath};
            } else if (desktopSession.contains("xfce")) {
                cmd = new String[]{"thunar", absoluteFilePath};
            }
        }
        LoggerFactory.getLogger(Linux.class).debug("Opening folder and selecting file using {}", (Object)String.join((CharSequence)" ", cmd));
        ProcessBuilder processBuilder = new ProcessBuilder((String[])cmd);
        Process process = processBuilder.start();
        StreamGobbler streamGobblerInput = new StreamGobbler(process.getInputStream(), arg_0 -> ((Logger)LoggerFactory.getLogger(Linux.class)).debug(arg_0));
        StreamGobbler streamGobblerError = new StreamGobbler(process.getErrorStream(), arg_0 -> ((Logger)LoggerFactory.getLogger(Linux.class)).debug(arg_0));
        HeadlessExecutorService.INSTANCE.execute(streamGobblerInput);
        HeadlessExecutorService.INSTANCE.execute(streamGobblerError);
    }

    @Override
    public void openConsole(String absolutePath, DialogService dialogService) throws IOException {
        if (!Files.exists(Path.of(ETC_ALTERNATIVES_X_TERMINAL_EMULATOR, new String[0]), new LinkOption[0])) {
            dialogService.showErrorDialogAndWait(Localization.lang("Could not detect terminal automatically using '%0'. Please define a custom terminal in the preferences.", ETC_ALTERNATIVES_X_TERMINAL_EMULATOR));
            return;
        }
        ProcessBuilder processBuilder = new ProcessBuilder("readlink", ETC_ALTERNATIVES_X_TERMINAL_EMULATOR);
        Process process = processBuilder.start();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
            String emulatorName = reader.readLine();
            if (emulatorName != null) {
                CharSequence[] cmd = (emulatorName = emulatorName.substring(emulatorName.lastIndexOf(File.separator) + 1)).contains("gnome") ? new String[]{"gnome-terminal", "--working-directory", absolutePath} : (emulatorName.contains("xfce4") ? new String[]{"xfce4-terminal", "--working-directory=" + absolutePath} : (emulatorName.contains("konsole") ? new String[]{"konsole", "--workdir", absolutePath} : new String[]{emulatorName, absolutePath}));
                LoggerFactory.getLogger(Linux.class).debug("Opening terminal using {}", (Object)String.join((CharSequence)" ", cmd));
                ProcessBuilder builder = new ProcessBuilder((String[])cmd);
                builder.directory(new File(absolutePath));
                Process processTerminal = builder.start();
                StreamGobbler streamGobblerInput = new StreamGobbler(processTerminal.getInputStream(), arg_0 -> ((Logger)LoggerFactory.getLogger(Linux.class)).debug(arg_0));
                StreamGobbler streamGobblerError = new StreamGobbler(processTerminal.getErrorStream(), arg_0 -> ((Logger)LoggerFactory.getLogger(Linux.class)).debug(arg_0));
                HeadlessExecutorService.INSTANCE.execute(streamGobblerInput);
                HeadlessExecutorService.INSTANCE.execute(streamGobblerError);
            }
        }
    }

    @Override
    public String detectProgramPath(String programName, String directoryName) {
        return programName;
    }

    @Override
    public Path getApplicationDirectory() {
        return Path.of("/usr/lib/", new String[0]);
    }

    @Override
    public Path getDefaultFileChooserDirectory() {
        String xdgDocumentsDir = System.getenv("XDG_DOCUMENTS_DIR");
        if (xdgDocumentsDir != null) {
            return Path.of(xdgDocumentsDir, new String[0]);
        }
        try {
            Process process = new ProcessBuilder("xdg-user-dir", "DOCUMENTS").start();
            List<String> strings = new BufferedReader(new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8)).lines().toList();
            if (strings.isEmpty()) {
                LoggerFactory.getLogger(Linux.class).error("xdg-user-dir returned nothing");
                return this.getUserDirectory();
            }
            String documentsDirectory = strings.getFirst();
            Path documentsPath = Path.of(documentsDirectory, new String[0]);
            if (!Files.exists(documentsPath, new LinkOption[0])) {
                LoggerFactory.getLogger(Linux.class).error("xdg-user-dir returned non-existant directory {}", (Object)documentsDirectory);
                return this.getUserDirectory();
            }
            LoggerFactory.getLogger(Linux.class).debug("Got documents path {}", (Object)documentsPath);
            return documentsPath;
        }
        catch (IOException e) {
            LoggerFactory.getLogger(Linux.class).error("Error while executing xdg-user-dir", (Throwable)e);
            return this.getUserDirectory();
        }
    }
}

