/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.copyfiles;

import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import javafx.concurrent.Task;
import org.jabref.gui.copyfiles.CopyFilesAction;
import org.jabref.gui.copyfiles.CopyFilesResultItemViewModel;
import org.jabref.logic.l10n.Localization;
import org.jabref.logic.util.OS;
import org.jabref.logic.util.io.FileUtil;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.LinkedFile;
import org.jabref.model.util.OptionalUtil;
import org.jabref.preferences.PreferencesService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CopyFilesTask
extends Task<List<CopyFilesResultItemViewModel>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CopyFilesAction.class);
    private static final String LOGFILE_PREFIX = "copyFileslog_";
    private static final String LOGFILE_EXT = ".log";
    private final BibDatabaseContext databaseContext;
    private final PreferencesService preferencesService;
    private final Path exportPath;
    private final String localizedSuccessMessage = Localization.lang("Copied file successfully", new Object[0]);
    private final String localizedErrorMessage = Localization.lang("Could not copy file", new Object[0]) + ": " + Localization.lang("File exists", new Object[0]);
    private final long totalFilesCount;
    private final List<BibEntry> entries;
    private final List<CopyFilesResultItemViewModel> results = new ArrayList<CopyFilesResultItemViewModel>();
    private Optional<Path> newPath = Optional.empty();
    private int numberSuccessful;
    private int totalFilesCounter;
    private final BiFunction<Path, Path, Path> resolvePathFilename = (path, file) -> path.resolve(file.getFileName());

    public CopyFilesTask(BibDatabaseContext databaseContext, List<BibEntry> entries, Path path2, PreferencesService preferencesService) {
        this.databaseContext = databaseContext;
        this.preferencesService = preferencesService;
        this.entries = entries;
        this.exportPath = path2;
        this.totalFilesCount = entries.stream().mapToLong(entry -> entry.getFiles().size()).sum();
    }

    protected List<CopyFilesResultItemViewModel> call() throws InterruptedException, IOException {
        this.updateMessage(Localization.lang("Copying files...", new Object[0]));
        this.updateProgress(0L, this.totalFilesCount);
        LocalDateTime currentTime = LocalDateTime.now();
        String currentDate = currentTime.format(DateTimeFormatter.ofPattern("yyyy-MM-dd-HH-mm-ss"));
        try (BufferedWriter bw = Files.newBufferedWriter(this.exportPath.resolve(LOGFILE_PREFIX + currentDate + LOGFILE_EXT), StandardCharsets.UTF_8, new OpenOption[0]);){
            block7: for (int i = 0; i < this.entries.size() && !this.isCancelled(); ++i) {
                List<LinkedFile> files = this.entries.get(i).getFiles();
                for (int j = 0; j < files.size() && !this.isCancelled(); ++j) {
                    boolean success;
                    Path newFile;
                    block11: {
                        this.updateMessage(Localization.lang("Copying file %0 of entry %1", Integer.toString(j + 1), Integer.toString(i + 1)));
                        LinkedFile fileName = files.get(j);
                        Optional<Path> fileToExport = fileName.findIn(this.databaseContext, this.preferencesService.getFilePreferences());
                        this.newPath = OptionalUtil.combine(Optional.of(this.exportPath), fileToExport, this.resolvePathFilename);
                        if (!this.newPath.isPresent()) continue;
                        newFile = this.newPath.get();
                        success = FileUtil.copyFile(fileToExport.get(), newFile, false);
                        this.updateProgress(this.totalFilesCounter++, this.totalFilesCount);
                        try {
                            Thread.sleep(300L);
                        }
                        catch (InterruptedException e) {
                            if (!this.isCancelled()) break block11;
                            this.updateMessage("Cancelled");
                            continue block7;
                        }
                    }
                    if (success) {
                        this.updateMessage(this.localizedSuccessMessage);
                        ++this.numberSuccessful;
                        this.writeLogMessage(newFile, bw, this.localizedSuccessMessage);
                        this.addResultToList(newFile, success, this.localizedSuccessMessage);
                        continue;
                    }
                    this.updateMessage(this.localizedErrorMessage);
                    this.writeLogMessage(newFile, bw, this.localizedErrorMessage);
                    this.addResultToList(newFile, success, this.localizedErrorMessage);
                }
            }
            this.updateMessage(Localization.lang("Finished copying", new Object[0]));
            String successMessage = Localization.lang("Copied %0 files of %1 successfully to %2", Integer.toString(this.numberSuccessful), Integer.toString(this.totalFilesCounter), this.newPath.map(Path::getParent).map(Path::toString).orElse(""));
            this.updateMessage(successMessage);
            bw.write(successMessage);
            List<CopyFilesResultItemViewModel> list = this.results;
            return list;
        }
    }

    private void writeLogMessage(Path newFile, BufferedWriter bw, String logMessage) {
        try {
            bw.write(logMessage + ": " + String.valueOf(newFile));
            bw.write(OS.NEWLINE);
        }
        catch (IOException e) {
            LOGGER.error("error writing log file", (Throwable)e);
        }
    }

    private void addResultToList(Path newFile, boolean success, String logMessage) {
        CopyFilesResultItemViewModel result = new CopyFilesResultItemViewModel(newFile, success, logMessage);
        this.results.add(result);
    }
}

