/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.copyfiles;

import com.airhacks.afterburner.views.ViewLoader;
import javafx.fxml.FXML;
import javafx.scene.control.ButtonType;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.paint.Color;
import org.jabref.gui.copyfiles.CopyFilesDialogViewModel;
import org.jabref.gui.copyfiles.CopyFilesResultItemViewModel;
import org.jabref.gui.copyfiles.CopyFilesResultListDependency;
import org.jabref.gui.icon.IconTheme;
import org.jabref.gui.icon.JabRefIcon;
import org.jabref.gui.util.BaseDialog;
import org.jabref.gui.util.ValueTableCellFactory;
import org.jabref.logic.l10n.Localization;

public class CopyFilesDialogView
extends BaseDialog<Void> {
    @FXML
    private TableView<CopyFilesResultItemViewModel> tvResult;
    @FXML
    private TableColumn<CopyFilesResultItemViewModel, JabRefIcon> colStatus;
    @FXML
    private TableColumn<CopyFilesResultItemViewModel, String> colMessage;
    @FXML
    private TableColumn<CopyFilesResultItemViewModel, String> colFile;
    private final CopyFilesDialogViewModel viewModel;

    public CopyFilesDialogView(CopyFilesResultListDependency results) {
        this.setTitle(Localization.lang("Result", new Object[0]));
        this.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.OK});
        this.viewModel = new CopyFilesDialogViewModel(results);
        ViewLoader.view((Object)((Object)this)).load().setAsContent(this.getDialogPane());
    }

    @FXML
    private void initialize() {
        this.setupTable();
    }

    private void setupTable() {
        this.colFile.setCellValueFactory(cellData -> ((CopyFilesResultItemViewModel)cellData.getValue()).getFile());
        this.colMessage.setCellValueFactory(cellData -> ((CopyFilesResultItemViewModel)cellData.getValue()).getMessage());
        this.colStatus.setCellValueFactory(cellData -> ((CopyFilesResultItemViewModel)cellData.getValue()).getIcon());
        this.colFile.setCellFactory(new ValueTableCellFactory().withText(item -> item).withTooltip(item -> item));
        this.colStatus.setCellFactory(new ValueTableCellFactory().withGraphic(item -> {
            if (item == IconTheme.JabRefIcons.CHECK) {
                item = item.withColor(Color.GREEN);
            }
            if (item == IconTheme.JabRefIcons.WARNING) {
                item = item.withColor(Color.RED);
            }
            return item.getGraphicNode();
        }));
        this.tvResult.setItems(this.viewModel.copyFilesResultListProperty());
        this.tvResult.setColumnResizePolicy(param -> true);
    }
}

