/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.collab.stringrename;

import org.jabref.gui.collab.DatabaseChange;
import org.jabref.gui.collab.DatabaseChangeResolverFactory;
import org.jabref.gui.undo.NamedCompound;
import org.jabref.gui.undo.UndoableStringChange;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.entry.BibtexString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BibTexStringRename
extends DatabaseChange {
    private static final Logger LOGGER = LoggerFactory.getLogger(BibTexStringRename.class);
    private final BibtexString oldString;
    private final BibtexString newString;

    public BibTexStringRename(BibtexString oldString, BibtexString newString, BibDatabaseContext databaseContext, DatabaseChangeResolverFactory databaseChangeResolverFactory) {
        super(databaseContext, databaseChangeResolverFactory);
        this.oldString = oldString;
        this.newString = newString;
        this.setChangeName(Localization.lang("Renamed string: '%0'", oldString.getName()));
    }

    @Override
    public void applyChange(NamedCompound undoEdit) {
        if (this.databaseContext.getDatabase().hasStringByName(this.newString.getName())) {
            LOGGER.info("Cannot rename string '{}' to '{}' because the name is already in use", (Object)this.oldString.getName(), (Object)this.newString.getName());
        }
        String currentName = this.oldString.getName();
        String newName = this.newString.getName();
        this.oldString.setName(newName);
        undoEdit.addEdit(new UndoableStringChange(this.oldString, true, currentName, newName));
    }

    public BibtexString getOldString() {
        return this.oldString;
    }

    public BibtexString getNewString() {
        return this.newString;
    }
}

