/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.collab;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javax.swing.undo.UndoManager;
import org.jabref.gui.AbstractViewModel;
import org.jabref.gui.collab.DatabaseChange;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExternalChangesResolverViewModel
extends AbstractViewModel {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExternalChangesResolverViewModel.class);
    private final ObservableList<DatabaseChange> visibleChanges = FXCollections.observableArrayList();
    private final ObservableList<DatabaseChange> changes = FXCollections.observableArrayList();
    private final ObjectProperty<DatabaseChange> selectedChange = new SimpleObjectProperty();
    private final BooleanBinding areAllChangesResolved;
    private BooleanBinding areAllChangesAccepted;
    private BooleanBinding areAllChangesDenied;
    private final BooleanBinding canAskUserToResolveChange;
    private final UndoManager undoManager;

    public ExternalChangesResolverViewModel(List<DatabaseChange> externalChanges, UndoManager undoManager) {
        Objects.requireNonNull(externalChanges);
        assert (!externalChanges.isEmpty());
        this.visibleChanges.addAll(externalChanges);
        this.changes.addAll(externalChanges);
        this.undoManager = undoManager;
        this.areAllChangesResolved = Bindings.createBooleanBinding(() -> this.visibleChanges.isEmpty(), (Observable[])new Observable[]{this.visibleChanges});
        this.areAllChangesAccepted = Bindings.createBooleanBinding(() -> this.changes.stream().allMatch(DatabaseChange::isAccepted), (Observable[])new Observable[0]);
        this.areAllChangesDenied = Bindings.createBooleanBinding(() -> this.changes.stream().noneMatch(DatabaseChange::isAccepted), (Observable[])new Observable[0]);
        this.canAskUserToResolveChange = Bindings.createBooleanBinding(() -> this.selectedChange.isNotNull().get() && ((DatabaseChange)this.selectedChange.get()).getExternalChangeResolver().isPresent(), (Observable[])new Observable[]{this.selectedChange});
    }

    public ObservableList<DatabaseChange> getVisibleChanges() {
        return this.visibleChanges;
    }

    public ObjectProperty<DatabaseChange> selectedChangeProperty() {
        return this.selectedChange;
    }

    public Optional<DatabaseChange> getSelectedChange() {
        return Optional.ofNullable((DatabaseChange)this.selectedChangeProperty().get());
    }

    public BooleanBinding areAllChangesResolvedProperty() {
        return this.areAllChangesResolved;
    }

    public boolean areAllChangesResolved() {
        return this.areAllChangesResolvedProperty().get();
    }

    public BooleanBinding areAllChangesAcceptedProperty() {
        return this.areAllChangesAccepted;
    }

    public boolean areAllChangesAccepted() {
        return this.areAllChangesAcceptedProperty().get();
    }

    public BooleanBinding areAllChangesDeniedProperty() {
        return this.areAllChangesDenied;
    }

    public boolean areAllChangesDenied() {
        return this.areAllChangesDeniedProperty().get();
    }

    public BooleanBinding canAskUserToResolveChangeProperty() {
        return this.canAskUserToResolveChange;
    }

    public void acceptChange() {
        this.getSelectedChange().ifPresent(selectedChange -> {
            selectedChange.accept();
            this.getVisibleChanges().remove(selectedChange);
        });
    }

    public void denyChange() {
        this.getSelectedChange().ifPresent(arg_0 -> this.getVisibleChanges().remove(arg_0));
    }

    public void acceptMergedChange(DatabaseChange databaseChange) {
        Objects.requireNonNull(databaseChange);
        this.getSelectedChange().ifPresent(oldChange -> {
            this.changes.remove(oldChange);
            this.changes.add((Object)databaseChange);
            databaseChange.accept();
            this.getVisibleChanges().remove(oldChange);
        });
    }
}

