/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.collab;

import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javafx.util.Duration;
import javax.swing.undo.UndoManager;
import org.controlsfx.control.action.Action;
import org.jabref.gui.DialogService;
import org.jabref.gui.LibraryTab;
import org.jabref.gui.StateManager;
import org.jabref.gui.collab.ChangeScanner;
import org.jabref.gui.collab.DatabaseChange;
import org.jabref.gui.collab.DatabaseChangeListener;
import org.jabref.gui.collab.DatabaseChangesResolverDialog;
import org.jabref.gui.icon.IconTheme;
import org.jabref.gui.undo.NamedCompound;
import org.jabref.gui.util.BackgroundTask;
import org.jabref.gui.util.TaskExecutor;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.util.FileUpdateListener;
import org.jabref.model.util.FileUpdateMonitor;
import org.jabref.preferences.PreferencesService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseChangeMonitor
implements FileUpdateListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(DatabaseChangeMonitor.class);
    private final BibDatabaseContext database;
    private final FileUpdateMonitor fileMonitor;
    private final List<DatabaseChangeListener> listeners;
    private final TaskExecutor taskExecutor;
    private final DialogService dialogService;
    private final PreferencesService preferencesService;
    private final LibraryTab.DatabaseNotification notificationPane;
    private final UndoManager undoManager;
    private final StateManager stateManager;
    private LibraryTab saveState;

    public DatabaseChangeMonitor(BibDatabaseContext database, FileUpdateMonitor fileMonitor, TaskExecutor taskExecutor, DialogService dialogService, PreferencesService preferencesService, LibraryTab.DatabaseNotification notificationPane, UndoManager undoManager, StateManager stateManager) {
        this.database = database;
        this.fileMonitor = fileMonitor;
        this.taskExecutor = taskExecutor;
        this.dialogService = dialogService;
        this.preferencesService = preferencesService;
        this.notificationPane = notificationPane;
        this.undoManager = undoManager;
        this.stateManager = stateManager;
        this.listeners = new ArrayList<DatabaseChangeListener>();
        this.database.getDatabasePath().ifPresent(path -> {
            try {
                fileMonitor.addListenerForFile((Path)path, this);
            }
            catch (IOException e) {
                LOGGER.error("Error while trying to monitor {}", path, (Object)e);
            }
        });
        this.addListener(this::notifyOnChange);
    }

    private void notifyOnChange(List<DatabaseChange> changes) {
        this.notificationPane.notify(IconTheme.JabRefIcons.SAVE.getGraphicNode(), Localization.lang("The library has been modified by another program.", new Object[0]), List.of(new Action(Localization.lang("Dismiss changes", new Object[0]), event -> this.notificationPane.hide()), new Action(Localization.lang("Review changes", new Object[0]), event -> {
            DatabaseChangesResolverDialog databaseChangesResolverDialog = new DatabaseChangesResolverDialog(changes, this.database, Localization.lang("External Changes Resolver", new Object[0]));
            Optional<Boolean> areAllChangesResolved = this.dialogService.showCustomDialogAndWait(databaseChangesResolverDialog);
            this.saveState = (LibraryTab)((Object)((Object)((Optional)this.stateManager.activeTabProperty().get()).get()));
            NamedCompound ce = new NamedCompound(Localization.lang("Merged external changes", new Object[0]));
            changes.stream().filter(DatabaseChange::isAccepted).forEach(change -> change.applyChange(ce));
            ce.end();
            this.undoManager.addEdit(ce);
            if (areAllChangesResolved.get().booleanValue()) {
                if (databaseChangesResolverDialog.areAllChangesAccepted()) {
                    this.saveState.resetChangedProperties();
                } else {
                    this.saveState.markBaseChanged();
                }
            }
            this.notificationPane.hide();
        })), Duration.ZERO);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fileUpdated() {
        BibDatabaseContext bibDatabaseContext = this.database;
        synchronized (bibDatabaseContext) {
            ChangeScanner scanner = new ChangeScanner(this.database, this.dialogService, this.preferencesService);
            BackgroundTask.wrap(scanner::scanForChanges).onSuccess(changes -> {
                if (!changes.isEmpty()) {
                    this.listeners.forEach(listener -> listener.databaseChanged((List<DatabaseChange>)changes));
                }
            }).onFailure(e -> LOGGER.error("Error while watching for changes", (Throwable)e)).executeWith(this.taskExecutor);
        }
    }

    public void addListener(DatabaseChangeListener listener) {
        this.listeners.add(listener);
    }

    public void unregister() {
        this.database.getDatabasePath().ifPresent(file -> this.fileMonitor.removeListener((Path)file, this));
    }
}

